/*!
 * jQuery JavaScript Library v1.8.2
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2012 jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: Thu Sep 20 2012 21:13:05 GMT-0400 (Eastern Daylight Time)
 */
(function( window, undefined ) {
var
	// A central reference to the root jQuery(document)
	rootjQuery,

	// The deferred used on DOM ready
	readyList,

	// Use the correct document accordingly with window argument (sandbox)
	document = window.document,
	location = window.location,
	navigator = window.navigator,

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$,

	// Save a reference to some core methods
	core_push = Array.prototype.push,
	core_slice = Array.prototype.slice,
	core_indexOf = Array.prototype.indexOf,
	core_toString = Object.prototype.toString,
	core_hasOwn = Object.prototype.hasOwnProperty,
	core_trim = String.prototype.trim,

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {
		// The jQuery object is actually just the init constructor 'enhanced'
		return new jQuery.fn.init( selector, context, rootjQuery );
	},

	// Used for matching numbers
	core_pnum = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,

	// Used for detecting and trimming whitespace
	core_rnotwhite = /\S/,
	core_rspace = /\s+/,

	// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

	// Match a standalone tag
	rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,

	// JSON RegExp
	rvalidchars = /^[\],:{}\s]*$/,
	rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
	rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
	rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,

	// Matches dashed string for camelizing
	rmsPrefix = /^-ms-/,
	rdashAlpha = /-([\da-z])/gi,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return ( letter + "" ).toUpperCase();
	},

	// The ready event handler and self cleanup method
	DOMContentLoaded = function() {
		if ( document.addEventListener ) {
			document.removeEventListener( "DOMContentLoaded", DOMContentLoaded, false );
			jQuery.ready();
		} else if ( document.readyState === "complete" ) {
			// we're here because readyState === "complete" in oldIE
			// which is good enough for us to call the dom ready!
			document.detachEvent( "onreadystatechange", DOMContentLoaded );
			jQuery.ready();
		}
	},

	// [[Class]] -> type pairs
	class2type = {};

jQuery.fn = jQuery.prototype = {
	constructor: jQuery,
	init: function( selector, context, rootjQuery ) {
		var match, elem, ret, doc;

		// Handle $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Handle $(DOMElement)
		if ( selector.nodeType ) {
			this.context = this[0] = selector;
			this.length = 1;
			return this;
		}

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector.charAt(0) === "<" && selector.charAt( selector.length - 1 ) === ">" && selector.length >= 3 ) {
				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && (match[1] || !context) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[1] ) {
					context = context instanceof jQuery ? context[0] : context;
					doc = ( context && context.nodeType ? context.ownerDocument || context : document );

					// scripts is true for back-compat
					selector = jQuery.parseHTML( match[1], doc, true );
					if ( rsingleTag.test( match[1] ) && jQuery.isPlainObject( context ) ) {
						this.attr.call( selector, context, true );
					}

					return jQuery.merge( this, selector );

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[2] );

					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE and Opera return items
						// by name instead of ID
						if ( elem.id !== match[2] ) {
							return rootjQuery.find( selector );
						}

						// Otherwise, we inject the element directly into the jQuery object
						this.length = 1;
						this[0] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || rootjQuery ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return rootjQuery.ready( selector );
		}

		if ( selector.selector !== undefined ) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	},

	// Start with an empty selector
	selector: "",

	// The current version of jQuery being used
	jquery: "1.8.2",

	// The default length of a jQuery object is 0
	length: 0,

	// The number of elements contained in the matched element set
	size: function() {
		return this.length;
	},

	toArray: function() {
		return core_slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num == null ?

			// Return a 'clean' array
			this.toArray() :

			// Return just the object
			( num < 0 ? this[ this.length + num ] : this[ num ] );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems, name, selector ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		ret.context = this.context;

		if ( name === "find" ) {
			ret.selector = this.selector + ( this.selector ? " " : "" ) + selector;
		} else if ( name ) {
			ret.selector = this.selector + "." + name + "(" + selector + ")";
		}

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	// (You can seed the arguments with an array of args, but this is
	// only used internally.)
	each: function( callback, args ) {
		return jQuery.each( this, callback, args );
	},

	ready: function( fn ) {
		// Add the callback
		jQuery.ready.promise().done( fn );

		return this;
	},

	eq: function( i ) {
		i = +i;
		return i === -1 ?
			this.slice( i ) :
			this.slice( i, i + 1 );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	slice: function() {
		return this.pushStack( core_slice.apply( this, arguments ),
			"slice", core_slice.call(arguments).join(",") );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map(this, function( elem, i ) {
			return callback.call( elem, i, elem );
		}));
	},

	end: function() {
		return this.prevObject || this.constructor(null);
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: core_push,
	sort: [].sort,
	splice: [].splice
};

// Give the init function the jQuery prototype for later instantiation
jQuery.fn.init.prototype = jQuery.fn;

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction(target) ) {
		target = {};
	}

	// extend jQuery itself if only one argument is passed
	if ( length === i ) {
		target = this;
		--i;
	}

	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray(src) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend({
	noConflict: function( deep ) {
		if ( window.$ === jQuery ) {
			window.$ = _$;
		}

		if ( deep && window.jQuery === jQuery ) {
			window.jQuery = _jQuery;
		}

		return jQuery;
	},

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
		if ( !document.body ) {
			return setTimeout( jQuery.ready, 1 );
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );

		// Trigger any bound ready events
		if ( jQuery.fn.trigger ) {
			jQuery( document ).trigger("ready").off("ready");
		}
	},

	// See test/unit/core.js for details concerning isFunction.
	// Since version 1.3, DOM methods and functions like alert
	// aren't supported. They return false on IE (#2968).
	isFunction: function( obj ) {
		return jQuery.type(obj) === "function";
	},

	isArray: Array.isArray || function( obj ) {
		return jQuery.type(obj) === "array";
	},

	isWindow: function( obj ) {
		return obj != null && obj == obj.window;
	},

	isNumeric: function( obj ) {
		return !isNaN( parseFloat(obj) ) && isFinite( obj );
	},

	type: function( obj ) {
		return obj == null ?
			String( obj ) :
			class2type[ core_toString.call(obj) ] || "object";
	},

	isPlainObject: function( obj ) {
		// Must be an Object.
		// Because of IE, we also have to check the presence of the constructor property.
		// Make sure that DOM nodes and window objects don't pass through, as well
		if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		try {
			// Not own constructor property must be Object
			if ( obj.constructor &&
				!core_hasOwn.call(obj, "constructor") &&
				!core_hasOwn.call(obj.constructor.prototype, "isPrototypeOf") ) {
				return false;
			}
		} catch ( e ) {
			// IE8,9 Will throw exceptions on certain host objects #9897
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own.

		var key;
		for ( key in obj ) {}

		return key === undefined || core_hasOwn.call( obj, key );
	},

	isEmptyObject: function( obj ) {
		var name;
		for ( name in obj ) {
			return false;
		}
		return true;
	},

	error: function( msg ) {
		throw new Error( msg );
	},

	// data: string of html
	// context (optional): If specified, the fragment will be created in this context, defaults to document
	// scripts (optional): If true, will include scripts passed in the html string
	parseHTML: function( data, context, scripts ) {
		var parsed;
		if ( !data || typeof data !== "string" ) {
			return null;
		}
		if ( typeof context === "boolean" ) {
			scripts = context;
			context = 0;
		}
		context = context || document;

		// Single tag
		if ( (parsed = rsingleTag.exec( data )) ) {
			return [ context.createElement( parsed[1] ) ];
		}

		parsed = jQuery.buildFragment( [ data ], context, scripts ? null : [] );
		return jQuery.merge( [],
			(parsed.cacheable ? jQuery.clone( parsed.fragment ) : parsed.fragment).childNodes );
	},

	parseJSON: function( data ) {
		if ( !data || typeof data !== "string") {
			return null;
		}

		// Make sure leading/trailing whitespace is removed (IE can't handle it)
		data = jQuery.trim( data );

		// Attempt to parse using the native JSON parser first
		if ( window.JSON && window.JSON.parse ) {
			return window.JSON.parse( data );
		}

		// Make sure the incoming data is actual JSON
		// Logic borrowed from http://json.org/json2.js
		if ( rvalidchars.test( data.replace( rvalidescape, "@" )
			.replace( rvalidtokens, "]" )
			.replace( rvalidbraces, "")) ) {

			return ( new Function( "return " + data ) )();

		}
		jQuery.error( "Invalid JSON: " + data );
	},

	// Cross-browser xml parsing
	parseXML: function( data ) {
		var xml, tmp;
		if ( !data || typeof data !== "string" ) {
			return null;
		}
		try {
			if ( window.DOMParser ) { // Standard
				tmp = new DOMParser();
				xml = tmp.parseFromString( data , "text/xml" );
			} else { // IE
				xml = new ActiveXObject( "Microsoft.XMLDOM" );
				xml.async = "false";
				xml.loadXML( data );
			}
		} catch( e ) {
			xml = undefined;
		}
		if ( !xml || !xml.documentElement || xml.getElementsByTagName( "parsererror" ).length ) {
			jQuery.error( "Invalid XML: " + data );
		}
		return xml;
	},

	noop: function() {},

	// Evaluates a script in a global context
	// Workarounds based on findings by Jim Driscoll
	// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
	globalEval: function( data ) {
		if ( data && core_rnotwhite.test( data ) ) {
			// We use execScript on Internet Explorer
			// We use an anonymous function so that context is window
			// rather than jQuery in Firefox
			( window.execScript || function( data ) {
				window[ "eval" ].call( window, data );
			} )( data );
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	},

	// args is for internal usage only
	each: function( obj, callback, args ) {
		var name,
			i = 0,
			length = obj.length,
			isObj = length === undefined || jQuery.isFunction( obj );

		if ( args ) {
			if ( isObj ) {
				for ( name in obj ) {
					if ( callback.apply( obj[ name ], args ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.apply( obj[ i++ ], args ) === false ) {
						break;
					}
				}
			}

		// A special, fast, case for the most common use of each
		} else {
			if ( isObj ) {
				for ( name in obj ) {
					if ( callback.call( obj[ name ], name, obj[ name ] ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.call( obj[ i ], i, obj[ i++ ] ) === false ) {
						break;
					}
				}
			}
		}

		return obj;
	},

	// Use native String.trim function wherever possible
	trim: core_trim && !core_trim.call("\uFEFF\xA0") ?
		function( text ) {
			return text == null ?
				"" :
				core_trim.call( text );
		} :

		// Otherwise use our own trimming functionality
		function( text ) {
			return text == null ?
				"" :
				( text + "" ).replace( rtrim, "" );
		},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var type,
			ret = results || [];

		if ( arr != null ) {
			// The window, strings (and functions) also have 'length'
			// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
			type = jQuery.type( arr );

			if ( arr.length == null || type === "string" || type === "function" || type === "regexp" || jQuery.isWindow( arr ) ) {
				core_push.call( ret, arr );
			} else {
				jQuery.merge( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		var len;

		if ( arr ) {
			if ( core_indexOf ) {
				return core_indexOf.call( arr, elem, i );
			}

			len = arr.length;
			i = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;

			for ( ; i < len; i++ ) {
				// Skip accessing in sparse arrays
				if ( i in arr && arr[ i ] === elem ) {
					return i;
				}
			}
		}

		return -1;
	},

	merge: function( first, second ) {
		var l = second.length,
			i = first.length,
			j = 0;

		if ( typeof l === "number" ) {
			for ( ; j < l; j++ ) {
				first[ i++ ] = second[ j ];
			}

		} else {
			while ( second[j] !== undefined ) {
				first[ i++ ] = second[ j++ ];
			}
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, inv ) {
		var retVal,
			ret = [],
			i = 0,
			length = elems.length;
		inv = !!inv;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			retVal = !!callback( elems[ i ], i );
			if ( inv !== retVal ) {
				ret.push( elems[ i ] );
			}
		}

		return ret;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var value, key,
			ret = [],
			i = 0,
			length = elems.length,
			// jquery objects are treated as arrays
			isArray = elems instanceof jQuery || length !== undefined && typeof length === "number" && ( ( length > 0 && elems[ 0 ] && elems[ length -1 ] ) || length === 0 || jQuery.isArray( elems ) ) ;

		// Go through the array, translating each of the items to their
		if ( isArray ) {
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}

		// Go through every key on the object,
		} else {
			for ( key in elems ) {
				value = callback( elems[ key ], key, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}
		}

		// Flatten any nested arrays
		return ret.concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		var tmp, args, proxy;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = core_slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context, args.concat( core_slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	},

	// Multifunctional method to get and set values of a collection
	// The value/s can optionally be executed if it's a function
	access: function( elems, fn, key, value, chainable, emptyGet, pass ) {
		var exec,
			bulk = key == null,
			i = 0,
			length = elems.length;

		// Sets many values
		if ( key && typeof key === "object" ) {
			for ( i in key ) {
				jQuery.access( elems, fn, i, key[i], 1, emptyGet, value );
			}
			chainable = 1;

		// Sets one value
		} else if ( value !== undefined ) {
			// Optionally, function values get executed if exec is true
			exec = pass === undefined && jQuery.isFunction( value );

			if ( bulk ) {
				// Bulk operations only iterate when executing function values
				if ( exec ) {
					exec = fn;
					fn = function( elem, key, value ) {
						return exec.call( jQuery( elem ), value );
					};

				// Otherwise they run against the entire set
				} else {
					fn.call( elems, value );
					fn = null;
				}
			}

			if ( fn ) {
				for (; i < length; i++ ) {
					fn( elems[i], key, exec ? value.call( elems[i], i, fn( elems[i], key ) ) : value, pass );
				}
			}

			chainable = 1;
		}

		return chainable ?
			elems :

			// Gets
			bulk ?
				fn.call( elems ) :
				length ? fn( elems[0], key ) : emptyGet;
	},

	now: function() {
		return ( new Date() ).getTime();
	}
});

jQuery.ready.promise = function( obj ) {
	if ( !readyList ) {

		readyList = jQuery.Deferred();

		// Catch cases where $(document).ready() is called after the browser event has already occurred.
		// we once tried to use readyState "interactive" here, but it caused issues like the one
		// discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15
		if ( document.readyState === "complete" ) {
			// Handle it asynchronously to allow scripts the opportunity to delay ready
			setTimeout( jQuery.ready, 1 );

		// Standards-based browsers support DOMContentLoaded
		} else if ( document.addEventListener ) {
			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", DOMContentLoaded, false );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", jQuery.ready, false );

		// If IE event model is used
		} else {
			// Ensure firing before onload, maybe late but safe also for iframes
			document.attachEvent( "onreadystatechange", DOMContentLoaded );

			// A fallback to window.onload, that will always work
			window.attachEvent( "onload", jQuery.ready );

			// If IE and not a frame
			// continually check to see if the document is ready
			var top = false;

			try {
				top = window.frameElement == null && document.documentElement;
			} catch(e) {}

			if ( top && top.doScroll ) {
				(function doScrollCheck() {
					if ( !jQuery.isReady ) {

						try {
							// Use the trick by Diego Perini
							// http://javascript.nwbox.com/IEContentLoaded/
							top.doScroll("left");
						} catch(e) {
							return setTimeout( doScrollCheck, 50 );
						}

						// and execute any waiting functions
						jQuery.ready();
					}
				})();
			}
		}
	}
	return readyList.promise( obj );
};

// Populate the class2type map
jQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "), function(i, name) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
});

// All jQuery objects should point back to these
rootjQuery = jQuery(document);
// String to Object options format cache
var optionsCache = {};

// Convert String-formatted options into Object-formatted ones and store in cache
function createOptions( options ) {
	var object = optionsCache[ options ] = {};
	jQuery.each( options.split( core_rspace ), function( _, flag ) {
		object[ flag ] = true;
	});
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		( optionsCache[ options ] || createOptions( options ) ) :
		jQuery.extend( {}, options );

	var // Last fire value (for non-forgettable lists)
		memory,
		// Flag to know if list was already fired
		fired,
		// Flag to know if list is currently firing
		firing,
		// First callback to fire (used internally by add and fireWith)
		firingStart,
		// End of the loop when firing
		firingLength,
		// Index of currently firing callback (modified by remove if needed)
		firingIndex,
		// Actual callback list
		list = [],
		// Stack of fire calls for repeatable lists
		stack = !options.once && [],
		// Fire callbacks
		fire = function( data ) {
			memory = options.memory && data;
			fired = true;
			firingIndex = firingStart || 0;
			firingStart = 0;
			firingLength = list.length;
			firing = true;
			for ( ; list && firingIndex < firingLength; firingIndex++ ) {
				if ( list[ firingIndex ].apply( data[ 0 ], data[ 1 ] ) === false && options.stopOnFalse ) {
					memory = false; // To prevent further calls using add
					break;
				}
			}
			firing = false;
			if ( list ) {
				if ( stack ) {
					if ( stack.length ) {
						fire( stack.shift() );
					}
				} else if ( memory ) {
					list = [];
				} else {
					self.disable();
				}
			}
		},
		// Actual Callbacks object
		self = {
			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {
					// First, we save the current length
					var start = list.length;
					(function add( args ) {
						jQuery.each( args, function( _, arg ) {
							var type = jQuery.type( arg );
							if ( type === "function" && ( !options.unique || !self.has( arg ) ) ) {
								list.push( arg );
							} else if ( arg && arg.length && type !== "string" ) {
								// Inspect recursively
								add( arg );
							}
						});
					})( arguments );
					// Do we need to add the callbacks to the
					// current firing batch?
					if ( firing ) {
						firingLength = list.length;
					// With memory, if we're not firing then
					// we should call right away
					} else if ( memory ) {
						firingStart = start;
						fire( memory );
					}
				}
				return this;
			},
			// Remove a callback from the list
			remove: function() {
				if ( list ) {
					jQuery.each( arguments, function( _, arg ) {
						var index;
						while( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
							list.splice( index, 1 );
							// Handle firing indexes
							if ( firing ) {
								if ( index <= firingLength ) {
									firingLength--;
								}
								if ( index <= firingIndex ) {
									firingIndex--;
								}
							}
						}
					});
				}
				return this;
			},
			// Control if a given callback is in the list
			has: function( fn ) {
				return jQuery.inArray( fn, list ) > -1;
			},
			// Remove all callbacks from the list
			empty: function() {
				list = [];
				return this;
			},
			// Have the list do nothing anymore
			disable: function() {
				list = stack = memory = undefined;
				return this;
			},
			// Is it disabled?
			disabled: function() {
				return !list;
			},
			// Lock the list in its current state
			lock: function() {
				stack = undefined;
				if ( !memory ) {
					self.disable();
				}
				return this;
			},
			// Is it locked?
			locked: function() {
				return !stack;
			},
			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				args = args || [];
				args = [ context, args.slice ? args.slice() : args ];
				if ( list && ( !fired || stack ) ) {
					if ( firing ) {
						stack.push( args );
					} else {
						fire( args );
					}
				}
				return this;
			},
			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},
			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};
jQuery.extend({

	Deferred: function( func ) {
		var tuples = [
				// action, add listener, listener list, final state
				[ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ],
				[ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ],
				[ "notify", "progress", jQuery.Callbacks("memory") ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				then: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;
					return jQuery.Deferred(function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {
							var action = tuple[ 0 ],
								fn = fns[ i ];
							// deferred[ done | fail | progress ] for forwarding actions to newDefer
							deferred[ tuple[1] ]( jQuery.isFunction( fn ) ?
								function() {
									var returned = fn.apply( this, arguments );
									if ( returned && jQuery.isFunction( returned.promise ) ) {
										returned.promise()
											.done( newDefer.resolve )
											.fail( newDefer.reject )
											.progress( newDefer.notify );
									} else {
										newDefer[ action + "With" ]( this === deferred ? newDefer : this, [ returned ] );
									}
								} :
								newDefer[ action ]
							);
						});
						fns = null;
					}).promise();
				},
				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Keep pipe for back-compat
		promise.pipe = promise.then;

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 3 ];

			// promise[ done | fail | progress ] = list.add
			promise[ tuple[1] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(function() {
					// state = [ resolved | rejected ]
					state = stateString;

				// [ reject_list | resolve_list ].disable; progress_list.lock
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );
			}

			// deferred[ resolve | reject | notify ] = list.fire
			deferred[ tuple[0] ] = list.fire;
			deferred[ tuple[0] + "With" ] = list.fireWithe[0] to the object
					"With" ] = linActuaect
			( num <ibutors
 IE and Opera return i/							ill kee: 0;

	lbacn=== true  tuples = [					 :
				era retu,pera return iecial, fastillprogdetanull ? era retu;ifunctionaion( new helprredw /* fnDone, fnFsubwindoing;ail, ...,FsubwindoingNar fns = a			whh = elemsct | noVDeferrall( arguments, 2 );
		proxy, core_.length;
ct | noVDefer jquery od[ resor propuntdler t			// HadFsubwindoingslemsctmain ];

	efined && t1ay = Fsubwindoing;nction( returned.promisubwindoing
										re?	efined number  resor prmt Timaion( new.videct | noVDeferrototeparateonce a ( dataaion( new,ndefinuses and. {};

		// Keepctmain ];

& t1a?Fsubwindoing;:ed();

		// Catch ber  resoUpding;args ) {
t
		p
		ect | notto thst.add
	( exec ) {updingrnedata ) {
			mei		var tmp			fn = sn jQuery.inArray ) {
			me		return exec.cvar tmp	 ) {
						then: fa Defer ) {
			th,
		deep = fal >t1a?Fl( arguments ) ) );
		};

		/:			}
		}

		 tr(	fn = sn
& thst.add
Vn = sn jQuery.e( argumentt.firegumentvar tmp			fn = sn {
						fire(  {
			( --ctmain ];
)n jQuery.e( argumentocument, [ jQvar tmp			fn = sn {
						[ i ^ To know uple[1].add
Vn = s,thst.add
Car tmp			ocumentCar tmp	 i/					listener lis					ion( new subwindoings;rays
	utors
sisArected ]
== true  = fal >t1a jQueryhst.add
Vn = snbject(  ) > -			fire(;ueryhst.add
Car tmp	nbject(  ) > -			fire(;ueryocumentCar tmp	nbject(  ) > -			fire(;ueryngth; i++ ) {
				value = callba&& jQue | noVDefer ) {
	nction( returned.promise | noVDefer ) {

										returned.se | noVDefer ) {

							.done( ner.resolupdingrnedmei		ocumentCar tmp	,ect | noVDeferr).progressr.rejec argumentoc				.progressDefer.notifupdingrnedmei		hst.add
Car tmp			hst.add
Vn = sn j// Get a				newDefer[--ctmain ];	},
		// Actual i/					iring then
		ons
				ontriy			di,ect | noor prmt Tim== true !ctmain ];
)n{ {};

		// Ktocument, [ jQocumentCar tmp	,ect | noVDeferr) iecial, null ? era retu		},
				// Gready.ion( retentLoad= 					// state fire vtentLoacorea			lena	len;
		}
	lenop
	leninpu
	lendNodes )	lencallsN
			leni	lenisS return 	lencumekFnse;

i// GentElemen parsed[1] ) ]"
i/")a deep Prelimdoirye.js c )
i/.setAt [ bu

	t"objecN
		 jQut resul
i/.inlisthe r= "  <link/><stack></stack><a href='/a'>a</a><inpu
ing" =' firsbox'/>"a de	ill Gei/.agName( "parsererror""*tch(eal Gei/.agName( "parsererror""a")	fn =h(ea.stylntsssTn = tm"top:1px;f isF:} ca;opacity:.5"a deep C)
		df exbasQued"
 *tentLoaist ) {
a "stri
a "				fire( stacnull ? tend jQuery  to fi ( firatedentLoase.js c );
		}
/ GentElemen parsed[1] ) ]";
		}
tch(eop
 text;
		arguiseC},

(GentElemen parsed[1] ) ]" || !sp: funcinpu
i Gei/.agName( "parsererror""inpu
")	fn =h( );entLoad= {
l throwfunctpsing whit removed (IEfirin.inlisthe rse {
			//ng whitWemoved (I:dEvei/.s = tC},

Query.isWi
& t3  ber  hat DOM nodes and tt leassh it ontd. Theautomaticd firinseurn 
l throwfcripts seurget[ ormatt
	selestackc ) tt le: !ei/.agName( "parsererror""tt le") jquery od[ hat DOM nodes and linkassh it onf exseuialalueFl( e jQuerbirinlisthe 
w, strir topqu1
	r a wrrguire matched seew AcarseSeuialalu: !!ei/.agName( "parsererror""link") jquery od[ hatmatched stylnd seeded
) {
t		emgetAt [ bu

d[ hatle iucumetsssTn = 						iprogstyln: /top/) {
			a.getAt [ bu

]";tylnp: f od[ hat DOM nodes and URLontd. Themaniss2typdd[ hatle idy evealu		locbllback liproghrefNy evealud:dEva.getAt [ bu

]"href"
	},

	/a" f od[ hat DOM nodes and  matchedopacityast, ind[ hatle iucumefilion
jQue		iprogck by Da			matcad, ork on finDa	WebK		if oneeadyWai5145lenopacity: /^0.5/) {
			a.stylntopacityaf od[ hatVeuire
stylndf isFast, iefunctihatle iucumestyln& isF
						if ( sss& isFprogsss& isF: !!a.stylntsss& isF od[ hat DOM nodes and irinoe		retuor #id
			if ( maa  firsbox
 the valid		diument
	// s"!sp tried (WebK		iiument
	// s""
jQue		iprog firsOn:ringIpu
.ck( ele{
			n" f od[ hat DOM nodes and aext;
		ed-by-back lis *
 * Bcurre, orkhit xt;
		ed/ Make sure that(WebK		iiument
	// sns.sto						if ( lude se itoo,ction
	ac i ]t of gn fp)lenop
St;
		ed: of .xt;
		ed od[ hatT"
 *tetAt [ bu

st ob,

	nodeNobjec.vide		i orks,d the calectoFixeack retdohit get/tetAt [ bu

s(ie6/7)lengetSetAt [ bu

:vei/.objecN
		) {
		t" od[ hatT"
 le lisefung" );entLoadontrvar o(#6743)lenefung" : !!entElemen parsed[1] ) ]"ar o") efung"  od[ hat DOMs nodesfrag	disabparse5tly into toMs n
		e also Mablpass the Wt).reou

sthe rse {if ( !me
	// Ststript orks Acarse5Cragm:GentElemen parsed[1] ) ]"na/").fragm	par	},

	//.ou

sthe r {
		<:na/></:na/>" od[ hation( retentLoa.boxM	} elDEPRECATEDc i 1.8 ( d(IEferough, ;entLoadQu1
ks M	} d[ boxM	} e:dEventListense.pipM	} le{
		CSS1Ce.pip" f od[ hatW in thiery.isFuationrogsubmitBubackc: lude rog fthe Bubackc: lude rogfntL( dBubackc: counter};

/ HaExpto o: lude rognoCragm", jQ: lude roginlineB			/N casLayou
: counter};shrinkWrrgB			/c: counter};relitackMajectR	} e: lude rogboxSiz	diRelitack: lude rogpixelPos obje: count
elf;
}hat DOM nodes firsew statusthe proke e ifragmdncinpu
. firsew  ( ; listtentLoa.noCragmCfirsew  (inpu
. ragm	par	},

	//. firsewf;
}hat DOM nodess ready
	bject-formsi} ltion() { xt;
		ontd. Themark		isArtion() {
that(WebK		imarksget[ osArtion() {) );
		}
.tion() {  ( ; listtentLoa.bjeDion() {  (e ||.tion() {f;
}hatT"
 *document in
	acep copy)

			seetlback xpto o
t		emantly intouery  g isFilorer
			// We use an/ Use th	seetlbei/. {
	nd j			xml = undefintentLoa.

/ HaExpto of ( list ) jQuetypeof i/.er ) {
			// Use red i/.enload", jQ red i/.o th", jQ ndefin i/.enload", jQuery.cumekcallumekFn{
			return fn.applep Crag	disadow oight aw Theined sS hacn=== lep ents
	ady occuan bestle itoMs // SprogrtentLoa.noCragm", jQ  ( list ) {= nullei/.obagm	par	},

	//.o th", jQ(ry.cumekc nullei/.ningad", jQuery.cumekcallumekFn{)nd jQuery de to lbackion o maincts state
 if ( v			lhas buery: rguisect
				proDOMncinpu
i GentElemen parsed[1] ) ]"inpu
")uncinpu
.ck( ele		t"uncinpu
.setAt [ bu

	t"ng"  jQuion o resultentLoa.ion oVk( ele	gIpu
.ck( ele{
		t"a deinpu
.setAt [ bu

	t" firsew jQu firsew  )a deep #11217 -	WebK		ilocume firsts ready
	{
				swser event  firsew at [ bu

d[inpu
.setAt [ bu

	t"n
		 jQut resuul
i/.rguiseC},

(Ginpu
iesularsed.fra GentElemen parseDntElemeta ], conesularsed.frarguiseC},

(Gei/.n, tC},

 )a deep WebK		iioMs Thei	targ firsew stateFl( e jQuerin be creatsultentLoa. firsCjQuery.arsed.fra ragm	par	},

	//. ragm	par	},

	//.n, tC},

. firsewf;
}hatde to lbackChrisnli		ed/ firsboxfcriptrects #ate
	firsew
}hatck( el ( ludewser evrguisect
				proDOMtle 6/7)letentLoa.rguiseC}irsew  (inpu
. firsewf;
}arsed.fraon() {C},

(Ginpu
iesularsed.frarguiseC},

(Gei/ )a deep Tech.has( t		emJuriy Zaytsevblogs.java.nke fbacks kripsLoadeargec
			-ady o-tentLoa- argou
arsing
	-sniffhitedeep Weeonce c arraentt have a is a then
n-s browse	ady ocsys pass 	prox true ss2typuerin IEeadhLoa-circus
				a thehelpe {

		s 	provoidback lst
		lis(in*tetAt [ bu

) rem $(don	e alsoCSP evento gberryw theadyWjquerysa.ndadyloke .mozripa		if en/S				ity/CSP eaddEvei/.enload", jQ fn.app ) {
				jQ{rogrtebmit: lude rogg fthe : lude roggfntL( d:= pass =}fn.applcallsN
		 
			n" +
		}

	isS return d= 	 callsN
		 	if i/ )a lba&& jQ!isS return dreturned
i/.setAt [ bu

	tcallsN
			ata ) )(;sync = "fisS return d= 	 = "striniv[ callsN
		 ]" && ( !options.inable = 1;tentLoa[
	fir"BubackceWitheisS return  iecia the modiune.js css reae caleat leaa	iioctop = fat);
// 		return fn.appre vvar ts ist,niv
	/dsut sjectDiv

ned
i/Res= 0,
"per 			:0; sject:0;bwiner:0;Chrplay:b			/;sS hf iw:hidde(;sy == no// IfentElemenagName( "parsererror""t le")[0 != null ) !turn setTime/odified o actient.ae	iioccss reaough, een caat le
ry.inArra iecial, var ts is/ GentElemen parsed[1] ) ]"
i/")a , var ts is.stylntsssTn = tm"vicopin( t:hidde(;bwiner:0;width:0;he	} e:0;pos obje:static;top:0; sject-top:1px"unc no//.s seurBmaybe(vvar ts ist,no//.s = tC},

rn i/						totype, Diego "
 *ly intoue

i// GentElemen parsed[1] ) ]"
i/")a , var ts is.rguiseC},

(Gei/ )a de}hatde to lbastack ce				stripteen coffae	Width/He	} ets ready
yrox t {
			vento Chrplay:ns pasject
	ns bounstripttors
 vicop(parsack ce				 i ]			ventsack sin; lbaso,coffae	Width/He	} etathen
		relitacko actu is a s
 resolvget is					fmantly intod right awhidde( Che jQueru: func by Chrplay:ns pa(		if nstriptiframate "inoffae	s lbackpalock: matched ss the hidde(;aougtifraty gbggln cache
eo fog #4512o actmunctioeeded
) {)re that(once e i8ss ] s TypeEresuery.ti/.inlisthe r= "<stack><tr><td></sd><td>t</sd></tr></stack>"unc /dsi Gei/.agName( "parsererror""td")a , /ds	fn =.stylntsssTn = tm"per 			:0; sject:0;bwiner:0;Chrplay:ns p"unc isS return d= 	 =ds	fn =.offae	He	} ety.isAr)a de}/ds	fn =.stylntChrplay tm""a , /ds	f1 =.stylntChrplay tm"ns p"unde}hatde to lba
	selestack ce				stripteen coffae	Width/He	} ectihatle i<=i8ss ]  TypeEresuery.tentLoa.ielitackHidde(Offae	s heisS return | stac=ds	fn =.offae	He	} ety.isAr)a de}hatde to box-siz	dicache sjectmore tiorry.ti/.inlisthe r= ""nullei/.stylntsssTn = tm"box-siz	di:bwiner-box;-moz-box-siz	di:bwiner-box;-webkit-box-siz	di:bwiner-box;per 			:1px;bwiner:1px;Chrplay:b			/;width:4px; sject-top:1%;pos obje:absolu

;top:1%;"nulltentLoa.boxSiz	did= 	 ei/.offae	Widthty.is4.inabltentLoa.
oMsNotI passeMajectInBo//Offae	d= 	 no//.offae	Top && t1a)a de}hatNOTE:e caddedfutodesmaincts ist,we'vngs (and.agNCe.ps trStylnde}hatbwe alsojsd	emugtow os cod in t	}
	  argou
#atry.isFuncs (and.agNCe.ps trStyln setTimetentLoa.pixelPos objed= 	 s (and.agNCe.ps trStyln(,niv
	ret[ reip thady"op && t"1%"nullltentLoa.boxSiz	diRelitackd= 	 s (and.agNCe.ps trStyln(,niv
	ret[ reip t width: "4px" hadywidthty.is"4px"e state
	de to lbaei/  arguex1 );		i idthte
			/e sject-		} elis a e jQuestate
	overzce.ps tre sject-		} elngs by Ji idtht "strints is. Factmuncstate
	ioeee
eo fog #3333state
	 g isFiloWebK		i maybe Feb 2011 nle Bliec ) {ep WebK		iBog 13343 -	agNCe.ps trStyln  *
 */
jwrodidck( el actmsject-		} e ) { sjectDiv/ GentElemen parsed[1] ) ]"
i/")a , { sjectDiv.stylntsssTn = tmei/.stylntsssTn = tm
i/Res= a , { sjectDiv.stylntmajectR	} edefisjectDiv.stylntwidthty "0"nullldiv.stylntwidthty "1px"unc l
i/.rguiseC},

(G sjectDiv/)nullltentLoa.relitackMajectR	} e = = "f!) ) && isFi 	 s (and.agNCe.ps trStyln(, sjectDiv
	ret[ reip thadymajectR	} ed) iecial, ntext === "sdiv.stylntzo	em&& t"{if ( !mendle it asynde to lbatrim fuerb			/-ladylassh it ontnt callbinline-bples[ i synssh it ons reas= t// we sir Chrplaymate'inline'te
		giv func resor pm layou
nc resole i<i8stoMs // Sprogrti/.inlisthe r= ""nulllei/.stylntsssTn = tm
i/Res= 0ir"width:1px;per 			:1px;Chrplay:inline;zo	e:1"nullltentLoa.inlineB			/N casLayou
d= 	 ei/.offae	Widthty.is3IE and not de to lba
sh it onsargulayou
 shrink-wrrgwe sir 	},

rshouldesole i6stoMs // Sprogrti/.stylntChrplay tm"bples"nulllei/.stylntsS hf iw tm"vicople"nulllei/.inlisthe r= "<ei/></ei/>"nulllei/.s = tC},

Qstylntwidthty "5px"unc ltentLoa.shrinkWrrgB			/cd= 	 ei/.offae	Widtht!.is3IE and nvar ts is.stylntzo	emturn chainabhatNet[ 
sh it onlbacvoidbl}
	sd seew Acno//.on() {C},

(Gvar ts is/)a , var ts is tm
i/  ( dsi G sjectDiv/ Gpromise})a deep Net[ 
sh it onlbacvoidbl}
	sd seew Aarsed.fraon() {C},

(G i/ )a l	ill Ga text;
		ory &&  (inpu
ry.arsed.fr tm
i/  (promis
};
jQueryentLoajQuenesu fn.a {

	  (/(?:\{[\s\S]*\}|\[[\s\S]*\])$/y =r.
 *
Dash  (/([A-Z])/gy.promise erred: fu	optio:uates a

/ HadIds: call
 callbacks feae x	imaje ready ev (1.9/2.0prouind a0ive Stri.has( tlisems tined sngth !== 
		} elpag( v			Non-digate
n't handt/e s firrinlineth !==
	expto o: "th !==" +
igger ) {
		 are tr+len + rto om;
	}
, "" );
	/\D/g	// reive StrTarameters:
 *
sh it onl( msgun		xmltackdcertain hoslbayous 	proe using thlist xpto o
 own.

		va				prm.n() D html it " DOMd": lude rog	prBaes are point bcertai tlisFlash (rem $(rry 4.7 xpto oSprog		for ( :t"obsnd D27CDB6E-AE6D-11cf-96B8-444553540000sy =="rgumet":= pass tes a riD html, key, value )dle it ue )d=.toLowerCa.isWi( parsed.f] || ctoLo[romise erpto oe;
	:ctoLo[ romise erpto odeferr;
			}
		ue )dcall functiD htsoft.XMLue )dl;ifunctid html, key, value )ame ] )  scrippvt;ailIonly
	maby DOnce r fns = asReady ) {

	 fn,ptD htalue )dlefn.apply( conn chainab
				/ S ] ||	// A	lengtonly
	mKeument);
// erpto o	lengagNByN
		 
	 === "s{
			
		( optionsber  resoWe the presrry 4.7window objectsJS pass throiffecallbacbwe alsoIE6-7r  resot)
		dGConsCacherefecalcee proke e ia to s		proDOM-JS ents
ary}

	isN	} le.toLowerCa.isWber  resoOnce window obje callentsnter fth !== f] ||;sJS pass tl JSON
	r  resoenloadcalChe jQuer				promise: remoGCoded owe oeautomaticd find nv ConverisN	} l( parsed.f] ||	:ctoLober  resoOnce f ( !	disabpID tlisJS pass thrt in
s	optionalled atst, in the o	r  resor propd presshLoacut 
		} elal hapathterre,window onsargunon creat

	idverisN	} l( toLo[ tonly
	mKeum
	:ctoLo[ tonly
	mKeum
	bj )only
	mKeust-specifvoidbdohit ddedmunct ork  Fire the callbas readryoptionsf ex JSONontri-specimise: rs rea rign thJSONnd a || jQuery(!uid++;!f] || idions((!pvt;call(] || idi.hJSO)_has agNByN
		 red = t && jQuery.isFufn.apply( conn chainab&& jQ!itionally, funnce window obje calaject(f.has( ID tlisems t matched( d(IEe sir C= t[ i synsindiup		has: f
	// Worcreat

	i{
			fN	} lreturnedtoLo[ tonly
	mKeum
	erildFragment(

/ HadIds.pop()d++;

		return proxet a				newDeferidverionly
	mKeust Actual i/		&& jQ!f] || ci		}
	ewDefef] || ci		}
ep pipe fpecifvoid bcepos ptith !== meta JSONont"" 	haJS pass thrs ready
	mise: funce
	isxseuialalueF	breakta );optionify lba&& jQ!isN	} lreturnedf] || ci		}y"o.JSONFragment(() {st Actual i/		ecif By defad
		proxhtml stonsagment(
JSON
					if ( aGet;/ck( elpair; TypeEgeind[ hatshthe opine	if sS haon				prost, imodifireat

ntext === "s{
			
		( 	for ( i !== "stri{
			
		(  !options.ieturnentextpvt;returnedf] || ci		}ment);
// ermise )f] || ci		}eturn eloxet a				newDeferf] || ci		}ytrim( data );
ermise )f] || ci		}. scripurn eloxet aual i/			/ S ] ||rall] || ci		}st-specith !==  scrfter t
funcdontextons thatBy defadrmsi} ldy
	mise: 	ac inly
	maC= t[ iesot)ch				ifinernlbacvoidbet;
callico hosbetwt aw inly
	maC= tjectsug
	-ery.isFnc by Cvali/		&& jQ!pvt;returne&& jQ!	/ S ] ||.indow[ "eval"	/ S ] ||.indoweach( oerred[ r	/ S ] ||ral	/ S ] ||.indon chainab&& jQng" ) {
	Query.isFufn.appl	/ S ] ||[ parsed.f]

	node(turn ele}menindon chainabot de to t
		p
		ec from ed-to-f]

	te
			/n-c from edQng" ) Make suturn nd[ hatIbackCg" ) Make sutred
#id
			ifnab&& jQagNByN
		  {
					ry  to fiTry interinDas-he proke ty C= t[ i  = 0,
	/ S ] ||[ alse )ipe fpeciT"
 *tablerom|Query.isFuproke ty C= t[ i && jQuercument.do {
						eciTry interinDhave a

	nodeFuproke ty
	 i  = 0,
	/ S ] ||[ parsed.f]

	node(turn ele}oxet aual 				newDefe = 0,
	/ S ] || iecial, null ? arg is for n't haD html, key, value )ame ] ) pvt;ailIonly
	maby DOnce r fns = asReady ) {

	 fn,ptD htalue )dlefn.apply( conn chainab
				/ S ] ||	/i, lber  risN	} le.toLowerCa.isWber  resodyWaagment(
JSON actmunctioeeded
) {nd nv ConverisN	} l( parsed.f] ||	:ctoLobe

	idverisN	} l( toLo[ romise erpto ode;:ed();

	erpto oevent modelt
	ns id
		fired,non crea		} ry red
				/se {
		lt
	ns id
noent mopurposction ck to  func && jQ!f] || ci		}
	ewDefey( conn chainab&& jQn
		  {
						/ S ] ||ralpvt;?ll] || ci		};:ef] || ci		}. scrk ) {
				/	/ S ] ||r {
						eciS returrn reton oed (IEons that weturn surn n red

JSONet;c ) {
					y ) {

			  ) > -n
		  { {
							esorryched sturn serre,et;
 maybe ddedmaniss2ty) {nd nab&& jQn
		 in/	/ S ] ||r {
	d nab	{
			
 [ alse )ip nab	 				newD	d nab	hatsace Dhave a

	e a id romco hcblled (Ie {ildd
	e,et;
 argumented (Ie st, ind[ nab	{
			
 parsed.f]

	node(turn elip nab	b&& jQn
		 in/	/ S ] ||r {
	d nab		{
			
 [ alse )ip nab							newDefer[ a{
			
 se();nction(i, ip nab			
nab			
nab	d execu ) {
			=: i :	
 se();{
				val				fin( elems[i], 	seetlb	/ S ] ||[ alse[i] )ip nab}						ecidelt
	ns id
n thJSON} ca		has: fc] ||	/eturanng th ck to e					ecie
		letas: fc] ||By defadrt Add f ex "
 roybj is p {
			( pvt;?l functiD htsoft.X;:ed();

	 functisoft.X;)	/	/ S ] ||r {n obj != null ?	},
		// Actual i/					dyWaagment(
JSON actmunctioeeded
) {nd && jQ!pvt;returne	seetlbf] || ci		}. scrk ) {
onaiugh,  "
 roy	} elparist an ||r{ildd
	heir
inly
	maC= tjmise: funce
	h	ifht awiscoveuer			dis} ca		hait lba&& jQ!isunctiD htsoft.XMLf] || ci		}
	e jQuery.inArrast Actual i/		eciD"
 roy	} elfireat

ntextisN	} lreturneparsed.fringD htal ctoLo	}et,

	//event moby D	seetlbs reas return |tlisexpto oSon o`firea` id
n d aes (and uire) ) {
		 (#10080pro		fire(  {
		ion( retentLoa.

/ HaExpto ofns( n ||r!all] ||.s (and returne	seetlbf] || ci		}event moW retut[ 
sferrg is
	ret[ual 				newDefef] || ci		}menpromise(vert dashedFage only
	map:coveuei/	_d html, key, value )ame ] )  scre( stacnull ? agment(
JSOalue )ame ] )  scrip,

	//evbal GUID coand setred

vget is					fma,window on
		prry 4.7= linscreexpto otion( ptD html, key, value )dle it  = 0, D htle.toLowerCaN
		 redagment(()D falstoLowerCase() === name.toLow}event moow objen( ptinscre{ildd
	orun again#id
			if;fy ] = ons( 		prox		}
 objecttacnull ? !, D htl||0, D htl {
	,

	/th -1 ].getAt [ bu

]"objecid"
	},

, D ht;y.ready.promise fn erred: fu	d html, key, val
						return exe = 0ying			hof t at [ame ] ) 		lengue )d=.	/ Smpty lba&h = elemsindoweapromis
} hatmatn the key && typeof key && jQuery.isFufn.appl				/	/ S				fire( stack.trim( data );
d htalue )dllue != null toLowerCa.isWi
& t1acallata );
_
JSOalue )am") ) &dAt [s"r {n obj != at [le.toLowat [ bu

then: fa ) {
	ll Gat [;{
				val				fin( elems[i], a{
			
 at [[i].{
		;D	d nab	&& jQ!se();arr, el( "
JSO-"r {n obj != b	{
			
 parsed.f]

	node(turn etebsturn (5)dllue != ck.trimAt [alue )ame ] )  scr[ alse )  ip nab			
nab			
nab		ata );
_
JSOalue )am") ) &dAt [s"ip,

	//evb
		// ActuDefey( connindon chainabot es
		i
 *
 * Pkey && typeof  "object" ) {
			for ( i in key			},
				t funct				// state = [ ata );
d htaled ] )et;
	st Act) iecial, ying	 
			ispace ),"." = functioing	dd;
= oing	dd;
?,"." + oing	dd;
: ""nullp					foing	dd;
+ "!"oxy;
	},

	/ elems, fn, i, ed ] ) ) {
			me		return eappl				/ck( ele{
					first[ i++ ] =trim( d			t turgger		if (ery.getD ht" + oing );
oing	dre;
	llue != eciTry intee firddedadd and fir
funcdo
JSON to fe != null  = t && jQuery.isFuth -1 ]elems[i], 	rim( data );
d htalue ) )et;
	st Ac, 	rim( dtrimAt [alue )am
				 scre(ip nab}						y( connindo && jQuery.isFuth oing	dd;
?t Ac, 			t d htaloing	dre; ? fn( e	 = true;
}					oing	dd;
= 		}
		}

				t funct				// state = [ re vtAdd a , value 				/llue !=  thisturgger		if (ery.setD ht" + oing )ying	 (ip nabata );
d htaled ] )et;		fn = null;
		 thisturgger		if (ery. fthe D ht" + oing )ying	 (ip nat) ieci
	ret[able, empth,
		deep = fal >t1
	ret[ab If IE evs for n't haD html, key, valuery.acces			},
				t funct				// state = [;
					}
t haD htaled ] )et;
	st A}ery.ready.pollCheck()rimAt [alue )am
				 scre(te =ecidele
			disred
fnts
	add and fi,orrychntee firdde
 by Cval
			empty:the 5 Cval-* at [ bu

d[iull  = t && jQuery.isFuth -1 ]werCa.isWi
& t1arn eapp = 0,
		 
		
JSO-"r+			is, "" );
	r.
 *
Dasham"-$1"ady"o);

// All jQ
, 	rim( d-1 ].getAt [ bu

]turn elip typeof  "objec = t && j		tmp = fn[ conte Use the 	rim( dtrimle{
		t

	"
?,,

	/: the 	rim( 		(  If I"
?, If IE: the 	rim( 		( ret["
?,nt.do:e != eciOnce c from  optio lengtrt in
iioMs Thei	the ched sturn e != +	rim(+// r newDrim(? +	rim(:e != a {

	) {
			 scre(t( parsed.) ) &.JSO		 scre(t fn( e	 = true;
}			xml = undered[ reso DOM nodesw t {
7= linscreemovedis Thei	the Fuationrog	ata );
d htalue ) )et;		 scre(ipual 				newDefe	rim( d

		// Simulate
}			y( connindon }tring firssom th ||By defadtlisenct/ SsspollCheck(isunctiD htsoft.XMLeturn obj = 0,
		mul ) {
	n
		 in/eturn ob
					iri} elpublicaC= tjmise:  id

	selaspect iivt)
 *		stript
	selnab&& jQn
		  		( d ht" nction( retuunctisoft.XMLetu[n
		}
	e jQuery ck to emulate
b&& jQn
		  {
		to.JSO i in key			},
	 list ) {=e
}			y( conn ; lis}promise erred: fu	queueml, key, value )amng"    scre( stac = 0queueip typeof -1 ]elems[i]type( anction"||0"fx i i+//queue"unc lqueue( data );
_
JSOalue )amtion"E and not Sp calup

vqueue(by f e
				out0quickuerif 				/		/definaing
kupappl				/indow[ "eval"&& jQ!queue(++;

		ret		  ) > hJSO)elems[i], queue( data );
_
JSOalue )amtionacks("memmDOM  ) > hJSO)elip nab}				newDefer[queue
					} scre(ip nab}	nab}	naby( connqueue(++; [ convert das
vqueueml, key, value )amng" elems[itype( ation"||0"fx ;
tac = 0queue( data );
queuealue )amng" elpending"rtlength;
	queue
ldex of cu;
				queue
		}
			f cu;hg
ks( data );
_queueHg
ksalue )amng" elpendinn = tmp			// state = [ ata );
dequeuealue )amng" elrue;
}event modelt
	 fx0queue(		// queued,		windowed)
		fpect is.add
	s	} ene|| jQuery
			{
		inery.Callbles = [						queue
		}
			;ending"rtlength						ainab&& jQurn jQund not  or a  is.add
	s	} ene| optr calls t
	 fx0queue(			emuery:nd not automaticd fir/ queuedappl				/	ion" && ( x// Inspectqueue
un		}
				inery.Callblerue;
}					ing le= 0upts curred:queue({
		ess: functine	seetlbhg
ks {
		;= [			 :
				leng,ae x	,bhg
ksd) iecial, ntext!ng"rtlength;ncthg
ksd)Inspechg
ks 
	sel.o th()ise(vert dashedn d add sect
 ) {publicaototum*
 * B-	agncutinsom queueHg
ks/se {
		lor  *
 */
jngth
					vavered_queueHg
ksml, key, value )amng" elems[i = 0t" ) mng" e+//queueHg
ks"ferr;
			}
ata );
_
JSOalue )amuery.a++;

		ret_
JSOalue )amuer,n.applc() {
	ks("once memory"), "rejected" ]) {
					// state = [ ;
					}
t haD htalue )amng" e+//queue"ip,

	//evb
		;
					}
t haD htalue )amuer,n,

	//evb
	})t A}ery.ready.promise fn erred: fu	queueml, key, valng"    scre( stac = 0s= tis tm2ip typeof  "objecng" ) {
								// Inspectrim( d	g" ;s[i]type( a"fx ;

		 t tis						ainab&& jQth,
		deep = fal <0s= tis  in key			},
	ata );
queueal	/ Smptymng" elrue;ial, null ? e= t && jQuery.isFu?}

				tt fn( 			t funct				// state = [ re vqueue( data );
queuealed ] )ng"    scre(lue != eciack can ohg
ksdred
				/queuevb
		;
					_queueHg
ksaled ] )ng" dllue != null 	ion" && ( x//nctqueuedre;!{
		inery.Callbles = [	[ ata );
dequeuealed ] )ng" dllu nab}	nab} evs fos
vqueueml, key, valng" elems[i			},
				t funct				// state = [;
					dequeuealed ] )ng" dllu n} evs fos	prBas by ffhen firipluectmoy Clese
Hthiers,d argupet isco h.blogs.java.nblindsignd sLoadearr, .php/2009/07/ are t-	setT/ a

/ayml, key, valni] ) ng" elems[iti			
 parsed.fx0? parsed.fx.sp cas[lni] tions(ni] t:(ni] ;s[itype( ation"||0"fx ;
tac			},
				t queuealeg"   efer ) {
			x	,bhg
ksd)te = [
				llChec textrollCheck,		x	,bni] tllu nahg
ks {
		 tmp			// state = [  le= ollCheck,	llChec lrue;
}ev n} evs fos le= Queueml, key, valng" elems[i			},
				t queuealeg" "||0"fx ,; [  evs fos	prfor this deferected ]
	s reaqueuesf ( aGcom  	haeg" s 	prox tenct/]
	(fx0i
jngtheg" "bllback liproion( obj ) {
					reg"   eturn obj 
				mp rogg puntd t1= {};

		/ red();

		// Catch 	lengue )it on d			ty lba&h =	/ S				firelemsct | no tmp			// state = [  {
			( -- puntd)elems[i], d
											, [ jQue )it o,l ctoLoit on]dllu nab}	nab}ip typeof  "objecng" ) {
								// Inspecetur d	g" ;s[i]type( a

		// Simulate
itype( ation"||0"fx ;
tac = jQuei--elems[i]tmp( data );
_
JSOalue )it o ) {
,mng" e+//queueHg
ks" )a lba&& jQtmp(trinmp 
	sel;returnedfpuntproxet 	nmp 
	sel) {
	ect | nooloxet aual imsct | no()ise(null ? era r);
};

// Populat.ready. = 0, deHg
kt,noolHg
kt,fixSid
			ify =robjec  (/[\t\r\n]/callrnull ?  (/\r/callrtype( a/^(?:button|inpu
)$/i	lerfntL(tackd= /^(?:button|inpu
|se {
	|xt;
		| tmpox a)$/i	lerlumektackd= /^a(?:x a|)$/i	lerbString = /^(?:autofntL(|autoplay|async| firsew|cven cas|era r|tion() {|hidde(|ng
	|i
 *
 * |ope(|fireveue|opqu1
	d|scoped|xt;
		ed)$/i	legetSetAt [ bu

( data );
tentLoa.getSetAt [ bu

y.promise fn erred: fu	at [j ) {
					re ] ) 		return exe	},

	/ elems, fn, i, ed ] ) elems, t [ame ] ) le, empth,
		deep = fal >t1E evs for n't haAt [j ) {
					re ] y.acces			},
				t funct				// state = [;
					}
t haAt [aled ] )urn elip n} evs for prokj ) {
					re ] ) 		return exe	},

	/ elems, fn, i, ed ] ) elems,prokame ] ) le, empth,
		deep = fal >t1E evs for n't haProkj ) {
					re ] urn exe{
			
 parsed.prokFix[ alse ) ||0,
		muls			},
				t funct				// state = [esorry/		xmlprry 4.se a iss a theIE balksd(suchisArect h	disadproke ty  Ji i(andprogre Use the 	/ Sm alse ) 			if ( !memory )	seetlb	/ S[ alse )ip na}			xml = undere n} evs for  {
Cbjec:y ) {
			me		return exere vvbjecN
		s	/i, lbctoLobe

	xtrCbjec, calluip typeof ion( returned.promi		return in key			},
				t funct				// st urn obj !=, value 				/l. {
Cbjecmi		ret :
			ed ] ) 
	// S.objecN
		) (ip nat) iecip typeof 		retutring" jecck( ele{
								// InspecvbjecN
		s
= 		}
	space ), function( _,lue != ) {
			=: i :	
 	/ S				firval				fin( elems[i],ue )d=.	/ Sm/ defe = [  {
		-1 ]werCa.isWi
& t1arn e	= [  {
			-1 ]wobjecN
		)trivbjecN
		sp = fal 
& t1arn e	= [ 	-1 ]wobjecN
		)= 		}
		}e	= [ 					newDefer[ xtrCbjec( a" "r+	-1 ]wobjecN
		)+a" "lue != ck ) {
	c	=: i c:	
 vbjecN
		sp = fal;	c	<llui c( elems[i], aing ) {trCbjec;arr, el( " "r+	vbjecN
		s[	c	])+a" "ele<sAr)ems[i], ai xtrCbjec(+=	vbjecN
		s[	c	])+a" ";s[i], ai	});
				}
					-1 ]wobjecN
		)= rg );
		rim) {trCbjec	}
				return this;
tual i/					},
				then for n't haCbjec:y ) {
			me		return exere vn't hac, cbjecN
		bctoLob callu	/i, lip typeof ion( returned.promi		return in key			},
				t funct				// st urn obj !=, value 				/l.n't haCbjecmi		ret :
			ed ] ) 
	// S.objecN
		) (ip nat) iecip jQuery(		retutring" jecck( ele{
								/.a++;ck( ele{
					first[ i++ ] n't hac( ancck( el||0""adypace ), function( _,lue != ) {
			=: i :	
 	/ S				firval				fin( elems[i],ue )d=.	/ Sm/ defe= [  {
		-1 ]werCa.isWi
& t1ath -1 ]wobjecN
		) {
							objecN
		)= (" "r+	-1 ]wobjecN
		)+a" "}
, "" );
	robjec,a" "ellue != cesong
		sS haems tit[ ormjngthn't hal: functiock ) {
	c	=: i c:	
 n't hacp = fal;	c	<llui c( elems[i], acallbacks unt]  Ty	ns id
n 			disto n't ha fns[ i  = jQ{
	cbjecN
		;arr, el(" "r+	n't hac[	c	])+a" ") >=sAr)ems[i], aiobjecN
		)= cbjecN
		;, "" );
	" "r+	n't hac[	c	])+a" " ,a" "ellu);
				}
					}
				-1 ]wobjecN
		)= 		}
	0? parsed.	rim) objecN
		) {: ""null this;
tual i/					},
				then for tbgglnCbjec:y ) {
			me		ret, stateValrn obj 
				ype( ationjecck( ey lba&sBStr( ationjecstateValre{
		bString"ip typeof ion( returned.promi		return in key			},
				t funct				// st irn obj !=, value 				/l.tbgglnCbjecmi		ret :
			ed ] )i
	// S.objecN
		, stateVal), stateValrnip nat) iecip ty			},
				t funct				// state = [null 	ion" && (						// InspectventogglnngInividist
	bjec	urn nd[ xere vvbjecN
		 fns[ i&h = elems// Add a , value 				/lelems// ring;

				/Val,						objecN
		s
= 		}
	space ), function( _,lue !=  = jQ{
	(objecN
		)= cbjecN
		Sm/ ( e])elems[i], ing firssems tibjecN
		) kee:,oed (IEons that w functiock ring;

&sBStr(? stateF:g ) ) ) {
CbjecmiobjecN
		) ;lems// Add[ stateF? " {
Cbjec"{: "n't haCbjecdeferobjecN
		) ;lems/}						fire(  {
			ion" && ({if ( !mend !== "sre{
		bString"w[ "eval"&& jQ// S.objecN
		elems[i], ing
funcrobjecN
		)lbaset= [	[ ata );
_d htaled ] )"__objecN
		__"
	// S.objecN
		e(ip nab}						ventogglnnwholcrobjecN
		 the 	/ SwobjecN
		)= 	/ SwobjecN
		)++;ck( ele{
	 If IE?0""a: ata );
_d htaled ] )"__objecN
		__"y.a++;""null re n} evs for  {
Cbjec fnDone, fnFst;
		orurn exere vvbjecN
		( a" "r+	st;
		oru+a" "y lba&h = elems:	
 	/ S				firv
ryngth; i++ ) {fin( elems[i]&& jQ// S[i].{rCa.isWi
& t1ath (" "r+	// S[i].objecN
		)+a" "}
, "" );
robjec,a" ");arr, el( objecN
		ele>=sAr)ems[i],y( conn ; liss;
tual i/					},
	 list ) jfor ck(:y ) {
			me		return exere vhg
ks	// A	 turned.pro	lengue )d=.	/ Smpt!= null ) !th,
		deep = fal lems[i]&& jQ-1 ]elems[i],hg
ks( data );
		rHg
kslstoLow= "sr]a++;

		ret		rHg
kslstoLowerCase() === name.toLow}eventi]&& jQhg
ks(th .get"
jQQhg
ks(th ( = 0,
hg
ks getalue )am"		ret"y.)) {
	Query.isFufn.appl, null ? arg isnab}						 = 0,
toLow		}
		}e	= [y( conn ionjecuercum& (						//?s[i], ingrry 4.7mosheinmmugtiturn s a isappl, nul
, "" );
ry( con	// (t fn( e	ingrry 4.7 a iss a the		retuor nt.d/Query ablerengtappl, nulcument.do?0""a: arg isnatuDefey( con iecip typurned.pro( data );
turned.promi		retur;
tac			},
				t funct				// st irn obj !re vval,					 Add a , value// Spk ) {
				/	/ S.{rCa.isWi!& t1arn e	= [inArrast Actu) {
				/purned.pro(ate = [ rel
= 		}
	s:
				ed ] )i
	) ) )		}() (ip nat				newDeferrel
= 		}
	st Actu) {
eciTrs
	unt.d/Query.isFuas;""n c from  erengtva			sturn e !=peof 		rcument.do {
	eferrel
= ""null rfire(  {
			ionjecck(( 		( reengt"o {
	eferrel
+= ""null rfire(  {
		 ) {

			  ) > -valrn  {
	eferrel
= ks("memmDp(		r  efer ) { me		return exec.c			},
	ck( ele{ent.do?0""a: ck( el+ ""null therue;
}					hg
ks( data );
		rHg
ksls			t t "sr]a++;

		ret		rHg
ksls	/ S.{rCase() === name.toLow}eventi model {
7 *
 */
j{if ( !me
	fthe  list				y eveas= t// e !=peof !hg
ks(++;!]";
t"
jQQhg
ks.a++;hg
ks {etaled ] )		r  "		ret"y.le{
					first[ i++ ] =	/ S.ck( ele	ck(null re n} evs eady.promise erred: fu			rHg
ksml it bject-ml it egetml, key, value )dle it  resoenl[ bu

t.		retuor 				first[jQQB" )kngtry 4.7 bu
nc rresoucumet		}
	sadyWai6932d[ xere vrel
= toLowat [ bu

t.		}
	st Accnull ? !rel
++;ck(.#id
			if ?
toLow		}
		:ctoLo. tmpnull re n}	len;
		}
ml it egetml, key, value )dle it  rre vrelu|	/i, max,	bject- fns[ i&rr, 
= toLowxt;
		edIrr,  fns[ ifn = sn
 callns[ ibject-fo= toLowbject-fllns[ ibn le.toLow	ion" && (	t;
		-s p"unde}abhatN
			disred
xt;
		edenti]&& jQ&rr, 
<sAr)ems[i], null ? promise();}						venLg
		l( mughacks withxt;
		ed/bject-fenti]&le.bn l?Q&rr, 
: 0ise();maxle.bn l?Q&rr, 
+t1a:/bject-f				firv
ryryngth; i++ ) maxfin( elems[i],  *
 * B=/bject-fm/ defe = [ 
onaiugh, null ? jject-fo and ar ltion() { age oackChrn() { af gn fpfns[ i&& jQjject-wxt;
		ed(th (ata );
tentLoa.bjeDion() { ?(e ||ct-wChrn() { :/bject-.getAt [ bu

]"Chrn() {"
	},

,rom_hass[i], ai(e ||ct-wparistN	} wChrn() { ++;!agment(()Case()jQjject-wparistN	}   "af gn fp"y.)) {
							s	prfor mented
		jQueck( el actdy
	bject-						sck( ele	, value  *
 * B))		}();							s	prWerough, e calanrn reto actbn lxt;
		o						s&& jQjn|r {
	d nab					},
	ck( elu);
				}						s	prM
 *
-St;
		s null ? anrn ret						sck( es
					}fn = null;
				
nab	d execury  txeacBog #2551 --ext;
		a		}() brok aw ieIE ser eveede				eta)
			s&& jQjn|rcallvDefer jqueryrcalbject-f				firr)ems[i], null ? , value  *
 * fm/ rr, 
]B))		}();	nab	d execu			},
	ck( ethen: ow uplesetml, key, value ),e		return exec.re vrelu|s
= ks("memmDOM  ) > i		retur;
tac!=, valueue )/.o d: " || !sp: funct				// state = [ =	/ S.xt;
		ed( data );
tn  ) > i, value// Sp)		}()		fn = sn j>=sAnull theru
			s&& jQlvDefer jqueryrate = [ =toLowxt;
		edIrr, ( d-1null this;
u			},
	ck( ethen: o
e(vert dashedUnrue c i 1.8,s} ca		hasolectoFn-s bbngtvawugh,  ie;wed)
		f i 1.9u	at [Fn:uates aat [j ) {
					rue )ame ] ) relu|	/pjec	}n exere vn'	,bhg
ks,
n 	xml,				n.isWi
	-1 ]werCa.isWevent moough, get/tetoenl[ bu

t 
		}	x	,binmm		vae
		enl[ bu

oow ob
[  {
			-1 ] ||0,.isWi
& t3 ||0,.isWi
& t8 ||0,.isWi
& t2n in key			},
 iecip typeof pjec	nction( returned.promiromise fn[ alse )    in key			},
	ata );alue )dl[ alse )	}fn = null;
ainabot F memory optr 
		s reaenl[ bu

t athen
		s return 
	ypeof  "objec-1 ].getAt [ bu

" && ({if ( !mend in key			},
	ata );
r 
		rue )ame ] ) relu|null;
ainabn 	xmlweap.isWi!& t1a++;!agment(isXMLDocalue )dllue !/astillenl[ bu

t athel nam a ie !/asGrab e n, iiryehg
k  {
jn|r		// I.isFnc && jQn 	xmlw in key{
			
 se();"o);

// All jQ			hg
ks( data );
enl[Hg
kslsalse ) ||0( rbString) {
			e ] urn?,noolHg
k :/, deHg
kd) iecial, ntextrelu|n {
	Query.isFufn.ae !=peof 		r ele{
	nt.do {
	efer;
					}
t haAt [alue )ame ] null;
					},
 iull rfire(  {
		hg
ks(th .set"
jQQhg
ks(th n 	xmlwth ( = 0,
hg
ks setalue )amrelu|	/e ] nu)) {
	Query.isFufn.appl,null ? arg ip nat				newDefertoLowxttAt [ bu

]turn , ck( el+ ""null;
					},
 		}
	st Actu) {rfire(  {
		hg
ks(th .get"
jQQhg
ks(th n 	xmlwth ( = 0,
hg
ks getalue )ame ] nu)) {
	nt.do {
	efenull ? arg ip n 				newD	d n = 0,
toLowgetAt [ bu

]turn elip tyv			Non-st, ieftoenl[ bu

t null ? prom,d they evealumate n/ I.isFnc enull ? argle{
	nt.do?s[i],Query.isFu:l;
					;
e(vert dasn't haAt [j ) {
					rue ),e		return exe = 0y 
	N
		, enl[N
		s	/urn , &sBStry lba&h = ;al, ntextrelu|nth -1 ]werCa.isWi
& t1arn eapp	enl[N
		s
= 		}
	space ), function( _,lue != ) {
	i++ ) enl[N
		s.{
				value = callba{
			
 at [N
		Sm/ w}eventi]&& jQe ] urn exe	ryhstpN
		)= rg );
	prokFix[ alse ) ||0,
		muls	ba&sBStr( arbString) {
			e ] urfe = [ 
onadyWai9699|tlisexpland
) {
of 				/approms t(s= t// w to faspecnhn't hal) = [ 
onaiuen
		do 				/t
		p
tring enl[ bu

t (
eo #10870)fns[ i&& jQ!&sBStr( {
	d nab	ata );
enl[	rue )ame ] ) ""null;
				}
				-1 ]wn't haAt [ bu

]tgetSetAt [ bu

(?	e ] u:0y 
	N
		urfe = [ 
onadytFl( e sp	}
 / wproke ty / sns.stot
		p
tring enl[ bu

tfns[ i&& jQ&sBStr(th o 
	N
		uin -1 ]elems[i], dtoLo[ o 
	N
		u) 		 list ) {				
nab	d n: o
e(vert dasenl[Hg
ks:ems[itypeml it esetml, key, value ),e		return exec.	prWert)
		dthe opngtheg" "proke ty / srox		the Fu(( d(IEi		e alsso Mablpasw ieIE)
			s&& jQrtype) {
			toLowerCaN
		 )nth -1 ]wparistN	} les = [	[ ata );
error	t"ng" "proke ty t)
		drox		the F"null;
			fire(  {
			ata );
tentLoa.ion oVk( elth ck( ele{
		ion o rredagment(()Case()jue )am"inpu
")elems[i], ingS= t// we sheg" "ontrvion o buttonwser event ck( el			etsvent ck( el ieIE6-9s[i], ingRes= 0ck( eltoin
	acback lision  ev eg" "isxsetwser ev if ( vi], ingT			/		/tlisematched parsct-						re vrel
= toLowck( elu);
		toLowxttAt [ bu

]t"ng"  jQfn = null;
			peof 		rcrn e	= [ 	-1 ]wck( ele	ck(null 			}
							},
	ck( elu);
	d n: o
e(v rog	prby Dent ck( elproke ty t
		pory se.piprog	prby Dent , deHg
kdt
		puttonwtoLoit on ieIE6/7 (#1954)
	sck( eml it egetml, key, value ),Qe ] urn exe	r&& jQn deHg
kdredagment(()Case()jlue )am"putton"r {n obj != null ? p deHg
k getalue )ame ] nunull this;
u			},
	n
		uin -1 ]e?
= [ 	-1 ]wck( el fn( e	promise()},it esetml, key, value ),e		ret,Qe ] urn exe	r&& jQn deHg
kdredagment(()Case()jlue )am"putton"r {n obj != null ? p deHg
k setalue )amrelu|	/e ] nunull this;
uonaiuMs n
		;
jQueryoo and tetAt [ bu

sid
		so {
			// 	-1 ]wck( ele	ck( liss;
tual is for prokFix:ems[itab rr, :t"nabIrr, "er};rereveue: "n'adOncesy =="t
	 :t"arseF
	 y =="objec :t"objecN
		 j
);max{
				:t"maxlength j
);ce			pacing:t"oe		Spacing j
);ce		per 			:t"oe		Per 			"er};row	pan: "nowSpan j
);col	pan: "colSpan j
);{
	map: "{
	Map j
);ient.bwiner: "ient.Bwiner j
);codd srn ittack: "codd srE ittack"vs for prokj ) {
					rue )ame ] ) relu|nun exere vn'	,bhg
ks,
n 	xml,				n.isWi
	-1 ]werCa.isWevent moough, get/teto own.

		va
		}	x	,binmm		vae
		enl[ bu

oow ob
[  {
			-1 ] ||0,.isWi
& t3 ||0,.isWi
& t8 ||0,.isWi
& t2n in key			},
 iecip tyn 	xmlweap.isWi!& t1a++;!agment(isXMLDocalue )dllue !&& jQn 	xmlw in keyry  tx/e ] ne
		enlms thg
ks key{
			
 rg );
	prokFix[ alse ) ||0,
		muls	hg
ks( data );
prokHg
kslsalse ) iecial, ntextrelu|n {
	Query.isFufn.ae	r&& jQhg
ks(th .set"
jQQhg
ks(th ( = 0,
hg
ks setalue )amrelu|	/e ] nu)) {
	Query.isFufn.appl,null ? arg ip nat				newDefernull ? ( toLo[ alse ) 		fn = null;
	}ip n 				newDe	r&& jQhg
ks(th .get"
jQQhg
ks(th ( = 0,
hg
ks getalue )ame ] nu)) {
	nt.do {
	efe,null ? arg ip nat				newDefernull ? toLo[ alse )iss;
tual is for prokHg
ks:ems[itabIrr, ml it egetml, key, value )dle it  resotoLow	abIrr, iioMs The	windowed	},
			eFl( e jQ	fn = ns reaiea ri
		droenuex1 );		fir
e
nc rreso.java.nfluidpro {
			if blog/2008/01/09/f e
			-s= t// -e
	-ect h	di-tab rr, -ck( et- arg-javascript/
				re venl[ bu

N	} le.toLowgetAt [ bu

	par	"tab rr, ")	}e	= [y( connenl[ bu

N	} lth enl[ bu

N	} .#id
			if ?exe	ryh ) &IjQueenl[ bu

N	} .relu|	/1Ar)e fn( e	rfntL(tack) {
			toLowerCaN
		 )n||0rlumektack) {
			toLowerCaN
		 )nth -1 ]whref ?exe	ry	0e fn( e			if ( !memory tual is eady.pesoHg
kdt
		p
tring enl[ bu

tfnoolHg
k =e itgetml, key, value ),Qe ] urn exe/astiign	p
tring enl[ bu

t  argul( e sp	}
 / wproke ti nd[ hatFthe  list			enl[ bu

op			ed(IEfa theso] up
tringt athen
		s return 
	yre venl[N	}  ory proke ty =	ata );
r 
		rue )ame ]  )ise(null ? proke ty ={
	,

	/ !== "striproke ty !{
		bString"w stacenl[N	} le.toLowgetAt [ bu

	par	n
		) (lth enl[N	} .erCaVelu|n {
	 If IE? key{
		 === name.toLow fn( 	if ( !memor},itsetml, key, value ),e		ret,Qe ] urn exe = 0y 
	N
		;
!=peof 		r ele{
	 If IE in keyry lbacks p
tring enl[ bu

t   reas=  / sns.st
	er;
					}
t haAt [alue )ame ] null;
t				newDefe/atck( eli
jn

	/( d(IEferkn opreadyhe poese
n
	aceg" "b
tring e
			/tsns.st
	eronadytFp
tring enl[ bu

t 				proal hae ] ne
		 {
7= liwindproke ty
	 ihstpN
		)= rg );
	prokFix[ alse ) ||0,
		muls	peof p 
	N
		uin -1 ]elems[i],eciOnce  {
7= liIDLted
		jQud firt in
ialled atst, in 
		} eltoLoit 	// 	-1 ][ o 
	N
		u) 		 ; liss;
tu

		toLowxttAt [ bu

]te ] ) {
		 === name.toLow) iecip j			},
	n
		evs eay.pesoIE6/7 doen
		s retur f e
			/s= t// wso] uenl[ bu

t  arguget/tetAt [ bu


 {
			getSetAt [ bu

(rn eapfixSid
			if =e ity{
		: lude rogid: lude rog owins:= pass ta deep by Den		/tlisddedenl[ bu

o ieIE6/7
 ingT			/ftxeacalmosheev!== IE6/7 issass n deHg
kd data );
		rHg
ks.puttonw=e itygetml, key, value ),Qe ] urn exe	re vn'	; key			le.toLowgetAt [ bu

	par	/e ] nunull null ? argl stacfixSid
			if[ alse ) ? arg.relu|n {
	""a: arg.#id
			if ) ?exe	rarg.relu|n fn( e

		// Simulat	len;
tml, key, value ),e		ret,Qe ] urn exe	onadytF	prost, imodilis parselaject(enl[ bu

oow oexe	re vn'	le.toLowgetAt [ bu

	par	/e ] nunull  {
			n'	l {
	efe,nul  GentElemen parseAt [ bu

]turn elip;
		toLowxttAt [ bu

	par	/n'	l mory tualrnull ? ( arg.relu|n= ck( el+ ""null;
}s ta deep dytF idthte
		he	} et			eutoin					if ( 0 
		
	sel;sturn (cBog #815Ar)
 ingT			/		/tlisn't hals
 ata );
eunct[r"width jQuhe	} e"{
,m				// st i,Qe ] urn exeata );
enl[Hg
kslsalse )  data );
ermise )ata );
enl[Hg
kslsalse ),l it esetml, key, value ),e		return exec.peof 		r ele{
	"bles = [	[ toLowxttAt [ bu

]te ] ) "euto"null;
						},
	ck( elu);
	d n: o
e(v evs )a deep dytFcodd srn ittack / sns.stoonhn't hals(#10429)
 ingS= t// weo	
	sel;sturn 	l( mwsmantlrrorserreaw ihalidv if ( vata );
enl[Hg
ks.codd srn ittack =e itygetmlp deHg
k get	len;
tml, key, value ),e		ret,Qe ] urn exe	peof 		r ele{
	"bles = [	[relu|n=   If I"mory tualrp deHg
k setalue )amrelu|	/e ] nunull}s ta tu
pesoSo] uenl[ bu

t opqu1
	extoid
	st
		lisoseew  {
			ata );
tentLoa.hrefNy evealuFufn.apata );
eunct[r"href jQusrc jQuwidth jQuhe	} e"{
,m				// st i,Qe ] urn exeata );
enl[Hg
kslsalse )  data );
ermise )ata );
enl[Hg
kslsalse ),l it egetml, key, value )dle it  rre v = 0,
toLowgetAt [ bu

]turn  = functi enull ? argle{
	nt.do?	Query.isFu: arg isnatue(v evs )a tu
 {
			ata );
tentLoa.styln setTiata );
enl[Hg
ks.styln =e itygetml, key, value )E in keyry lbll ? 				first[jQQhave a isof	
	sel;sturn  keyry Ny evealumatel nam a i/( d(IEIE entam a is css) Make suturn nd[ rnull ? toLo.stylntsssTn = === name.toLow||0

		// Simulat	len;
tml, key, value ),e		reto {
	efenull ? ( toLo.stylntsssTn =n= ck( el+ ""null;
}s ta }tringSafari mis-ectLoasvent back lisxt;
		ed(proke ty  fmantbject-	/astfn, i// we shparist'd
xt;
		edIrr, iproke ty ttxeacit
 {
			ata );
tentLoa.bjeSt;
		ed(setTiata );
prokHg
ks.xt;
		ed( data );
ermise )ata );
prokHg
ks.xt;
		ed,e itygetml, key, value )E in key = 0yin.fr tm-1 ]wparistN	} k ) {
				/yin.fr le it  ryin.frwxt;
		edIrr, unde}abhat DOM nodes and n
ialsot orkt  arguaf gn fps,e
eo #5701exec.peof yin.frwparistN	} les = [	[ yin.frwparistN	} wxt;
		edIrr, un);
	d n: o
e( null ? promise(}vs )a tu
esoIE6/7 		lised(eg" "ed(o
 / 
 {
			ata );
tentLoa.ed(eg" "setTiata );
prokFix.ed(eg" "=  ed(o
 / "a tu
esoRon objects firsboxeacg= tis/s= tis
 {
			ata );
tentLoa. firsOnufn.apata );
eunct[r"ion o ,y. firsbox"{
,m				// strn exeata );
		rHg
ksls	/ S	}
ep it egetml, key, value )dle it  resoHry 4.7= li a i/fa theiloWebkn
i""niowed	},
st[jQ				if ( "on"r	fma,ck( eli

		d#id
			ifnab rnull ? toLo.getAt [ bu

]"		ret")le{
	nt.do?	"on"r: toLowck( elu);
tue(vevs )a tuata );
eunct[r"ion o ,y. firsbox"{
,m				// strn exata );
		rHg
ksls	/ S	}
epata );
ermise )ata );
		rHg
ksls	/ S	},e ity;
tml, key, value ),e		reto {
	efe {
		 ) {

			  ) > -valeturn in keyenull ? ( toLo. firsew( data );
tn  ) > i, valueue )/.		}()		fn = ele>=sAr)mory tual is )a tdy. = 0reedeElpasw= /^(?: tmpox a|inpu
|xt;
		)$/i	lereg" urn np

	  (/^([^\.]*|)(?:\.(.+)|)$/y =rhsS hHlist (/(?:^|\s)hsS h(\.\S+|)\b/y =rkeyEv.fr tm/^et;/y =r.ouseEv.fr tm/^(?:.ouse|cventmplemu)|lumek/	lerfntL(Morph tm/^(?:fntL(ioeetL(|eetL(outblur)$/y =hsS hHlist (, key, valuvit onrn exe	},

	/ elems,uvit .oid
	st.hsS h ?
tvit on:
tvit o
, "" );
	rhsS hHlis,y..ouse srnr$1 .ouseleave$1"ad;s ta d/*
 *
Hthuire, key, vsl actmsnag:
 *
vit on--en
		p				ori} elpublicaadd af

	)
 *
Prokt 			Ding Edwains'hlisEv.fr library red
mddedori} elideas)
 */
 elems,uvit 
ep ir  {
ml, key, value )amng" s,erry 4.r)  scripst;
		orurn eexe = 0ue )Dscripuvit Hry 4.ipuvit fllns[faspn] )ng"   urn np

	s,erry 4.Objf cu;hry 4.ObjIn,erry 4.rs,e
id
	stevent moiugh, enlms t
vit on				yD htlactdtmp/inmm		vaow obj(the op"" 	hapass thrtho)
!=peof -1 ]werCa.isWi
& t3 ||0-1 ]werCa.isWi
& t8 ||0!ng" s ||0!rry 4.r(++;!]ue )Dscr( data );
_
JSOalue )y.)) {
	key			},
 iecip tyot dthe.r( 		ppjec	i? anrmise:   "stustoml JSON
n lieudori} elrry 4.r
!=peof rry 4.r.rry 4.r( {
	keyhry 4.ObjIn0,
hry 4.r;	keyhry 4.r0,
hry 4.ObjIn.hry 4.r;	keyst;
		oru,
hry 4.ObjIn.st;
		or iecip tyot  DOM nodes and } elrry 4.ra riga(f.has( ID, {
		 interin/ed)
		f tuationrogpeof !hry 4.r.urn ( {
	keyhry 4.r.urn ( data );
urn proxetip tyot Ine DhavetoLoit 'd
uvit 
stuuctodesectsmainerry 4.r) if 				/		/t
	 fto fe !
vit on=0ue )Dscr,uvit s;
!=peof !uvit onrn exe	ue )Dscr,uvit sn=0uvit sn=0ch( oe}e !
vit Hry 4.7=0ue )Dscr,rry 4.;
!=peof !uvit Hry 4.7rn exe	ue )Dscr,hry 4.7=0uvit Hry 4.7=0, key, valudle it  resoDiscain withxt		}

uvit 
 ( aG elems,uvit .turggertrnry it  resos reaen
uvit 
is 		licalaer evalpag(a rigunloadifnab rnull ? = "stri elemsm&& t"{if ( !mend sta!e(++;

		retuvit .turggercal&& tew	ion) ?exe	r	

		retuvit .Chrp	xml.rguly(0uvit Hry 4..ue )amth,
		deer)e fn( e		if ( !memory t; keyry  or ue )yriga(proke ty  fm} elrry 4.Qurnoptr calls ajected"bl}
	  arguIE 	/n-trim f0uvit sexe	uvit Hry 4..ue )7=0ue )oxetip tyot Hry 4.7i
 *
 * Puvit snons that wbyextoi

	
specith !==(...).b d: ".ousesS h .ousesut ,yfn)moryng" s = rg );
		rim) hsS hHlis(ng" s)adypace )," "ellu); ) {
	th = ;	th<mng" s.{
				vatue = calns[f-fo= reg" urn np

	
erecf  "obs[t] )n||0 [ conitype( atn	dd; coniurn np

	s( anctn	d2]l||0""adypace ),"." dypLoa();					 modelcalls 		the sin
s	ng"   uy Dent oid
	st
calls rry 4.rsl actdy
			the Fueg" s eysid
	st
=/ elems,uvit .oid
	st[ t "sr]a++; pipe fpecidel {;
		oruf ( !me
	
vget ist oid
	st
calls apireg"   erun again kee:ueg" s eytype( anc {;
		oru? oid
	st.

/ ghat.isWi: oid
	st.b d:Tg" "se !== "sipe fpeciUpdrseloid
	st
bas by njectlyl			etueg" s eysid
	st
=/ elems,uvit .oid
	st[ t "sr]a++; pipe fpecihry 4.Obj
is html stons	lisealls rry 4.rs	keyhry 4.Obj
epata );
ermise  it  rtypemleg"  it  rourgTypemlen	dd; it  rd html scriit  rrry 4.r:erry 4.r)it  rgind ahry 4.r.urn ,					 Ad
		or:c {;
		or,					e casCventmp:c {;
		ordredagment(expr. s fi.e casCventmp) {
			st;
		orur,					ern np

	: urn np

	s.join(".")
			},
hry 4.ObjInelip tyv			Ine Dhavetalls rry 4.r0queue(	f we're/t
	 fto fe !	rry 4.rsl=0uvit s[ t "sr]null  {
			rry 4.rsllems[i],hry 4.rsl=0uvit s[ t "sr]n
 ca;s[i],hry 4.rs.

/ ghatCpuntd t0unde}abhatOnce uy DlisEv.frL, iefis/enlms Ev.fr iri} eloid
	st
callss rry 4.r0 *
 */
jns.st
	er ntext!nid
	st.	etupa++;nid
	st.	etup :
				leng,adscripurn np

	s,euvit Hry 4.7rne{
	 If IE in keyog	prBrinDhave
	// Wotalls rry 4.r0				prosoLoit 	// 	=peof -1 ]wlisEv.frL, iefiscrn e	= [ 	-1 ]wlisEv.frL, iefis	reg"   uvit Hry 4.ip If IE eve	= [ 	fire(  {
		eoLowat ms Ev.fr rn e	= [ 	-1 ]wlt ms Ev.fr(	"on"r+reg"   uvit Hry 4.	}
				return this;
tuull  {
		nid
	st.listrn e	= [nid
	st.lis :
				leng,ahry 4.Obj
eru
			s&& jQlhry 4.Obj.hry 4.r.urn  rn e	= [ hry 4.Obj.hry 4.r.urn  =ahry 4.r.urn ;urn this;
tuull ry  or 				prosoLoit 's rry 4.r0 fun, 

/ ghatc	i? front lba&& jQst;
		orurn exe],hry 4.rs.pace);
	hry 4.rs.

/ ghatCpunt++,: i hry 4.Obj
eru [ 	fire(  exe],hry 4.rs.					}hry 4.Obj
eru [ 	uull ry Keep trlist fmwhis t
vit onthe pev!=droenu{
		,/tlisevit 
 ptimizrsct-				 elems,uvit .
	// W[ t "sr]n
  ; liss;ip tyot Nullify ue )yoptr calls ected"bl}
	on ieIE
ngue )d=.promise for 
	// W:uates aeciD"lms ten
uvit 
o 0s= sof	
vit on			emanosoLoit 	/ed)
		ml, key, value )amng" s,erry 4.r)  {;
		or,smappe:Tg" surn eexe = 0faspn] )ng"   ourgTypeipurn np

	s,eourgCpunt,				jipuvit fl	nid
	stipuvit Typeiprry 4.Objf cu;ue )Dscr( data );
 riD htalue )dleredagment(_
JSOalue )y.!= null ) !ue )Dscr(++;!]uvit on=0ue )Dscr,uvit s)) {
	key			},
 iecip tyot Od(IEtlisems ttype)urn np

	 	haeg" s; t "srma;
 m omitrn 
	yng" s = rg );
		rim) hsS hHlis( ng" s ||0"bles);nction(i, ip n ) {
	th = ;	th<mng" s.{
				vatue = cans[f-fo= reg" urn np

	
erecf  "obs[t] )n||0 [ conitype( aourgType( atn	dd; coniurn np

	s( atn	d2]ipe fpeciUnbrinDalt
callss (o
				tpurn np

	) if providif)l actdy
	soLoit 	// ll ) !ng" elems[i n ) {
	tg" "inluvit onrn exe			 elems,uvit .ed)
		alue )amng" e+/ "obs[	th],erry 4.r)  {;
		or,s,

	//evb
		// Acy ck to emula 	uull sid
	st
=/ elems,uvit .oid
	st[ t "sr]a++; pip eytype( anc {;
		or? oid
	st.

/ ghat.isWi: oid
	st.b d:Tg" "se !== "sipxe	uvit .isWi
	-vit s[ t "sr]n||0 [ coniourgCpunti
	-vit .isW				firv
ryrurn np

	s( aurn np

	s(?ject(RegExp("(^|\\.)"r+rurn np

	s.nction(.")ypLoa().join("\\.(?:.*\\.|)" i+//(\\.|$)" i:apromis
} yry lbacks  s fi:
 *
vit o
i n ) {
	jh = ;	jh<m-vit .isW				firv jue = callbahry 4.Obj
ep-vit .isW[	jh}eventi]&& jQ(smappe:Tg" su||0ourgType( =,
hry 4.Obj.ourgType(_hass[i], 
			rry 4.ra++;hry 4.r.urn  ==,
hry 4.Obj.urn  rnass[i], 
			urn np

	s(||0,
		np

	s. {
			hry 4.Obj.urn np

	 ) rnass[i], 
			st;
		oru++;nt;
		oru,=,
hry 4.Obj.st;
		oru++;nt;
		oru,=,
"**nd sthry 4.Obj.st;
		oru {n obj != -vit .isW	pace);
	j--,t1E ev	// 	=peof hry 4.Obj.st;
		oru { e	= [ 	-vit .isW	

/ ghatCpunt						
		// Acy  {
		nid
	st.ed)
		f { e	= [ 	nid
	st.ed)
		 :
				leng,ahry 4.Obj
eru			return this;
tuull ry lbacks agncuicotalls rry 4.r0	f wewed)
		dwso] 			dise
			/tmuncthry 4.rslst, iull ry (cvoide pod sr	st
tlisey 4.sowedcumco hcduurn 	n't hal:jecsid
	st
calls rry 4.rs)	// ll ) -vit .isW				firu,=,
0rcalburgCpunti&& tevit .isW				firurn exec.peof !nid
	st.teardowna++;nid
	st.teardown :
				leng,aern np

	s,eue )Dscr,hry 4.7rne{
	 If IE in keyog;
					}
t haEv.fr(	ue )amng" ,eue )Dscr,hry 4.7revb
		//it  rdeeetlbuvit s[ t "sr]null tual i/		eciRd)
		fpecterpto odt in
'd
n tlohe r {
			// {
		 ) {

			unctisoft.XMLuvit onrn in keydeeetlbue )Dscr,rry 4.;
ull ry }
t haD htialsot firssotlisenct/ Sssjects le= sfpecterpto odt i
	selnab ing
o {
	ovediQ				if ( deeetl
yog;
					}
t haD htalue )am"uvit o"ip,

	//evb
vert dashedEvit on	and ar lsafumateshLoa-circuir irin thry 4.rslar llt ms ed.blogsNrim f0winduvit snohoul			/tsb Dlis		,/pecyrma;
the pinlist hry 4.rs.
	tustomEvit ml it .getD ht": lude rog.setD ht": lude rog. fthe D ht":= pass tfor turgger:(, key, valuvit ,adscripue )amveueHry 4.rsllems[ionaiugh,  oduvit sn
		}	x	jects nmm		vaow ob
	=peof -1 ]d sta-1 ]werCa.isWi
& t3 ||0-1 ]werCa.isWi
& t8)) {
	key			},
 iecip tyot Ev.fr mise:   isevit 
eg" s ere vv] ||	/exclusm f	/i, cumamvldamveng" ,enid
	stiphry 4.ipuvit Path, bubbla.isW,p eytype( auvit .tion"||0uvit ,
ryrurn np

	s( a[}event moeetL(/blurtmunphon			fntL(io/out;iack canwe're/	/tsniurn 	l( ]dr	} etnow
	=peof rfntL(Morph. {
			ng" e+/

		retuvit .turggercal)) {
	key			},
 iecip typeof  "ob;arr, el( "!" le>=sAr)ems[i]ot Exclusm ft
vit on	urggeroveuer actdy
	sxactsevit 
(n turn np

	s)conitype( atisW	pce);
 i -1revb
	exclusm fn
  ; liss;ip typeof  "ob;arr, el( "." le>=sAr)ems[i]ot Nrn np

	dn	urgger;s parselajregerpn			 s fisevit 
eg"  inerry 4.a)
			urn np

	s( atisW	paceon(.")ip eytype( aurn np

	s.n	}
			;endiurn np

	s.nLoa();	s;ip typeof (	-1 ] ||0

		retuvit .tustomEvit [ t "sr])acallata );
uvit .
	// W[ t "sr]n)ems[i]ot Noi elemsmrry 4.rsl actdyissevit 
eg" ,jectsi		e gh, the pinlist hry 4.rs	key			},
 iecip tyot dthe.r( 		ppjec	i? anrEvit ,aOe {
		lor definansevit 
eg"  sturn  keuvit 
ep "objec-vit 
e{
			for ( i?s[i]ot ata );
Ev.fr mise: pxe	uvit [dagment(expto od] ?
tvit e fn( ot Oise:  ceoercttac	ect(ata );
Ev.fr	reg"   uvit r)e fn( ot Jefinhavetalls eg"  (sturn )tac	ect(ata );
Ev.fr	reg" E ev	//uvit .tion" d	g" ;s[iuvit .isTurggero
  ; liss;uvit .exclusm fn
 exclusm fiss;uvit .urn np

	  (urn np

	s.join( "." liss;uvit .urn np

	_re( auvit .urn np

	?ject(RegExp("(^|\\.)"r+rurn np

	s.join("\\.(?:.*\\.|)" i+//(\\.|$)" i:apromis ibntype( atisW	arr, el( ":"ele<sAr?	"on"r+reg" {: ""nu
tyot Hry 4.7ae
	// Wo	urgger null ) !ue ) = calns[ingTODO: S
		 taunt]/ we sh JSONv] ||;wed)
		f
	// Wotallssjects	windowenlms t			entElemelns[th ||B
 parsed.f] ||;
i n ) {
	ision   ||Brn exec.peof    ||m/ w},uvit sntriv  ||m/ w},uvit s[ t "sr]n)ems[i]		 elems,uvit .turggertluvit ,adscripv  ||m/ w},hry 4..ue )am,

	//evb
		// Actukey			},
 iecip tyot dring upts cuuvit 
ion  ev vedismuery:wed{
			//uvit .eds lis			if ( !memorypeof !uvit .targ'	l {
	efeuvit .targ'	l=0ue )oxetip tyot Cljn|rddedad nmry:w JSONectsprepeinDhaveuvit ,a parsc/ we shrry 4.r0argw functi	rim( dtriml!
	nt.do?	ks("memmDOM  ) > i scre(t 0 [ con scr
un		}
			uvit r)lue !/astilowloid
	st
callss 			eraw	outsid	fpectlists	kesid
	st
=/ elems,uvit .oid
	st[ t "sr]a++; pip e {
		nid
	st.	urggerotrinid
	st.	urgger.rguly(0ueng,adscr7rne{
	 If IE in key			},
 iecip tyot Dvget ist uvit rprokagd
) {
path	i? advan
	) uireW3Cduvit snoid
 (#9951) tyot Bubbla upts		entElemeaspecnhs		 i(and; ws fistlisdf
	// WoownerDntEleme re v(#9724)
	suvit Path( a[[0ueng,aoid
	st.b d:Tg" " !== "sr]]morypeof !veueHry 4.rslcalloid
	st.noBubbla callata );
isWi(andalue )dle= calns[bubbla.isW( aoid
	st.

/ ghat.isWi !== "sipxe	cumo= rfntL(Morph. {
			bubbla.isW(+lng" ele?
toLor: toLowparistN	} k i n ) {
	vldl=0ue )o cumo cuml=0cumwparistN	} les = [	[uvit Path.					[ cumambubbla.isW(]/evb
		vldl=0cumois;
tuull ry Once list i(and0	f wewgotts		entElemeta-.g.,en
		p" 	hapas oruf  ms ed0win)	// ll ) vldl={
	a-1 ]wownerDntEleme  !=entEleme)les = [	[uvit Path.					[ vld.back liVict(||0old.paristWi(and(||0 i(andambubbla.isW(]/evb
	tual i/		eciFincthry 4.rsl
		} eltvit rpath
!= ) {
			=: i++ ) uvit Path.jqueryrcal!uvit .isProkagd
) {S
		ptch value = capxe	cumo= uvit Path[i]mpt!=	//uvit .tion" duvit Path[i]m1}eventihry 4.7=0(dagment(_
JSOalcumam"uvit o""se !={}dl[ uvit .tion"]eredagment(_
JSOalcumam"hry 4." )a lba&& jQhry 4.7rncallbahry 4..rguly(0cumam scre(ip na}s[i]ot Notes and } 		/		/a bar lJS efer ) { e
			/tsai elemsmrry 4.rentihry 4.7=0bntype(trivur[0bntype(]a lba&& jQhry 4.7redagment( fn,ptDJSOalcumdleredhry 4..rgulyeredhry 4..rguly(0cumam scre(ne{
	 If IE in keyouvit .r callsDack li(loxet aual imsuvit .tion" d	g" ;s
fpecidelnobodytr callsedvent back lisad.pro	  odietnow
	=peof !veueHry 4.rslcalluvit .isDack liP callsed(le= calns[peof (	oid
	st._back lis++;nid
	st._back li.rguly(0uengwownerDntElemeam scre(ne{
	 If Irnass[i],!(tisWi
& t"lumek rredagment(()Case()jlue )am"a"y.))redagment( fn,ptDJSOalue )dle= calns[yot dthelajerim f0wind] 		odl
		} eltarg'	l argu	proal hae ] ne ] nes	} eltvit .lns[yot dtgh, uy Dln eturned.prom)g firssa thebee alsoIE6/7 failon	and  {
	.lns[yot iugh,  odback lisad.pros  Ji i(and,n	and'ss a the
	// Wore itacksmuev(#6170)fns[ esoIE<9  ies  JieetL(/blurts		hidde(sematched(#1486)
			s&& jQjntype(tri-1 ][ tion"]ered((tisWi&& t"eetL("utring"  !{
		blur/.a++;uvit .targ'	.offsetWidtht!{
	0) callata );
isWi(andalue )dle= calns[ 
onaiugh, nu-	urggeroanrmnFOOltvit rs reawe 		lisn
s	FOOm)g] 		odlns[ 
vldl=0ue )[0bntype(]a 
 Acy  {
		vldllems[i], dtoLo[ bntype(]d=.promiseb
		//it  r
onaP calls nu-	urggermodilfu	proal hauvit ,a( d(IEferalled atbubblatsi		ab
		s[i]		 elems,uvit .turggerew( d= "sipxe	 dtoLo[ type(]();	nab		 elems,uvit .turggerew( d	if ( !memo
 Acy  {
		vldllems[i], dtoLo[ bntype(]d=.vldru			return this;
tu	l i/					},
	uvit .eds liise for Chrp	xml:(, key, valuvit e= calnsot  DOM a writtack ata );
Ev.fr 			ement ,rim f0uvit  mise: pxeuvit 
ep elems,uvit .fixaluvit e||0 i(and.uvit r)lue !re vi ) 
	cumamn'	,bselM	xml,	 s fi		,/ s fi	s,erry 4.Objfbselamn'atiodf cu;hry 4.rs( anc(agment(_
JSOaled ] )"uvit o""se !={}dl[ uvit .tion"]e||0 [)= {};

/ ghatCpuntd thry 4.rs.

/ ghatCpunt= {};args( a funcpce); :
				th,
		deer)elemscun_	lis=lluvit .exclusm fncalluvit .urn np

	)lemssid
	st
=/ elems,uvit .oid
	st[ uvit .tion"]e||0{}f cu;hry 4.rQueue( d[}event moby Dent fix-ew(ata );
Ev.fr rarun n	an		} el(led -veue) ,rim f0uvit 
};argsdre; duvit iss;uvit .

/ ghat.arg'	l=0			the tyot dthei} elpreDhrp	xmlehg
k  actdy
	mappe:
eg" ,jectsled n
ibail0	f des1
	dp e {
		nid
	st.preDhrp	xmletrinid
	st.preDhrp	xmls:
				ed ] )uvit e= e{
	 If IE in key			},
 iecip tyot Dvget ist hry 4.rs( and thoul		cun iri} er llr lt
/ ghatd*
vit o
i /astvoid 	/n-} ca-lumektbubblmodi	haFincfoxd(#3861)
!=peof 

/ ghatCpuntdcall]uvit .puttonwtri-vit .tion" & t"lumek le= calns[ ) {
	cumo= uvit .targ'	o cuml!=0			th cuml=0cumwparistN	} l !==			/l calns[yot iugh, pron, i lumeks (ONLY)  JiChrn() { eoLoit on(#6911, #8165, #11382, #11764)
			s&& jQcumwChrn() { !{
	,

	/ !=-vit .tion"!& t"lumek rlems[i], selM	xmln=0ch( oe	);ma fi	sn
 ca;s[i],= ) {
			=: i++ ) 

/ ghatCpuntfin( elems[i], ahry 4.Obj
ephry 4.rsm/ defe= [ , sel ,
hry 4.Obj.st;
		or;							s&& jQst;M	xml[Qst;(]d={
	Query.isFufn.appl, , selM	xml[Qst;(]d=	hry 4.Obj.u casCventmp ?exe	ry	!=, value selam				/l.arr, alcumdle>=sAr:exe	ry	!=, valu.o d:  selam				, prom,d[ cum
]B))			firv
ryry		// Acy s&& jQst;M	xml[Qst;(]dfn.appl, , ma fi	s.					}hry 4.Obj
eru [ y		// Acy // Acy  {
		ma fi	s.jqueryrate = [ =;hry 4.rQueue.					{ eoLo:	cumamma fi	s:mma fi	s }}
				return this;
tual i/		ry  or 	gthn't 	hmodi(die jQly-bpund) hry 4.rs	kepeof rry 4.rep = fal >t

/ ghatCpuntd {
	keyhry 4.rQueue.					{ eoLo:					, ma fi	s:mhry 4.rs.pce);
	

/ ghatCpuntd {t) iecip tyeciRun 

/ ghatc	fto f;/pecyrma;
wanta			stoprprokagd
) {
beneath(us
!= ) {
			=: i++ ) hry 4.rQueue.jqueryrcal!uvit .isProkagd
) {S
		ptch value = ca , ma fi	  =ahry 4.rQueuem/ defe= [uvit .turrist.arg'	l=0ma fi	 .ue )oxlns[ ) {
	jh = ;	jh<mma fi	 .ma fi	s.jqueryrcal!uvit .isImmedihatProkagd
) {S
		ptch vajue = callbahry 4.Obj
epma fi	 .ma fi	s[	jh}eventi]eciTrrggerew(calls eefineirun n1)muevnon-stclusm fnectsthe pn turn np

		lorenti]eci2)sthe pnrn np

	(s)extoubs= sor eqist
				pose[jQQhavebpundsevit 
(borgulansthe pn turn np

	).
			s&& jQcun_	lis||0(luvit .urn np

	rcal!hry 4.Obj.urn np

	.a++;uvit .urn np

	_re(tri-vit .urn np

	_re. {
			hry 4.Obj.urn np

	 ) rncalns[ 
uvit .
rim( dhry 4.Obj.
rim;lns[ 
uvit .hry 4.Obj
ephry 4.Obj;							 = 0,
nc(agment(uvit .oid
	st[ hry 4.Obj.ourgType(]e||0{}),hry 4.7++;hry 4.Obj.hry 4.r )appl, , .rguly(0ma fi	 .ue )amth,sE ev	// 	=peof  = 0 {
	Query.isFufn.appl, /uvit .eds lis		arg isnab	=peof  = 0e{
	 If IE in keyogyouvit .r callsDack li(loxet ogyouvit .stopProkagd
) {(eru [ y		// Acy // Acyhis;
tual i/		ry dthei} elpostDhrp	xmlehg
k  actdy
	mappe:
eg" p e {
		nid
	st.postDhrp	xmle in keynid
	st.postDhrp	xmls:
				ed ] )uvit e= iecip ty			},
	uvit .eds liise for 			Inclu objso] uuvit rproksnohart wbyeKeyEv.fr ectsMouseEv.frr 			***uenl[Cfthe  at [N
		mn'atiodN	} lsrcEmatched athen
		ey evealud,vnon-W3C, 

r cctiodf0 ihe  ewed)
		dw i 1.8	***r proks:m"enl[Cfthe  at [N
		mn'atiodN	} lsrcEmatchedaltKeytbubblas 		d(Iltack ctrlKeytturrist.arg'	luvit Ph ev ] 	aKeytn'atiod.arg'	l		}
	Keyttarg'	ltimeStamp vict(whis ";nction(i, ,eapfixHg
ks:em for keyHg
ks:ems[iproks:m"che vvhe C	} lkeylkeyC	} ";nction(i, ,es[ ilter:(, key, valuvit ,aourgin	rcrn es[i]ot  or whis t actkeyl
vit o
i  ll ) -vit .whis t{
	nt.do {
	efe,-vit .whis t{aourgin	r.vhe C	} l!
	nt.do?	ourgin	r.vhe C	} l:	ourgin	r.keyC	} ois;
tuull 			},
	uvit evb
vert das.ouseHg
ks:ems[iproks:m"puttonwputtoni lumit X lumit Y 			eEmatchedoffsetXdoffsetYlpag(Xlpag(Y screenX screenY
		Ematche";nction(i, ,es[ ilter:(, key, valuvit ,aourgin	rcrn e	xe = 0uallsDoc	  oc	 body,					puttonw=eourgin	r.putton,								eEmatched=eourgin	r.			eEmatche;
ull ry dthcuatiolpag(X/Y irimi i// wects lmit X/Y availtack
i  ll ) -vit .pag(Xl{
	nt.docalburgin	r.vumit X !
	nt.do {
	efe,-vit Doco= uvit .targ'	wownerDntEleme  !=entElemeru [ ydoco= uvit Dnt.entElemeEmatche;
				podyt= uvit Dnt.podyev	// 	-vit .pag(Xl{lburgin	r.vumit X +of 
ococal
oc.scrollL ca	 !=podytcalpody.scrollL ca	 !=Ar)e-of 
ococal
oc.vumit L ca	 !=podytcalpody.vumit L ca	 !=0elip;
		tvit .pag(Yl{lburgin	r.vumit Y +of 
ococal
oc.scrollTopr	 !=podytcalpody.scrollTopr	 !=Ar)e-of 
ococal
oc.vumit Topr	 !=podytcalpody.vumit Topr	 !=0
eru [ 	uull ry  or n'atiod.arg'	) if e n, iiry
i  ll ) !uvit .edatiod.arg'	lcal			eEmatched {
	efe,-vit .edatiod.arg'	l=l			eEmatched=== uvit .targ'	o?	ourgin	r.		Ematchel:				eEmatche;
 [ 	uull ry  or whis t actlumek: 1d=== } ca; 2d=== mid 4.; 3d=== r	} eull ry Note:	puttonwid
n 		ey evealud,vsooough, {
	ove
i  ll ) !uvit .whis tcalputtonw {
	Query.isFufn.appl,-vit .whis t{a(lputtonw& 1d?t1a:/(lputtonw& 2d?t3a:/(lputtonw& 4d?t2
: 0 ) rn)ois;
tuull 			},
	uvit evb
vert dasfix:e, key, valuvit e= ca  ll ) -vit [dagment(expto od]  {
	efenull ? uvit evb
ve/		ry dparselajwrittack copy  fm} eluvit  mise:  e
			/ evealumso] uproke ti nd[ re vi )prok,				ourgin	rEvit 
epuvit ,lns[ ixHg
k
ep elems,uvit .fixHg
kslstvit .tion"]e||0{}f cu;copy = fixHg
k.proksn?s	/ S.proks.codcti( fixHg
k.proksn(t 0	/ S.proksev	//uvit 
ep elems,Ev.fr	rourgin	rEvit 
 ev	// ) {
			=:copy.{
				val;  {
	efer 
		=:copy[ -- defe= [uvit [ o 
	(]d=.vurgin	rEvit [ o 
	(]evb
ve/		ry  tx/targ'	oproke ty) if e n, iiry (#1925,uIE 6/7/8w& Safari2)
!=peof !uvit .targ'	l {
	efeuvit .targ'	l=0vurgin	rEvit .srcEmatched !=entElemeru [ve/		ry .arg'	l		oul			/tsb Dl	}	x	j()Ca (#504, Safari)a  ll ) -vit .targ'	werCa.isWi
& t3  {
	efeuvit .targ'	l=0uvit .targ'	wparistN	} k i ve/		ry  oh .ouse/keyl
vit o, ] 	aKey== If IEt in
'd
Query.isFu(#3368, #11328;oIE6/7/8)
	suvit .] 	aKeyt= !!uvit .] 	aKey;
tac			},
	fixHg
k. ilter?	fixHg
k. ilteraluvit ,aourgin	rEvit 
 n:
tvit ise for nid
	st:ems[iload:ems[i]ot P calls turggerew(imag(.load	
vit on			embubblmodis		 i(and.loads[i]noBubbla:= pass  ow upleetL(:in keydeeeghat.isW:t"eetL(in"
lat	lenblur:in keydeeeghat.isW:t"eetL(sut s  ow uplbe ) eunloadml it esetukj ) {
					rdscripurn np

	s,euvit Hry 4.7rn{enti]eciWeoveuerwanta			do 				/oid
	st
		stoonh i(ands
			s&& jQata );
isWi(andal=			/l  in keyog	/ S.onbe ) eunload7=0uvit Hry 4.evb
		// Actw upleteardownj ) {
					rurn np

	s,euvit Hry 4.7rn{enti]				/	/ S.onbe ) eunload7===euvit Hry 4.7rn{enti]g	/ S.onbe ) eunload7=0promise();}	s;
tual ie for nimuatioj ) {
					rng" ,eue ),luvit ,abubblallems[ionaPrggy listontrvoug isevit 
eo nimuatioackChffen.fr one./		ry  DOM ourgin	rEvit 
ons	void oug i'd
xtopProkagd
) {,abur iri} e/		ry nimuatioduuvit rpr
vit onback list reawe d			proal ha
		} eloug i.d[ re v|B
 parsed.ermise s[i]nct(ata );
Ev.fr	)elemsuvit ,lns[{ typemleg"  it  risSimuatiod: lude rog		ourgin	rEvit :em 	s;
tual)morypeof bubblallems[i	 elems,uvit .turggertlu, prom,due )y.!=[ 	fire(  exe]

		retuvit .Chrp	xml.:
				leng,a	//evb
ver ll ) -.isDack liP callsed(le= cagyouvit .r callsDack li(loxet}vs eay.pesoSo] upluginslar lL(ing,abur i
'd
QuentElemeed/

r cctiod e
		 ihe  ewed)
		d.
ingT	e 1.7csid
	st
calls add af

	l		oul		providiacks withhg
ks(u cae			/w.
 elems,uvit ,hry 4.7=0

		retuvit .Chrp	xmly.promise }
t haEv.fr  GentElemen}
t haEv.frL, iefisc?asf key, value )amng" ,Qhry 4.7rncall {
		eoLow}
t haEv.frL, iefiscrn exe	ue )w}
t haEv.frL, iefis(mng" ,Qhry 4.ip If IE evet}vs r:exf key, value )amng" ,Qhry 4.7rncallre v{
			
 "on"r+reg" != null ) ue )wf  ms Evit 
 n es[i]ot #8545, #7054,rpr
vit modiected"bl}
	on actlustoml
vit on ieIE6-8 –s[i]ot f  ms Evit 
u cae		proke ty  (sematche,wbye{
			 fm} atluvit ,aoptr 
	erlatstpoev vedoptGC
i  ll )  "objec-lLo[ alse ) 	&& ({if ( !mend in key	-lLo[ alse ) 	0promise()tu

		toLowf  ms Evit ]turn  =hry 4.7revb
}s ta data );
Ev.fr =0, key, valsrc, proksn(t{
!/astilowliQ		asr	s
) {
 argsut with'nct'tkeywords[peof !(} 		/	Q		ascstri elems
Ev.frle= cagynull ? pct(ata );
Ev.fr	rsrc, proksn(ise dashedEvit  mise: px {
		nrcocalnrc.ng" elems[i	/ S.ourgin	rEvit 
epnrc;s[i	/ S.tion" dnrc.ng" he tyot Evit onbubblmodiupts cuentElemetma;
the proenumarksFuas;r callsed tyot byextrry 4.r0  nam downa} eltre|;wedf;
					eFl( e jQ	fn = .s[i	/ S.isDack liP callsed( anc rc.dack liP callsed(++;nrc.null ?V	r ele{
	 If IE||it esrc.g'	P callsDack liocalnrc.g'	P callsDack li(le= ?0 *
 */Tr
		:c *
 */Flist )ashedEvit  eg" p 	fire(  exe	/ S.tion" dnrcise dashedPut ex1 );		firprovidifo own.

		va
					prosvit  mise: px {
		proksn(t{
!	parsed.ermise 	ed ] )proksn(ise dasheddparselajtimestamp t ind nmry:wsvit  ioMs Thethe pone
e	/ S.timeStamp =	nrcocalnrc.nimeStamp ||0

		ret	/w()a deep Marksi		a	/ftxed
e	/ S[dagment(expto od] 
  ; lista defer ) {  *
 */Flisttrn ex			},
	flist )}defer ) {  *
 */Tr
	trn ex			},
	 ; list.pesoata );
Ev.fr ismuas by njDOM3 Evit onasd#id
			if bye	proECMAScript Languag(aBrinrn  eso.java.nwww.w3		if TR/2003/WD-DOM-Lsvil-3-Evit o-20030331/ecma-script-brinrn .arsedata );
Ev.fr.prototion" d{r prcallsDack li:m				// strn exe	/ S.isDack liP callsed( a *
 */Tr
	lue !re vel=0			t.ourgin	rEvit morypeof !uE in key			},
 iecip tyot if prcallsDack liost, in cun ita
		} elourgin	rcev.frr  ll ) -.prcallsDack liorn exe	u.r callsDack li(lox tyot erun again {
7= linull ?V	r elproke ty  fm} elourgin	rcev.fr / sns.sto(IE)
			fire(  exe]e.null ?V	r ele	 list ) {}or},itstopProkagd
) {:m				// strn exe	/ S.isProkagd
) {S
		ptc( a *
 */Tr
	lue !re vel=0			t.ourgin	rEvit morypeof !uE in key			},
 ieciptyot if stopProkagd
) {ost, in cun ita
		} elourgin	rcev.frr  ll ) -.stopProkagd
) {orn exe	u.stopProkagd
) {(eru [} tyot erun again {
7= li		d(IlBubbla proke ty  fm} elourgin	rcev.fr / s,

	/(IE)
		; :
d(IlBubbla 
  ; liss},itstopImmedihatProkagd
) {:m				// strn exe	/ S.isImmedihatProkagd
) {S
		ptc( a *
 */Tr
	lu =	/ S.xtopProkagd
) {(eru },itisDack liP callsed:c *
 */Flist,itisProkagd
) {S
		ptc:c *
 */Flist,itisImmedihatProkagd
) {S
		ptc:c *
 */Flisteay.pesodparsel.ouse srnr/leavel
vit onL(ing .ousesS h/out e
		
vit -nimet firssuata );
eunct{as.ouse srnr: ".ousesS h j
).ouseleave: ".ousesut s},m				// st ourg,/ftx fn.apata );
evit .oid
	st[ ourg	}
ep it deeeghat.isW:tftx	lenb d:Tg" :tftx	l
bahry 4.:e, key, valuvit e= ca  ere vn'	, key	targ'	l=0			t, key	edatiodl=0uvit .n'atiod.arg'	) key	hry 4.Obj
ep-vit .hry 4.Obj,					 Ad
		or ,
hry 4.Obj.st;
		or;					ry  oh .ousesrnr/leavelccks withhry 4.r0	f edatiodlismoutsid	fpecttarg'	wull ry NB: Noiedatiod.arg'	liri} el.ouse } ca/esrnredvent b mws.r0 i(and
i  ll ) !edatiodl||0(edatiodl!{
	,arg'	lcallata );
 ck a	Q	(	,arg'	amn'atiody.)) {
	keysuvit .tion" dhry 4.Obj.ourgType; key	edt" dhry 4.Obj.hry 4.r.rguly(0ed ] )th,
		deer);	keysuvit .tion" dftxip na}s[i]null ? arg i;
}s ta })y.pesoIEtoubmitadeeeghact-	 {
			ata );
tentLoa.submitBubblas  n es[ elems,uvit .oid
	st.oubmita=e ity;
tukj ) {
					)ems[i]ot Once u caDen		/tlist
/ ghatd*eedetoubmita
vit o
i  ll ) agment(()Case()jled ] )"eede"r {n obj !=			},
	flist ) [ 	uull ry Lazy-listatoubmitahry 4.r0s reae desciseantaeedetma;
pod sr	stl;
 m oubmitsed ty[ elems,uvit .lisjled ] )"lumek._oubmitakeyp			s._oubmit",0, key, valudle it  resoN	} lalse  firsscvoide a VML-n'atiodycrashn ieIEv(#9807)appl, = 0ue )  tew	arg'	) key		eedet=dagment(()Case()jlue )am"inpu
""se !=agment(()Case()jlue )am"putton"r {?
toLo.eedet:		if ( !memory  ll ) eedetcallata );
_
JSOaleedeam"_oubmit_lt ms ed"r {n obj !=  elems,uvit .lisjleedeam"oubmit._oubmit",0, key, valuvit e= ca  eeysuvit ._oubmit_bubbla 
  ; lisse();});	nab		 elems,_
JSOaleedeam"_oubmit_lt ms ed"am,

	//evb
		// Act/evb
	ry }
ll ? 				first[( d(IEferough, u caDansevit 
l, iefiss  ow uplpostDhrp	xml:e, key, valuvit e= ca  eecideleedetwasd#ubmitsed bye	prousemambubbla		prosvit  upts cutre|
i  ll ) uvit ._oubmit_bubbla = ca  eedeeetlbuvit ._oubmit_bubblamory  ll ) 	/ S.paristN	} lcal!uvit .isTurggeron obj !=  elems,uvit .nimuatio(m"oubmit", 	/ S.paristN	} ,luvit ,a,

	//evb
		// Actukeow uplteardownj ) {
					)ems[i]ot Once u caDen		/tlist
/ ghatd*eedetoubmita
vit o
i  ll ) agment(()Case()jled ] )"eede"r {n obj !=			},
	flist ) [ 	uull ry Rd)
		ft
/ ghatd*hry 4.rs;s le=nD hti
vit ustl;
parpstoubmitahry 4.rsllt ms ed	ab
		s[i] elems,uvit .ed)
		aled ] )"._oubmit"null;
}s ta }tringIEv fthe adeeeghact-jects firsbox/ion o ftx
 {
			ata );
tentLoa. fthe Bubblas  n es[ elems,uvit .oid
	st. fthe aep ir y;
tukj ) {
					)ems
i  ll ) reedeElpas. {
			n/ S.erCaN
		 )nle it  resoIEvioMs Thefinct fthe aontrv firs/ion o unt]l blur;n	urggeroita
		lumekit  resoaer evalproke ty fthe . End } elblur- fthe a ieoid
	st. fthe ,hry 4..it  resoT			/stihe fincva
	 fthe aahxt		}

nimet actlfirs/ion o aer evblur.ory  ll ) 	/ S.tion" & t"lfirsbox"{ !==			.tion" & t"ion o rn obj !=  elems,uvit .lisjled ] )"proke ty fthe ._ fthe ",0, key, valuvit e= ca  eeysll ) uvit .vurgin	rEvit .proke tyN
		)=& t"lfirsmend in key	i]g	/ S._defi_		the Fu
  ; lisse();	// Acy /);	nab		 elems,uvit .lisjled ] )"lumek._ fthe ",0, key, valuvit e= ca  eeysll ) 	/ S._defi_		the Fucal!uvit .isTurggeron obj != ]g	/ S._defi_		the Fu
 flist ) [ );	// Acy !/astilowlturggerew, nimuatiodu fthe a
vit on(#11500)appl, , elems,uvit .nimuatio(m" fthe ",0ed ] )uvit ,a,

	//evb
		 /);	nab	}bj !=			},
	flist ) [ 	u	tyot Dv/ ghatd*
vit ; lazy-listat fthe ahry 4.r0 JiCesciseantainpu
s ty[ elems,uvit .lisjled ] )"be ) ead.pvhat._ fthe ",0, key, valuon obj != = 0ue )  tew	arg'	eventi]&& jQreedeElpas. {
			-1 ]werCaN
		 )nth lata );
_
JSOalue )am"_ fthe _lt ms ed"r {n obj !=  elems,uvit .lisjlue )am" fthe ._ fthe ",0, key, valuvit e= ca  eeysll ) 	/ S.paristN	} lcal!uvit .isSimuatioducal!uvit .isTurggeron obj != ]g elems,uvit .nimuatio(m" fthe ",0ed ].paristN	} ,luvit ,a,

	//evb
		;	// Acy /);	nab		 elems,_
JSOalue )am"_ fthe _lt ms ed"am,

	//evb
		// Act/evb
}	l
bahry 4.:e, key, valuvit e= ca  ere vue )  tevit .targ'	;					ry Swthe op,rim f0 fthe a
vit on			em firsbox/ion o,Eferalled atturggerew(l( ]dab
		s[i]ll ) 	/ Si&& te1 ] ||0uvit .isSimuatiodu||0uvit .isTurggero||0(-1 ]wtion"!& t"ion o rth -1 ]wtion"!& t"lfirsbox" {n obj !=			},
	-vit .hry 4.Obj.hry 4.r.rguly(0ed ] )th,
		deer);	keytukeow uplteardownj ) {
					)ems[i] elems,uvit .ed)
		aled ] )"._ fthe "E ev	// 			},
	!reedeElpas. {
			n/ S.erCaN
		 )ll;
}s ta }tringdparsel"bubblmod"ieetL(jectsblurt
vit o
 {
			ata );
tentLoa.eetL(inBubblas  n epata );
eunct{ eetL(:i"eetL(in", blur:i"eetL(sut  },m				// st ourg,/ftx fn.a tyot Anlms ta[( dgck captuurn 	hry 4.r0s ilumso] jn|rwants	fntL(io/eetL(sut
	yre venlafi	sn
 0f cu;hry 4.r  (, key, valuvit {n obj != elems,uvit .nimuatio(mftx	tevit .targ'	,p elems,uvit .fixaluvit e)am,

	//evb
	pipe fata );
evit .oid
	st[ ftx }
ep it e;
tukj ) {
					)ems[i]]ll ) enlafi	s++u,=,
0rn obj != entElemenlisEv.frL, iefis	rourg,/rry 4.r) ,

	//evb
		// Act,p eyteardownj ) {
					)ems[i]]ll ) --enlafi	sn
=,
0rn obj != entElemen}
t haEv.frL, iefis(mourg,/rry 4.r) ,

	//evb
		// Act
e(vevs )a tuuata );
fn
ermise  i
	 {:m				// stmng" s,e {;
		or,sdscripfn, /*INTERNAL*/pone7rncallre vourgFn,d	g" ;s
fpeciTg" sulansb Dl	map  fm}g" s/hry 4.rs	kepeof  "objecng" s ={
			for ( i)ems[i]ot tmng" s-Oe {
		l {;
		or,sdscr )	// ll )  "objec Ad
		or !& t"sturn  i)em ot calnAd
		or !&0promit  resotmng" s-Oe {
		ldscr )	// i	rim( dtriml++;nt;
		or;					 Ad
		or ,
	if ( !memory tualn ) {
	tg" "inlng" s n obj !=	/ S.on(mng" ,Q {;
		or,sdscrip "obs[	tion"],pone7rip na}s[i]null ? 			thes;ip typeof 	rim( 
	nt.docalfnt{
	nt.do {
	efeesotmng" sipfn )	// fnt{;nt;
		or;					rim( d Ad
		or ,
	if ( !memory	fire(  {
		fnt{
	nt.do {
	efell )  "objec Ad
		or =& t"sturn  i)emit  resotmng" s,Q {;
		or,sfn )	//  fnt{;
rim;lns[ 	rim( d	if ( !memory tfire(  exe],esotmng" s,Qdscripfn )	//  fnt{;
rim;lns[ 	rim( dnt;
		or;					 Ad
		or ,
	if ( !memory tualver ll ) fnt{

	 If IE in keyfnt{; *
 */Flist )ry	fire(  {
		!f{orn exe	null ? 			thes;ip typeof one7{

	1orn exe	ourgFn  (,
 iecyfnt{;, key, valuvit {n obj !=ot dtg uy Dln 
	sel;se ,a( d(IEuvit { ck a	Q	 } elioeebj != elems().off		uvit r)luj !=			},
	ourgFn.rguly(0ed ] )th,
		deer);	keytevb
	ry by Dal haurn  sot the.r( 		ped)
		fL(ing ourgFniecyfn.urn  =aourgFn.urn  ||0(aourgFn.urn   data );
urn prw) iecip j			},
		/ S.eunct ) {
					)ems[i] elems,uvit .lisjled ] )ng" sipfn)  scripst;
		orur iecieru },itone:m				// stmng" s,e {;
		or,sdscripfne= cagynull ? 	/ S.on(mng" s,e {;
		or,sdscripfn, 1 eru },itoff:m				// stmng" s,e {;
		or,sfne= cagyre vrry 4.Objfb= "sipxell )  "obsutring" s.prcallsDack liotring" s.hry 4.Obj
e{
	efeesotmuvit {n  Chrp	xmlew(ata );
Ev.fr cu;hry 4.Obj
epng" s.hry 4.Obj;s[i] elems)  "obs.

/ ghat.arg'	l).off	uj !=hry 4.Obj.urn np

	 ? hry 4.Obj.ourgType(+ "." +	hry 4.Obj.urn np

	 : hry 4.Obj.ourgType) key	hry 4.Obj.st;
		or) key	hry 4.Obj.rry 4.rentiunull null ? 			thes;ipkepeof  "objecng" s ={
			for ( i)ems[i]ot tmng" s-mise:  [,e {;
		or] )	// f) {
	tg" "inlng" s n obj !=	/ S.off		ng" ,Q {;
		or,s "obs[	tion"]7rip na}s[i]null ? 			thes;ipba&& jQst;
		orue{
	 If IE||  "objec Ad
		or =& t"				// s i)ems[i]ot tmng" s [,efn] )	// fnt{;nt;
		or;				 Ad
		or ,
	if ( !memory	er ll ) fnt{

	 If IE in keyfnt{; *
 */Flist )ry	p j			},
		/ S.eunct) {
					)ems[i] elems,uvit .ed)
		aled ] )ng" sipfn) st;
		orur iecieru },i
nb d::m				// stmng" s,edscripfne= cagynull ? 	/ S.on(mng" s,eprom,ddscripfne=ru },itunb d::m				// stmng" s,efne= cagynull ? 	/ S.off		ng" s,eprom,dfne=ru },i
	live:m				// stmng" s,edscripfne= cagy elems)  / S.cventmpl).ostmng" s,e	/ S.x{;
		or,sdscripfne=;
i]null ? 			thes},itdie:m				// stmng" s,efne= cagy elems)  / S.cventmpl).off		ng" s,e	/ S.x{;
		or ||0"**"ipfne=;
i]null ? 			thes},i
 deeeghat:m				// stm {;
		or,s "obs,sdscripfne= cagynull ? 	/ S.on(mng" s,e {;
		or,sdscripfne=ru },itundeeeghat:m				// stm {;
		or,s "obs,sfne= cagyot tmurn np

	 ) ) {
	 {;
		or,s "obs [,efn] )	//null ? th,
		dee				firu,=,
1n?s	/ S.off		 {;
		or,s"**nd(t 0	/ S.off		ng" s,ex{;
		or ||0"**"ipfne=;
itfor turgger:(, key, valng" ,Q scre(ncagynull ? 	/ S.eunct) {
					)ems[i] elems,uvit .turggertlng" ,Q scram				/l iecieru },itturggerHry 4.r:(, key, valng" ,Q scre(ncagyll ) 	/ Sdre;rn exe	null ?  elems,uvit .turggertlng" ,Q scram				dreip,

	//evb
vert dastogg4.:e, key, valfne= cagyot Savelrefen.fcumateth,
		deertlisdfn, i
ion lok ca
	yre vergs( ath,
		dee) keyurn   dfn.urn  ||0ata );
urn pr) keyin
 0f cu;togg4.r  (, key, valuvit {n obj !=ry  tg canout whis t fer ) { ateerecutl
yogyre vlastTogg4.7=0(dagment(_
JSOaled ] )"lastTogg4." +	fn.urn  )	 !=Ar)e% i;bj != elems,_
JSOaled ] )"lastTogg4." +	fn.urn ,vlastTogg4.7+t1E ev	// 	/t  DOM nodes and lumeks xtop	// 	uvit .r callsDack li(lox	// 	/t e
		
recutlDent ffer ) {uj !=			},
	argsdvlastTogg4.7].rguly(0ed ] )th,
		deer)	 !=flist ) [ 	;s
fpecilinkacks with, key, vs,vsooddedori} em( 		punb d:m				/lumektrry 4.renttogg4.r.urn   durn ;urns ilum(++ ) args.jqueryrate = [argsdvlue ].urn   durn ;urnip ty			},
	 / S.cumek(0eogg4.r =;
itfor hsS h:e, key, valfnOver,sfnOute(ncagynull ? 	/ S..ouse srnralfnOverl)..ouseleave(sfnOute !=fnOverl);vs ea)a data );
eunct (	blurieetL(jfntL(io eetL(sut load7resalumscrollgunload/lumektdbllumekt" +
	".ousedowna.ouseupa.ouseacks  ousesS h .ousesutl.ouse srnr .ouseleavet" +
	" fthe ax{;
		 oubmitakeydownakeyp			sakeyupaerractlventmplemu");nction(i, ,m				// st iipurn  fn.a tot Hry 4.7uvit {brinrn epata );
fn[ alse ) 	0) {
					rdscripfne= cagy {
		fnt{
	nt.do {
	efefnt{;
rim;lns[	rim( dpromise(}v	//null ? th,
		dee				firu>sAr?
 !=	/ S.on(murn  =prom,ddscripfne=r:exe	=			.turggertln
		 )ll;	;s
f&& jQrkeyEv.fr. {
			n
		 )nle it  elems,uvit .fixHg
kslsalse ) 	0 elems,uvit .keyHg
ks;se das&& jQr.ouseEv.fr. {
			n
		 )nle it  elems,uvit .fixHg
kslsalse ) 	0 elems,uvit ..ouseHg
ks;vs ea)a /*!
 *
Sizz4.7CSS S{;
		or Eng !m
 *
Copyr	} et2012i elemsmFpundhact-jectserun tlven[ bu
ors
 *
Releas byundectdy
	MIT ce);nsm
 *
.java.nsizz4.jS.cvm/
 */
t) {
					i i(and,nQuery.isFufn.

re vv] ||druvs,
	tml rtGetIdNotN
		,
	Expr,
	g'	Ttmp,
	isXML,
	 ck a	Q	,
	 cmpilu,
	nLoaOrdec,
	 riDu1 );hat,
	suter.ostCventmp,

	uas HriDu1 );hatu
  ; l,
	n ; uery.isFu& ({if ( !men,

	expto od=0(d"sizv] ||" +	Math.rto om(le=
, "" );
	".",0"ble,

	Tokent{;Sturn ,
	entElemet=	 i(and.entElemea
	entEe )  tentElemenentElemeEmatchea
	eirruvsn
 0f
	enne7{ 0f
	p
		=:[].p
	f
	push	=:[].push,
	nce);	=:[].nce);,
	ry by Da stur	ptc-downaarr, el  {
ajerim f0nne7id
Quavailtack
	irr, el =:[].irr, el  !=f key, value )ufn.
[ re vi7{ 0f
			lent{;=			.{
				v
		f) {
	i++ ) {
	value = c
	efell )  			di) 	&& ue )ufn.
[ //null ? iv
			}
		}
		null ? -1v
	},

	ot Augtchedat fer ) { f) {sid
	st
uy Dby
Sizz4.
	markrned.pro 	0) {
					rfn) fn = ufn.
[ fn[ expto od] 
 v	r ele{	nt.do !=v	r e;
		null ? fnv
	},

	 parseCh ||B
 ) {
					)em
[ re vth ||B
 {}f
			keysn
 ca;

		null ? markrned.prot) {
					ikey) fn = ufn.
[ ]ot Once keep t el.oss nucchedeen[ es
	efell ) keys.					}keyl)u>sExpr.f] ||Lqueryrate
[ //deeetlbv  ||m/keys.n	}
			 ]v
			}

exe	null ? (v  ||m/keyd] 
 v	r e)v
		},n   ||Brv
	},

	 lassCh ||B
  parseCh ||(e,
ttokenCh ||B
  parseCh ||(e,
t cmpilurCh ||B
  parseCh ||(e,

	ot Reger

	ot Whit np

	 vhe act.rsl.java.nwww.w3		if TR/css3-x{;
		ors/#whit np

	
	whit np

	u& ([\\x20\\t\\r\\n\\f]",
	ry .java.nwww.w3		if TR/css3-xyk ax/#vhe act.rs
t he act.rEnconrn u& ((?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",

	ot Loox{;yl.odeeeby njCSS id sr	fier vhe act.rs
tot A	punquoiodufn = u		oul		b Dl	CSS id sr	fier (.java.nwww.w3		if TR/css3-x{;
		ors/#at [ bu
e-x{;
		ors)
tot Proke  xyk ax: .java.nwww.w3		if TR/CSS21/xyk scr
arse#fn = -f (-id sr	fier
	id sr	fier =  he act.rEnconrn 
, "" );
	"w",0"w#ble,

	ot Afn,pttack oke a	ors .java.nwww.w3		if TR/x{;
		ors/#at [ bu
e-x{;
		ors
	ske a	ors & (([*^$|!~]?=)",
	at [ bu
es & (\\[" +	whit np

	u+0"*(" +	 he act.rEnconrn u+0")" +	whit np

	u+
		"*(?:" +	ske a	ors +	whit np

	u+0"*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" +	id sr	fier +0")|)|)" +	whit np

	u+0"*\\]",

	ot Prefen)th,
		deer	/tsi{
pan.fs/brlisets,
	ry  st reaat [ bu
eex{;
		ors e
			/n-pseudos (d sosed bye:),
	ry  st reaany			disire(
	ry Theselprefen.fcuslar l er ltoiedduclDent numb.r0 ec Ad
		ors
	ry  su camodis	kenalumjQQhavePSEUDOlpreFilter
	pseudos & (:(" +	 he act.rEnconrn u+0")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:" +	at [ bu
es +0")|[^:]|\\\\.)*|.*))\\)|)",

	ot  oh .	xmlExpr.POS e
		.	xmlExpr.u casCventmp
	p
s & (:(uvit|odd|eq|gt|lt|nth|fto f|last)(?:\\(" +	whit np

	u+
		"*((?:-\\d)?\\d*)" +	whit np

	u+0"*\\)|)(?=[^-]|$)",

	ot Lead	dise
			/n-escape:
erail	diswhit np

	, captuurn 	so] u	/n-whit np

	 vhe act.rslr cccamodisectlat er
	r	rim( dpct(RegExp( "^" +	whit np

	u+0"+|((?:^|[^\\\\])(?:\\\\.)*)" +	whit np

	u+0"+$",0"gble,

	r nmma( dpct(RegExp( "^" +	whit np

	u+0"*," +	whit np

	u+0"*ble,
	r nmbria	ors & pct(RegExp( "^" +	whit np

	u+0"*([\\x20\\t\\r\\n\\f>+~])" +	whit np

	u+0"*ble,
	rpseudo & pct(RegExp( pseudos e,

	ot Easily-pansetack/nul[ evtack ID ) {TAG ) {CLASS  Ad
		ors
	rqumekExpr & /^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,

	r	/ts& /^:	/t/,
	rsiblmodi& /[\x20\t\r\n\f]*[+~]/,
	rendsWithN/ts& /:	/t\($/,

	rheader = /h\d/i,
	rinpu
s = /inpu
| Ad
		|ntmpar a|putton/i,

	r lisslash	=:/\\(?!\\)/g,

	.	xmlExprB
 {
		"ID": pct(RegExp( "^#(" +	 he act.rEnconrn u+0")" e,
		"CLASS": pct(RegExp( "^\\.(" +	 he act.rEnconrn u+0")" e,
		"NAME": pct(RegExp( "^\\[alse=['\"]?(" +	 he act.rEnconrn u+0")['\"]?\\]" e,
		"TAG": pct(RegExp( "^(" +	 he act.rEnconrn 
, "" );
	"w",0"w*nd(t+0")" e,
		"ATTR": pct(RegExp( "^" +	at [ bu
es e,
		"PSEUDO": pct(RegExp( "^" +	pseudos e,
		"POS": pct(RegExp( p
sam"i" e,
		"CHILD": pct(RegExp( "^:(veue|nth|fto f|last)-child(?:\\(" +	whit np

	u+
			"*(uvit|odd|(([+-]|)(\\d*)n|)" +	whit np

	u+0"*(?:([+-]|)" +	whit np

	u+
			"*(\\d+)|))" +	whit np

	u+0"*\\)|)"am"i" e,
		ot  oh use[jQQlibrl[ es impmatchern u.is()
		"u casCventmp": pct(RegExp( "^" +	whit np

	u+0"*[>+~]|" +	p
sam"i" e
	},

	ot SentLoa

	ot Ustd*eed  {
	rn 	so] 			dist-jecsematche
	tml rt 	0) {
					rfnufn.
[ re vdiv  tentElemen parseEmatche("div");

		tryte
[ /null ? fn(vdiv )v
		} caxmle(e)te
[ /null ? flist 
		} fin	rlyn.
[ ]ot releas iected"b ieIE
[ ]div  tpromi
		}
	},

	ot Cfirssll geeEmatchesByTagse()j"*b); *
 */soveuereoLoit o
	tml rtTagse()NoCnmm		vs( atml rtt) {
					idiv )n.
[ div.rguendChild(tentElemen parseCnmm		v("" {n;
		null ? !div.geeEmatchesByTagse()j"*b).{
				v
	}),

	ot Cfirssll geeAt [ bu
ee *
 */soey evealud href	at [ bu
es
	tml rtHrefNotNy evealud  atml rtt) {
					idiv )n.
[ div.innerHTML & (<a href='#'></a>";
		null ? div.fto fChildotring"  ( div.fto fChild.geeAt [ bu
ee!& tn ; uery.isFu&&
[ ]div.fto fChild.geeAt [ bu
e("href"= e{
	"#"v
	}),

	ot Cfirssll at [ bu
es 		oul		b Dnul[ eved byeat [ bu
eeow ob
	tml rtAt [ bu
es & tml rtt) {
					idiv )n.
[ div.innerHTML & (< Ad
		></ Ad
		>";
		re vtion" d	g"  ( div.lastChild.geeAt [ bu
e("multipma"n;
		esoIE8e *
 */soa sturn  f) {so] uat [ bu
es uvit0s rean
		presche
	ynull ? 	g"  !{
		boole=n"utring"  !{
		sturn  v
	}),

	ot Cfirssll geeEmatchesByClassN
		 lansb D ; ssed
	tml rtUrn() ClassN
		 & tml rtt) {
					idiv )n.
[ ot Oke a	e gh, o d:aahxt		}

 lassalse ( ie9.6)
[ div.innerHTML & (<div  lass='hidde(se'></div><div  lass='hidde('></div>";
		 {
		!div.geeEmatchesByClassN
		 ||	!div.geeEmatchesByClassN
		("eb).{
				 )te
[ /null ? flist 
		}

		ot Safari 3.2n   ||s  lassuat [ bu
es e
		ioMs Thecaxmle fthe s
[ div.lastChild.classN
		 & "eb;
		null ? div.geeEmatchesByClassN
		("eb).{
				 e{
	2v
	}),

	ot Cfirssll geeEmatcheByIde *
 */soeoLoit owbye{
		
	ot Cfirssll geeEmatchesByN
		 privileges*eedetlven[ols ) { *
 */soeoLoit owbyeID
	tml rtUrn() N
		 & tml rtt) {
					idiv )n.
[ ot Inse:  lventhe
	ydiv.idl=0uxpto od+ 0;
[ div.innerHTML & (<a alse='" +	uxpto od+ "'></a><div alse='" +	uxpto od+ "'></div>";
		entEe ).inl rtBe ) e	idiv	  ocEe ).fto fChildo);

		ry T{
	
		re vpjec	 tentElemengeeEmatchesByN
		 &&
[ ]ot buggy b mws.rs	 ihe null ? fewn n	an		} ell( e jQ	2
[ ]dntElemengeeEmatchesByN
		(	uxpto od).{
				 e{
	2u+
			ot buggy b mws.rs	 ihe null ? munct	an		} ell( e jQ	0
[ ]dntElemengeeEmatchesByN
		(	uxpto od+=Ar).{
				v
		tml rtGetIdNotN
			 t!dntElemengeeEmatcheById(	uxpto od);

		ry dringup
		entEe ).ed)
		Child(teiv )v

		null ? pjecv
	})v

ecidelnce);	id
n 		availtack,	providiac  lisup
tryte
[pce); :
				entEe ).childN	} samAr)[0]werCa.isWv
} caxmle(  ufn.
[nce);	=:				// st iufn.
[ re vue )a
[ /nus lisn
 ca;
		f) {
	i+(ue )  t 			di))value = c
	efenus lis.					}ue )y.!
		}
	]null ? ars lisv
	}v
}

 fer ) { Sizz4.		 {;
		or,slventmp, ars lis,ex{sFufn.
/nus lisn
 nus lisn||0 [;
	 ck tmpl=slventmpd !=entElemer
	re vm	xml,	ue )amxml, )a
[ erCa.isWi
slventmpwerCa.isWv

s[peof !x{;
		or ||0 "objec Ad
		or !& t"sturn  i)em
	]null ? ars lisv
	}

s[peof erCa.isWi!=,
1ntrierCa.isWi!=,
9i)em
	]null ?  [;
	}

s[xmli
sisXML(slventmpd)v

s[peof !xmlicallo{sFufn.
/[peof (m	xmln=0rqumekExpr.
recjQst;
		oru.)) {

			ot Sp{sF-ukj Sizz4.	"#ID")
[ [peof (m epma fi[1])) {

			[peof erCa.isWi==,
9i)em
	]			toLoi
slventmpwgeeEmatcheById(	)y.!
		 !=ot dfirssparistN	} lto caxmles reaB" )kberryt4.6{ *
 */s
		 !=ot ow obs and athen
 longeroi		} eloutElemet#6963
		 !=ll ) ue )rth -1 ]wparistN	} les 
		 !=tot Hry 4.7= li		s i a theIE, Oke a,jectsWebkit null ? it ms
		 !=tot bye{
				Q		ead0 ecID
			 !=ll ) ue ).idl=== mles 
		 !=tenus lis.					}ue )y.!
			[ //null ? ars lisv
						}
					tfire(  
						null ? ars lisv
					}
				tfire(  
					ot dventmpdid
n 		aloutEleme
		 !=ll ) lventmpwownerDntEleme red(toLoi
slventmpwownerDntElemewgeeEmatcheById(	)y.) &&
[ ]			 ck a	Q	(	lventmp, ue )ufnth -1 ]widl=== mles 
		 !=tnus lis.					}ue )y.!
			[ /null ? ars lisv
					}
				t

exe	ot Sp{sF-ukj Sizz4.	"TAG")
[ [	fire(  {
		ma fi[2]les 
		 !				.rguly(0ars lis,exce); :
			lventmpwgeeEmatchesByTagse()jQst;
		oru.,	0) .!
			[null ? ars lisv

exe	ot Sp{sF-ukj Sizz4.	".CLASS")
[ [	fire(  {
		(m epma fi[3])acaltml rtUrn() ClassN
		 trivventmpwgeeEmatchesByClassN
		 es 
		 !				.rguly(0ars lis,exce); :
			lventmpwgeeEmatchesByClassN
		( mle,	0) .!
			[null ? ars lisv
			}
		}
	}

	ot Ahe erun s
	rull ? st;
		jQst;
		or
, "" );
	r	rim, "$1" e,slventmp, ars lis,ex{sFamxml .!
}

Sizz4..ma fi	s  (, key, valuxpr,oeoLoit owfn.
/null ? Sizz4.		uxpr,oprom,dprom,due )	deer);
};

Sizz4..ma fi	sS{;
		or ==f key, value ),	uxprwfn.
/null ? Sizz4.		uxpr,oprom,dprom,d[0ueng
]B))			firu>sA;
};

ot Re
 */soa  fer ) { ateuse[jQQpseudos f) {inpu
	ng" s
 fer ) {  parseInpu
Pseudo(lng" ele.
/null ? f key, value )ufn.
[ re v{
			
 -1 ]werCaN
		.toL namCasttr;
		null ? n
		)=& t"inpu
""th -1 ]wtion"=& ttisWv
	}v
}

ot Re
 */soa  fer ) { ateuse[jQQpseudos f) {puttoni
 fer ) {  parseButtonPseudo(lng" ele.
/null ? f key, value )ufn.
[ re v{
			
 -1 ]werCaN
		.toL namCasttr;
		null ? (n
		)=& t"inpu
""||0n
		)=& t"putton")"th -1 ]wtion"=& ttisWv
	}v
}

ot Re
 */soa  fer ) { ateuse[jQQpseudos f) {posi ) {lis
 fer ) {  parsePosi ) {liPseudo(lfnufn.
[null ? markrned.prot) {
					ith,
		deufn.
[ th,
		deu= +th,
		de;
		null ? markrned.prot) {
					ix{sFamma fi	s es 
		 re vja
[ /	.	xmlIrr, 	s  (,		i[],ex{sF)			fir,ith,
		deufa
[ /	i epma fiIrr, 	s.{
				v

exe	ot M	xmlnue )	deerfpundsnd } el#id
			if irr, 	s
exe	s ilum(++--) {

			[peof x{sF[ (j epma fiIrr, 	sdi)) ]les 
		 !	x{sF[j] 
 !(ma fi	s[j] 
 x{sF[j].!
			[}
			}
		})v
	})v
}

o**
 *
Utilityt fer ) { f) {nul[ evmodisectntmpdfn = u eca? thraedoriwindow ob
 *
@param {Ahrae|Ematche}nue )
 */
g'	Ttmpt{;Sizz4..g'	Ttmpt{;f key, value )ufn.
[re v{	} ,
		nul & (",
		i7{ 0f
		erCa.isWi
s-1 ]werCa.isWv

s[peof erCa.isWifn.
/[peof erCa.isWi==,
1"||0nrCa.isWi==,
9i||0nrCa.isWi==,
11) {

			ot by DetmpCventhe f) {eoLoit o
	tyot innerTtmptusag(aed)
		dwfactlves, iefcedoripct(lin	s (x{s #11153)
[ [peof  "objec-lLo.etmpCventhe =& t"sturn  i)em
			[null ? -lLo.etmpCventhe;
[ [	fire( m
			[eciTravn sesn
s	childris
			[f) {
	toLoi
see ).fto fChild;see );	toLoi
see ).ntmpSiblmodies 
		 !	nul += g'	Ttmp	}ue )y.!
			[}
			}
		}fire(  {
		erCa.isWi
& t3 ||0nrCa.isWi==,
4 )te
[ /null ? -1 ]werCaV	r e;
		}
		ry Dor	/tsi{clu o cnmm		v ) {pron, imodi	hn ; r ) { ow ob
		fire( m

[ ot Ifpn turCa.isWam				/		/uxp
		e:
eo	b Dl? thrae
		f) {
	i+(()Ca =0ue )[i))value = c
	efery Dor	/tstravn sescnmm		v ow ob
	!	nul += g'	Ttmp	}()Ca .!
		}
	}
[null ? arg 
};

isXMLt{;Sizz4..isXMLt{;f key, value )ufn.
[ot fntElemeEmatche/		/vn 			if factlastss a thei  ioMs Theyeiost, i
[ot (sus tas loadmodi	frrn nn ieIEv- #4833)
[re vdntElemeEmatche/= ue )rth (-1 ]wownerDntEleme  !=-1 ]).entElemeEmatche;
[null ? dntElemeEmatche/? dntElemeEmatche.erCaN
		 !& t"HTML"l:		list 
};

ot Ematche/ ck a	Q	 anerun 
 ck a	Q	 {;Sizz4.. ck a	Q	 {;entEe ).cck a	Q	 ?
exf key, vala,jbufn.
[ re vadowna= a.nrCa.isWi==,
9i? a.dntElemeEmatche/:la,
	!	bu		=:btcalpwparistN	} k
		null ? ai==,
bu		||	!!(
bu		calpup.erCa.isWi==,
1"caltdown.cck a	Q	 caltdown.cck a	Q	(pup) .!
	} :
	entEe ).cvmpariDntElemePosi ) { ?
exf key, vala,jbufn.
[ null ? btcal!!(
a.cvmpariDntElemePosi ) {(jbufn& 16 .!
	} :
	f key, vala,jbufn.
[ s ilum(+(b	=:bwparistN	} )) {

			peof bi==,
ai)em
			[null ?  ; li
			}
		}
	/null ? flist 
	};

Sizz4..at [ ==f key, value ),	n
		 es 
	re vfn ,
	!xmli
sisXML(sue )y.!

s[peof !xmli)em
		{
			
 n
		.toL namCasttr;
	}
s[peof (vst
=/Expr.at [Hry 4.lsalse ))ufn.
[ null ? vst	}ue )y.!
	}
s[peof xmli||	tml rtAt [ bu
es fn.
[ null ? -1 ]wgeeAt [ bu
e(ln
		 )l
	}
s[vst
=/-1 ]wgeeAt [ bu
eN	} (ln
		 )l
	null ? vst ?
ex	 "objec-lLo[ alse ) 	&& (boole=n"u?
ex		-lLo[ alse ) ? alse :	nt.do:
		 rel.#id
			if ? vst.fn = u:	nt.do:
		promi
};

ExprB
 Sizz4..x{;
		ors = m

[ot dtg b Dldj ssed bye	prousem
[f] ||Lquery: 50,

	 parsePseudo: markrned.pro,

	.	xml:	.	xmlExpr,

	ot IE6/7 null ? aimod			if href
	at [Hry 4.:etml rtHrefNotNy evealud ?
ex	{} :
		m
			"href": f key, value )ufn.
[ [ null ? -1 ]wgeeAt [ bu
e(l"href", 2y.!
			}f
			" "ob": f key, value )ufn.
[ [ null ? -1 ]wgeeAt [ bu
e(" "ob")i
			}
		},

	f d::m.
[ "ID": tml rtGetIdNotN
			?
ex						// st id,slventmp, xmli)em
		 [peof  "objeclventmpwgeeEmatcheByIde!& tn ; uery.isFu&& !xmli)em
				 re voi
slventmpwgeeEmatcheById(	idy.!
		 !=ot dfirssparistN	} lto caxmles reaB" )kberryt4.6{ *
 */s
		 !=ot ow obs and athen
 longeroi		} eloutElemet#6963
		 !=null ? mu&& ]wparistN	} l? [m]u:	ca;
			[}
			}o:
		 				// st id,slventmp, xmli)em
		 [peof  "objeclventmpwgeeEmatcheByIde!& tn ; uery.isFu&& !xmli)em
				 re voi
slventmpwgeeEmatcheById(	idy.!

		 !=null ? mu?
		 !=	]widl=== n  ||0 "objec]wgeeAt [ bu
eN	} e!& tn ; uery.isFu&& ]wgeeAt [ bu
eN	} ("id").v	r ele{
	idu?
		 !=		[m]u:
		 !=		 uery.isFu:
		 !=	ca;
			[}
			},

		"TAG": tml rtTagse()NoCnmm		vs(?
ex						// st tag,slventmpd)em
		 [peof  "objeclventmpwgeeEmatchesByTagse()e!& tn ; uery.isFues 
		 !	null ? lventmpwgeeEmatchesByTagse()jQtagy.!
			[}
			}o:
		 				// st tag,slventmpd)em
		 [re vn's lisn
 lventmpwgeeEmatchesByTagse()jQtagy.!

			[eciFilternout possiblescnmm		vs
		 [peof  agy	&& (*"i)em
				 re vue )a
[ ////tm		=:[]a
[ ////		=: i

		 !=f) {
	i+(ue )  tn's lis[i))value = c
	efe	!=ll ) ue ).erCa.isWi==,
1"es 
		 !=tetm	.					}ue )y.!
			[ /}
					t

		 !=null ? tm	!
			[}
			[null ? ars lisv
			},

		"NAME": tml rtUrn() N
		 calf			// st tag,slventmpd)em
		 peof  "objeclventmpwgeeEmatchesByse()e!& tn ; uery.isFues 
		 !null ? lventmpwgeeEmatchesByse()jQn
		 )l
			}
		},

		"CLASS": tml rtUrn() ClassN
		 trif			// st classN
		,slventmp, xmli)em
		 peof  "objeclventmpwgeeEmatchesByClassN
		 !& tn ; uery.isFu&& !xmli)em
				null ? lventmpwgeeEmatchesByClassN
		( classN
		 )l
			}
		}
	},

	n'atiive:m.
[ ">": { dir:i"paristN	} "ipfto f: lude }f
		" ": { dir:i"paristN	} " }f
		"+": { dir:i"previousSiblmod"ipfto f: lude }f
		"~": { dir:i"previousSiblmod" }
	},

	preFilter:m.
[ "ATTR": f			// st m	xmle in
			ma fi[1] epma fi[1]
, "" );
	r lisslash,0"blev

exe	ot Mcks } elgivit0v	r elto ma fi[3]es rrun tquoioduoh unquoiod
			ma fi[3]d=0(dma fi[4]e||0ma fi[5]e||0"ble
, "" );
	r lisslash,0"blev

exe	 {
		ma fi[2]l	&& (~="i)em
				ma fi[3]d=0"t" + ma fi[3]e+0"t"l
			}

	!	null ? maxml.xce);( 0,
4 );
		},

		"CHILD": f			// st m	xmle in
			/*mma fi	s 			em.	xmlExpr["CHILD"]
				1lng" e(veue|nth|...)
[ [	2ith,
		deu(uvit|odd|\d*|\d*n([+-]\d+)?|...)
[ [	3 xn-cvmpon		v )f xn+yith,
		deu([+-]?\d*n|)
[ [	4 sign )f xn-cvmpon		v
[ [	5 x )f xn-cvmpon		v
[ [	6 sign )f y-cvmpon		v
[ [	7 y )f y-cvmpon		v
[ [*/
			ma fi[1] epma fi[1]
toL namCasttr;

exe	 {
		ma fi[1]l	&& (nth"i)em
				ot oth-child arquincvath,
		de
		 [peof !ma fi[2]les 
		 !	Sizz4..errac		ma fi[re;r!
			[}

				ot o
		ric x ectsy paramet.rslf) {Expr. ilter.CHILD
				ot ratcmb.r0 and flist/lude cass nu#id
iivelylto 0/1
				ma fi[3]d=0+( ma fi[3]e?dma fi[4]e+ (m	xml[5]e||01(t 02 *
		ma fi[2]l	&& (uvit"e||0ma fi[2]l	&& (odd"r {n;
				ma fi[4]d=0+( 		ma fi[6] + ma fi[7]r)	 !=ma fi[2]l	&& (odd"r v

exe	ot erun t "obs prohibi		ah,
		dee
[ [	fire(  {
		ma fi[2]les 
		 !Sizz4..errac		ma fi[re;r!
			}

	!	null ? maxml;
		},

		"PSEUDO": f			// st m	xmle in
			re vunquoiod,	uxn, i;
exe	 {
		ma fiExpr["CHILD"]. {
			ma fi[re;ri)em
				null ? promi
			}

	!	 {
		ma fi[3]i)em
				ma fi[2] epma fi[3]v
			}fire(  {
		(unquoiodu=dma fi[4])i)em
				ot Once  firssch,
		deer and lck a	Qvalpseudo
		 [peof rpseudo. {
		unquoiod) &&
[ ]		ot Geiostn, i
			ems	kenalum(recursively)
[ [		(stn, i
=ms	kenalu(vunquoiod,	,

	//) &&
[ ]		ot advafcumateent ntmpd lokmodiparisti	sis
[ [		(stn, i
=munquoiod.irr, el(0")",munquoiod.			firu-ostn, i
)e-ounquoiod.			fir)ufn.

[ ]		ot stn, i
isoa neghacve irr, 
[ ]		unquoiodu=dunquoiod.xce);( 0,
stn, i
)!
			[ ma fi[re;=	ma fi[re.xce);( 0,
stn, i
)!
			[}
				ma fi[2] epunquoiodi
			}

	!	ot Re
 */oveuercaptuues(u cae		bye	propseudo  ilter ] 	hod (ng" eectsch,
		de)
	!	null ? maxml.xce);( 0,
3 .!
		}
	},

	f lter:m.
[ "ID": tml rtGetIdNotN
			?
ex						// st idd)em
		 [pdu=did
, "" );
	r lisslash,0"blev
				null ? f key, value )ufn.
[ [  null ? -1 ]wgeeAt [ bu
e("id")le{
	id!
			[}v
			}f:
		 				// st idd)em
		 [pdu=did
, "" );
	r lisslash,0"blev
				null ? f key, value )ufn.
[ [  re v{	} " d	g"  ( -1 ]wgeeAt [ bu
eN	}  !& tn ; uery.isFu&& -1 ]wgeeAt [ bu
eN	} ("id");
[ [  null ? n	} lcaln	} .v	r ele{
	id!
			[}v
			},

		"TAG": ) {
					rurCaN
		 )nm
		 peof urCaN
		 	&& (*"i)em
				null ? f key, va)em null ?  ; li }i
			}
			erCaN
			 terCaN
		., "" );
	r lisslash,0"ble
toL namCasttr;

exe	null ? f key, value )ufn.
[ [ null ? -1 ]werCaN
		 tri-1 ]werCaN
		.toL namCasttr 	&& erCaN
		i
			};
		},

		"CLASS": f			// st classN
		e in
			re vpat erna=  lassCh ||[ expto od][ classN
		e];
exe	 {
		!pat ernaes 
		 !	at erna=  lassCh ||t classN
		,spct(RegExp("(^|" +	whit np

	u+0")" +	classN
		e+0"(" +	whit np

	u+ "|$)") )l
			}
			null ? f key, value )ufn.
[ [ null ? 	at ern. {
			-1 ]wclassN
		 ||	(	g"  ( -1 ]wgeeAt [ bu
e !& tn ; uery.isFu&& -1 ]wgeeAt [ bu
e("class"))e||0"blei
			};
		},

		"ATTR": f			// st urn  =ske a	or,  firss)te
[ /null ? f key, value ),	lventmpd)em
		 [re vn's liB
 Sizz4..at [alue ),	n
		 ei

		 !peof r's liB

	nt.do {

[ [  null ? ske a	or 	&& (!="!
			[}
				 {
		!ske a	or  {

[ [  null ?  ; li
			[}

				r's liB+& (";

				r'll ? ske a	or 	&& (="i? r's liB

=  firss:
		 !=ske a	or 	&& (!="i? r's liB!
=  firss:
		 !=ske a	or 	&& (^="i?  firss&& r's li.irr, el(0 firss)t
=,
0r:
		 !=ske a	or 	&& (*="i?  firss&& r's li.irr, el(0 firss)t> -1r:
		 !=ske a	or 	&& ($="i?  firss&& r's li.subs [alr's li.			firu-o firs.{
				 )t

=  firss:
		 !=ske a	or 	&& (~="i? (0"t" + r's liB+0"t" ).irr, el(0 firss)t> -1r:
		 !=ske a	or 	&& (|="i? r's liB

=  firss||0r's li.subs [al0,o firs.{
				 +t1E B

=  firss+0"-"r:
		 !=flist 
			};
		},

		"CHILD": f			// st ng" ,Qch,
		deipfto f,vlastufn.

[ ]peof  "obl	&& (nth"i)em
				null ? f key, value )ufn.
[ [  re v{	} ,kChffa
[ ////parist
=/-1 ]wparistN	} k

[ /// {
		fto fi==,
1"callastu
=,
0rn o
[ ////null ?  ; li
			[	t

		 != {
		parist
n o
[ ////Chff	=: i
[ ////f) {
	{	} " dparist.fto fChild;s{	} ;	{	} " dn	} .ntmpSiblmodies 
		 !		 peof urCa.erCa.isWi==,
1"es 
		 !=te/Chff++;
		 !=te/ll ) ue )r	&& erCa"es 
		 !=te/	break;
		 !=te/}
		 !=te}
		 !=t}
					t

		 !=ot IncorporatlDent off {
7(actlasr / sNaN)am, rea firsscga	Q	pd yclumsalu
		 !=Chff	-=llast;
[ [  null ? Chff	=

	 to fi||0(aChff	%	fto fi==,
0"calChff	/	fto fi>,
0rn!
			[}v
			}

exe	null ? f key, value )ufn.
[ [ re v{	} " dee );

		 !swixmle( ng" ele.
/////		s i"veue":
/////		s i"fto f":
///// s ilum(+({	} " dn	} .previousSiblmod)ies 
		 !		 peof urCa.erCa.isWi==,
1"es 
		 !=te/null ? flist 
		 !=te}
		 !=t}

		 !=tpeof  "obl	&& (fto f"les 
		 !=tenull ?  ; li
			[	t}

		 !=t{	} " dee );

		 !		/*mfliler arough */
			//		s i"last":
///// s ilum(+({	} " dn	} .ntmpSiblmod)ies 
		 !		 peof urCa.erCa.isWi==,
1"es 
		 !=te/null ? flist 
		 !=te}
		 !=t}

		 !=tnull ?  ; li
			[}
			};
		},

		"PSEUDO": f			// st pseudo,ith,
		deufn.
[ =ot pseudo- lassuurn n athe		s -inl nsi )ve
[ =ot .java.nwww.w3		if TR/x{;
		ors/#pseudo- lasseo
	tyot Priori )z Dby
		s il nsi )vitytion 	s ilustomlpseudos atheadae		 arg upke  	s ilett.rs
tl ry Rd)cmb.r0 and  {
Filternn iheri on			empseudos
			re vargsa
[ //fnt{;Expr.pseudos[opseudo ]e||0Expr. {
Filtern[opseudo.toL namCasttr ]e||
		 !=Sizz4..errac		"untentLoaifo seudo: " +	pseudor v

exe	ot Tprousemtma;
use[ parsePseudo / srinrcatlDenat
exe	ot ch,
		deerathen cae		to cparselwith,ilter f			// s
exe	ot j sstas Sizz4.7ioMs
[ ]peof fn[ expto od] )em
				null ? f		ith,
		deufi
			}

	!	ot Butl.a	Q a	QvtentLoalf) {old signatuues
[ ]peof fn)			firu>s1"es 
		 !ergs( a[ pseudo,ipseudo,i"",ith,
		deua;
			[null ? Expr. {
Filtern.hasOwnProke ty(opseudo.toL namCasttr )u?
		 !=markrned.prot) {
					ix{sFamma fi	s es 
		 			re vidxa
[ ////	ma fi Fu
 f		ix{sFamth,
		deufa
[ /		/	i epma fiod.			fir;
///// s ilum(++--) {

			[	/	idxu=dirr, el :
				x{sFamma fi	ddi) .!
			[ //x{sF[ idxu] 
 !(mma fi	s[ idxu] 
 ma fi	ddi) .!
			[ /}
					t)r:
		 !=f key, value )ufn.
[ [  	null ? f		iue ),	0,vergs(.!
			[ }v
			}

exe	null ? fn!
		}
	},

	pseudos:m.
[ "nop": markrned.prot) {
					ix{;
		oru.n.
[ =ot Trim(} el#{;
		orupjece		to ccmpilu
[ =ot atetvoidutrea	rn 	lead	dise
		erail	di
[ =ot np

	onasd nmbria	ors
			re vinpu
	=:[]a
[ //nus lisn
 caa
[ /	.	xmler =  cmpilujQst;
		or
, "" );
	r	rim, "$1" e r;

exe	null ? .	xmler[ expto od] ?
[ /	.	rkrned.prot) {
					ix{sFamma fi	s,slventmp, xmli)em
		 [ re vue )a
[ ////unma fi Fu
 .	xmler	ix{sFamprom,dxml, []ufa
[ /		/i 
 x{sF.{
				v

exe	e	ot M	xmlnue )	deerunma fi Fuby
`.	xmler`
exe	e	s ilum(++--) {

			[	/ {
		(ue )  tunma fi Fdi))  {

			[	/	x{sF[i] 
 !(ma fi	s[i] 
 -1 ])!
			[ /}
					t
				t)r:
		 !f key, value ),	lventmp, xmli)em
		 [ inpu
[re;=	ee );
////	ma fi r	iinpu
amprom,dxml, nus lisn);
[ [  null ? !nus lis.	op(n!
			[}v
		}),

		"has": markrned.prot) {
					ix{;
		oru.n.
[ =null ? f key, value )ufn.
[ [ null ? Sizz4.		 {;
		or,sue )uf)			firu>sA;
		[}v
		}),

		"cck a	Q	": markrned.prot) {
					intmpd)em
		 null ? f key, value )ufn.
[ [ null ? (c-lLo.etmpCventhe  !=-1 ].innerTtmpt !=g'	Ttmp	}ue )y. ).irr, el(0ntmpd)e> -1v
		[}v
		}),

		"enn() d": f key, value )ufn.
[ [null ? -1 ]wdirn() dt{

	 If I;
		},

		"dirn() d": f key, value )ufn.
[ [null ? -1 ]wdirn() dt{

	 ; li
		},

		"lfirsmen: f key, value )ufn.
[ [ot In	CSS3, :lfirsme 		oul		null ? both lfirsme e
		 {;
		td*
oLoit o
	tyot .java.nwww.w3		if TR/2011/REC-css3-x{;
		ors-20110929/#vhirsme
			re verCaN
			 t-1 ]werCaN
		.toL namCasttr;
			null ? (nrCaN
		 	&& (inpu
""th !!-1 ]wchirsme)e||0(nrCaN
		 	&& (op// s ith !!-1 ]w {;
		td);
		},

		" {;
		tdn: f key, value )ufn.
[ [ot Acn, imodi				/proke ty makes 	{;
		td-by-f (k li
[ [ot op// snn ieSafari work/proke ly
[ ]peof -1 ]wparistN	} ufn.
[ [ -1 ]wparistN	} w {;
		tdIrr, v
			}

exe	null ? -1 ]w {;
		tdt{

	 ; li
		},

		"parist": f key, value )ufn.
[ [null ? !Expr.pseudos["
	sel"]	}ue )y.!
		},

		"e	sel": f key, value )ufn.
[ [ot .java.nwww.w3		if TR/x{;
		ors/#e	sel-pseudo
		 ot :
	sel;isoveueraff
		tdtbereoLoit  ow obsects venthe ow ob(i{clu modi	tmp	3e,sl
JSOa4)fa
[ /ry  suotscnmm		v,{pron, imodi	hn ; r ) {s,s) {orun s
	e	ot Tpanks ateDiego Perini*eed  heverCaN
					ortcut
[ /ry  sGparse n	an		"@" meaQ	 alpha vhe act.rsl(#id
			c	rlynuotsstar	rn 	 arg "#"s) {"?")
[ [re verCa.isWv
			toLoi
see ).fto fChild;
			s ilum(+ue )ufn.
[ [ ll ) ue ).erCaN
			>	"@" ||0(nrCa.isWi
s-1 ]werCa.isW)i
& t3 ||0nrCa.isWi==,
4 )te
[ /e/null ? flist 
		 !}
[ [ -1 ]i
see ).ntmpSiblmodl
			}
			null ?  ; li
		},

		"header": f key, value )ufn.
[ [null ? rheader. {
			-1 ]werCaN
		 )i
		},

		"ntmp": f key, value )ufn.
[ [re vtion,uat [;
[ [ot IE6sects7	 ihe map e1 ]wtion"ate'ntmp'*eed pct(HTML5t "obs (searml,	utc)
[ [ot use[geeAt [ bu
e 	Q		ead0ateeesr /			/lase
exe	null ? -1 ]werCaN
		.toL namCasttr 	&& (inpu
""th
[ [ (tisWi
s-1 ]wtisW)i
& t"ntmp""th
[ [ ( (at [ ==-1 ]wgeeAt [ bu
e(" "ob"))le{	nt.do !=at [.toL namCasttr 	&& ng" eli
		},

		ot Inpu
	ng" s
		"ion o :  parseInpu
Pseudo("ion o e,
		"lfirsbox":  parseInpu
Pseudo("lfirsbox" ,
		",ile":  parseInpu
Pseudo(",ile" ,
		"pjecword":  parseInpu
Pseudo("pjecword" ,
		"image":  parseInpu
Pseudo("image"),

		"oubmit":  parseButtonPseudo("oubmit" ,
		"resct":  parseButtonPseudo("resct"),

		"putton": f key, value )ufn.
[ [re v{
			
 -1 ]werCaN
		.toL namCasttr;
			null ? n
		)=& t"inpu
""th -1 ]wtion"=& t"putton""||0n
		)=& t"putton"i
		},

		"inpu
": f key, value )ufn.
[ [null ? rinpu
s. {
			-1 ]werCaN
		 )i
		},

		"eetL(": f key, value )ufn.
[ [re vdoc	
 -1 ]wownerDntEleme;
exe	null ? -1 ])=& tdoc.ad.pveEmatcherth (!dnt.hasFetL(j !=ent.hasFetL(())tcal!!(-1 ]wtion" !=-1 ].href)i
		},

		"ad.pve": f key, value )ufn.
[ [null ? -1 ] 	&& ue )wownerDntElemewad.pveEmatchei
		},

		ot Posi ) {li	ng" s
		"fto f":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [null ? [ 0ua;
		}),

		"last":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [null ? [ 			firu-o1ua;
		}),

		"eq":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [null ? [ th,
		deu<sAr? th,
		deu+ 			firu:ith,
		deua;
		}),

		"evit":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [f) {
	re vi7{ 0i++ ) {
				v++ +
	2u)em
				ma fiIrr, 	s.					}i )l
			}
			null ? ma fiIrr, 	s;
		}),

		"odd":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [f) {
	re vi7{ 1i++ ) {
				v++ +
	2u)em
				ma fiIrr, 	s.					}i )l
			}
			null ? ma fiIrr, 	s;
		}),

		"lt":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [f) {
	re vi7{ th,
		deu<sAr? th,
		deu+ 			firu:ith,
		de; --ii>,
0;u)em
				ma fiIrr, 	s.					}i )l
			}
			null ? ma fiIrr, 	s;
		}),

		"gt":  parsePosi ) {liPseudo(f			// st m	xmlIrr, 	s, 			fir,ith,
		deufn.
[ [f) {
	re vi7{ th,
		deu<sAr? th,
		deu+ 			firu:ith,
		de; +++ ) {
				v+)em
				ma fiIrr, 	s.					}i )l
			}
			null ? ma fiIrr, 	s;
		})
	}
s};

 fer ) { siblmoddfirsala,jb, nueufn.
[ll ) ei==,
b fn.
[ null ? arg 
	}

exre vtura= a.ntmpSiblmodl

	s ilum(+turafn.
/[peof tura==,
b fn.
[ 	null ? -1v
		}

exetura= tur.ntmpSiblmodl
	}

	n'll ? 1v
}

nLoaOrdec {;entEe ).ccmpariDntElemePosi ) { ?
exf key, vala,jbufn.
[ ll ) ei==,
b fn.
[ 	 riDu1 );hat 
	 ; li
			n'll ? 0v
		}

exenull ? (c!a.cvmpariDntElemePosi ) {	||	!b.ccmpariDntElemePosi ) { ?
ex		a.cvmpariDntElemePosi ) {	:
ex		a.cvmpariDntElemePosi ) {(bfn& 4
ex	)r? -1r: 1v
	} :
	f key, vala,jbufn.
[ ot Tproow obsetheid sr	c	r,Eferlansexit early
[ ll ) ei==,
b fn.
[ 	 riDu1 );hat 
	 ; li
			n'll ? 0v

[ ot F	rl lis ateusrn 	sourceIrr,  ( ieIE)  {
it's	availtackst-jboth ow ob
	!}fire(  {
		a.sourceIrr,  calpwsourceIrr,  fn.
[ 	null ? a.sourceIrr,  -lpwsourceIrr, v
		}

exere val, bla
[ /a		=:[]a
[ /b		=:[]a
[ /au		=:awparistN	} ,
	!	bu		=:bwparistN	} ,
	!	tura= aupv

[ ot If  heverCabsethesiblmods7(actid sr	c	r)Eferlansdo eiqumek lfirs
[ ll ) eu		==,
bu		fn.
[ 	null ? siblmoddfirsala,jbd);

		ry Ifpn tparistsEfethefpunds, rea heverCabsethedisconn
		td
	!}fire(  {
		!au		fn.
[ 	null ? -1v

	!}fire(  {
		!bu		fn.
[ 	null ? 1v
		}

exeot Orun wiselwity'thesome a theire(  ea hevtrehesoEfern ca
exeot eo	build u		a  f.dolistdori} esparistN	} swfactlvmparis s
exes ilum(+turafn.
/[/a	.unn	}
		+turaf;
	!	tura= tur.paristN	} k
		}

exetura= bupv

[ s ilum(+turafn.
/[/b	.unn	}
		+turaf;
	!	tura= tur.paristN	} k
		}

exest
=/a	.			fir;
//bt
=/bp.{
				v

exeot Star	 walkrn 	downa hevtrehelookrn  f) {aediscrepance
		f) {
	re vi7{ 0i++ ) alical+ ) blvalue = c
	efell ) ap[i] !
= bp[i] fn.
[ [ null ? siblmoddfirsalap[i], bp[i] fl
			}
		}

exeot Wheinae		some"" ); u		 hevtrehesoEdo eisiblmodilfirs
[ null ? ii==,
at ?
ex		siblmoddfirsala,jbp[i], -1"es:
ex		siblmoddfirsalap[i], b, 1 er
	};

ot AhwayonassElei} espreschc u ecdu1 );hats  {
nLoa ioMs Th
ot pjec	} em(eo	ourtlvmparis st fer ) { (ann ieGoog4.7Chrome).
[0, re.xLoa( nLoaOrdec er
uas HriDu1 );hatu
 ! riDu1 );hat;

ot DntEleme nLoa	dise
		ed)
	rn 	du1 );hats
Sizz4..uniqueSort 	0) {
					rnus lisn)n.
[re vue )a
[ i7{ 1i

ex riDu1 );hat 
	uas HriDu1 );hat;
/nus lis.xLoa( nLoaOrdec er

[ll )  riDu1 );hat fn.
[ f) {
	i+(ue )  tn's lis[i))value = c
	efell ) ue )r	&& n's lis[ ii-o1ua fn.
[ [ nus lis.xpce);( i--, 1 er
			}
		}
	}

	null ? ars lisv
};

Sizz4..erract	0) {
					rmsdies 
	 arow pct(Errac		"Syk axaerrac,munrecognalud uxpr, imon: " +	msdie;
s};

 fer ) { s	kenalu(v {;
		or,spanseOnce )n.
[re vma fi F,vm	xml,	s	ken] )ng" ,vsoFar,sgroups,lpreFiltersa
[ v] ||d
=ms	kenCh ||[ expto od][ x{;
		oru]r

[ll ) v] ||d
fn.
[ null ? panseOnce ?
0r: v] ||d.xce);( 0 )l
	}
s
	nLFar {;nt;
		or;
	groups 
 ca;
	preFilterst{;Expr.preFilterl

	s ilum(+nLFar fn.

[ ot dvmma(e
		fto firun
[ ll ) !ma fi Fu||0(m	xmln=0r nmma.
recjQsLFar f)) {

			peof m	xmle in
				nLFar {;nLFar.xce);( ma fi[re.{
				 )l
			}
			groups.					}s	ken] 
 ca .!
		}

		ma fi Fu
 flist 

[ ot dvmbria	ors
		peof (m	xmln=0r nmbria	ors.
recjQsLFar f)) {

			s	ken].					}ma fi Fu
 pct(Token( maxml.x	}
			 ) )l
			nLFar {;nLFar.xce);( ma fiod.			firu v

exe	ot Casr } scinaahe/ cmbria	ors eo	np

	
			ma fi Fwtion"= ma fi[re., "" );
	r	rim, " " .!
		}

		eciFilters
[ f) {
	tg" "inlExpr. ilter) {

			peof (m	xmln=0ma fiExpr[	tion"].
recjQsLFar f))th (!preFilters[	tion"]7||
		 !ot Tprolastutwteth,
		deera theethe(lventmp, xml) f) {plisCvmpae
		 [(m	xmln=0preFilters[	tion"](vm	xml,	entElemea	,

	//))ufn.

[ ]	s	ken].					}ma fi Fu
 pct(Token( maxml.x	}
			 ) )l
				nLFar {;nLFar.xce);( ma fiod.			firu v
				ma fi Fwtion"= tisWv
				ma fi Fwma fi	s  (maxml;
			}
		}

exell ) !ma fi Fufn.
/[/break;
		}
	}

	ot Re
 */osectl		firuori} esinvalid
stn, i
	ot ll we'thej sstpans	di
[ot Orun wise,  arow anserract) { *
 */}s	ken]
	null ? panseOnce ?
		nLFar.			firu:
		nLFar ?
ex		Sizz4..errac		x{;
		oru.n:
exe	ot Ca ||B hevt	ken]
		ttokenCh ||(v {;
		or,sgroups ).xce);( 0 )l
}

 fer ) { adddvmbria	or( ma fior,slvmbria	or,	uas  )n.
[re vdir =  cmbria	or.dira
[ vfirsNonEmatches 
	uas  trivvmbria	or.dir)=& t"paristN	} "i
[ enneN
			 tenne++;

	null ? vvmbria	or.fto fi?
[ ot dfirsscga	Q	pd losesr afcus	or/r cccamodieoLoit 
[ f key, value ),	lventmp, xmli)em
		 s ilum(+(-1 ]i
see )[vdir ])) {

			[peof vfirsNonEmatches  !=-1 ].erCa.isWi==,
1" )te
[ /e/null ? ma fi r	iue ),	lventmp, xmli) 
		 !}
[ [}
		}f:

[ ot dfirsscga	Q	pdcks afcus	or/r cccamodieoLoit s
[ f key, value ),	lventmp, xmli)em
		 ot Whee gh,  {
7arbitraryQ scre { XMLtn	} samsteentytennh, benefitn			emdir v] |	di
[ =peof !xmli)em
		[ re vth ||a
[ /		dirkeyd= eirruvsn+0"t" + enneN
			+0"t"a
[ /		v] ||dkeyd= eirkeyd+vv] ||druvs 
		 !s ilum(+(-1 ]i
see )[vdir ])) {

			[[peof vfirsNonEmatches  !=-1 ].erCa.isWi==,
1" {

			[	/ {
		(th ||B
 ee )[vexpto od] B

=  ] ||dkeydes 
		 !=tenull ? -1 ]w izset;
[ [  !}fire(  {
		 "objeclh ||B
& t"sturn  itrivh ||.irr, el(eirkey)t
=,
0res 
		 !		 peof -1 ]w izset"es 
		 !=te/null ? ee );
////	te}
		 !=t} ire(  
							ee )[vexpto od] =  ] ||dkey;
		 !		 peof ma fi r	iue ),	lventmp, xmli)"es 
		 !=te/-1 ]w izset"=  ; li
			[	te/null ? ee );
////	te}
		 !=t/-1 ]w izset"= flist 
		 !=t}
					t
				t
[ [} ire(  
				s ilum(+(-1 ]i
see )[vdir ])) {

			[[peof vfirsNonEmatches  !=-1 ].erCa.isWi==,
1" {

			[	/ {
		ma fi r	iue ),	lventmp, xmli)"es 
		 !=tenull ? ee );
////	t}
					t
				t
[ [}
		}l
}

 fer ) { eoLoit Ma fi r	ima fi rowfn.
/null ? ma fi ro)			firu>s1"?
[ f key, value ),	lventmp, xmli)em
		 re vi7{ ma fi ro)			fir;
		 s ilum(++--) {

			[peof !ma fi ro[i)	iue ),	lventmp, xmli)"es 
		 !=null ? flist 
		 !}
[ [}
			null ?  ; li
		}n:
exema fi ro[0]l
}

 fer ) { 		}
;nsm(tunma fi F,vm	p,h,ilter,	lventmp, xmli)em
	re vue )a
[ pctUnma fi Fu
 []a
[ i7{ 0f
		lent{;unma fi F)			fir,
exema	ptc7{ map ! tpromi

exf) {
	i++ ) {
	value = c
	ef {
		(ue )  tunma fi Fdi))  {

			peof ! ilter) !=filter	iue ),	lventmp, xmli)"es 
		 !pctUnma fi F.					}ue )y.!
			[ {
		ma	ptc7es 
		 !=ma	.					}i )l
				t
[ [}
		}
	}

	null ? pctUnma fi Fl
}

 fer ) { setMa fi r	ipreFilter,v {;
		or,sma fior,spostFilter,vpostFindec,vpostS{;
		or fn.
[ll ) postFiltertcal!postFilter[ expto od] )em
		postFiltert= setMa fi r	ipostFiltert.!
	}
s[peof postFindectcal!postFindec[ expto od] )em
		postFindert= setMa fi r	ipostFindec,vpostS{;
		or f!
	}
s[null ? markrned.prot) {
					ix{sFamars lis,elventmp, xmli)em
		ot Posi ) {li	x{;
		ors eguly eo	netd*
oLoit oamsteie/		/invalid
eo	follow } em( arg n'atiive0nnes
		peof netd*calpostFindertfn.
[ 	null ?v
		}

exere vi,	ue )ampostFilterIna
[ /preMa		=:[]a
[ /postMa		=:[]a
[ /prest, imodi& nus lis.			fir,
e
		 ot Geioini )li	ue )	deer			emnetd*actlventmp
	t/-1 ]s 
 x{sF	 !=multipmadventmps		x{;
		oru||0"*",elventmp.erCa.isWi? [	lventmpd]u:	lventmp, [],ex{sF e,

			ot Prefilterteo	getsma fioriinpu
amprescr	rn 	a map f) {s{sF-nus lisnsyncaroniza// s
exe	ma fiorInn=0preFilter)th ( x{sF	 !=!x{;
		oru.n?
[ /			}
;nsm(t-1 ]sampreM	p,hpreFilter,vlventmp, xmli)e:
		 !-1 ]sa

			ma fiorOu
	=:ma fiori?
		 !ot Il we haviac postFindec,vorufiltere		s{sFamed pon-x{sF	postFiltert) {prest, imodiars lis,
		 !postFindert||0(ax{sF	?0preFilter):{prest, imodi||0postFiltert.i?

		 !=ot ...irtermcamhat pron, imodi	s(u n, iary
		 !=[]f:

[  !=ot ...orun wiseluse[nus lisndir
		ly
		 !=nus lisn:
				ma fi rInv

[ ot F d:aprimaryQma fi	s
		peof ma fiorifn.
[ 	ma fi r	ima fi rIna ma fiorOu
,	lventmp, xmli) 
		}

		eciAguly postFilter
		peof postFiltert.i{
[ /postFilterInn
 lve
;nsm(tma fiorOu
,	postMa		)l
			postFilter(mpostFilterIna [],elventmp, xmli) 

			ot Un-m	xmlnfail	disue )	deerbyl.ovmodisecm  lis atema fi rIn
			pn=0postFilterIn)			fir;
		 s ilum(++--) {

			[peof (ue )  tpostFilterIndi))  {

			[	ma fiorOu
[	postMa	[i] ] 
 !(ma fi	rInd	postMa	[i] ] 
 -1 ])!
			[t
[ [}
		}

		eciKeepax{sF	e
		eds lisnsyncaronizca
exepeof netd*fn.
[ [ot IgnunctpostFindertbecause[jtee gh, cost, i( arg s ca
exe	pn=0preFilter)th ma fiorOu
)			fir;
		 s ilum(++--) {

			[peof (ue )  tma fiorOu
[i))  {

			[	x{sF[ preM	p[i] ] 
 !(n's lis[ preM	p[i] ] 
 -1 ])!
			[t
[ [}
		} ire(  
			ma fiorOu
	=:lve
;nsm(
				ma fi rOu
	=&& n's lisu?
		 !=ma fiorOu
)xpce);( prest, imod, ma fiorOu
)			firi)e:
		 !=ma fiorOu

		 )!
			peof postFindectes 
		 !	ostFindec(mprom,dars lis,ema fiorOu
,	xmli) 
		 } ire(  
								.rguly(0ars lis,ema fi rOu
	er
			}
		}
	})l
}

 fer ) { ma fi rF		eTokens	}s	ken] )em
	re vvfirsCventmp, ma fior,sjf
		lent{;s	ken].			fir,
exelead	diR'atiive0{;Expr.n'atiive[;s	ken][re.tion"]a
[ impce)itR'atiive0{;lead	diR'atiive0||0Expr.n'atiive["t"]a
[ i7{ lead	diR'atiive0? 1r: 0,

		ot Tprofpunda ) {li	ma fiorien]uues( and ue )	deerethere] |tacks			ems	p-levelelventmp(s)
exema fidventmpd= adddvmbria	or( f key, value )ufn.
[ [null ? -1 ] 	&& vfirsCventmp 
		}, impce)itR'atiivea	,

	//,
exema fiAnydventmpd= adddvmbria	or( f key, value )ufn.
[ [null ? irr, el :
				vfirsCventmp, ue )ufn> -1v
		}, impce)itR'atiivea	,

	//,
exema fierst{;[ f key, value ),	lventmp, xmli)em
		 null ? (c!lead	diR'atiive0th ( xmli||	lventmpd!
= outermostdventmpd)  {||0(
				(vfirsCventmp 
 lventmp).erCa.isWi?
		 !=ma fiCventmpalue ),	lventmp, xmli)e:
		 !=ma fiAnydventmp	iue ),	lventmp, xmli)"ei
		}n]i

exf) {
	i++ ) {
	value = c
	ef {
		(.	xmler = Expr.n'atiive[;s	ken][ie.tion"])ifn.
[ 	ma fi rst{;[ adddvmbria	or( eoLoit Ma fi r	ima fi rowf, ma fiorifna;
		} ire(  
			ot Tprolve;hatia	td*v	r eseethe(lventmp, xml) f) {plisCvmpae
		 .	xmler = Expr.filter[ s	ken][ie.tion"].rguly(0prom,ds	ken][ie.ma fi	s e 

			ot Re
 */o#id
	li	up { seern 	a posi ) {li ma fior
			peof .	xmler[ expto od] es 
		 !ot F d:aent ntmpdn'atiive0nke a	or (ll any) f) {proke  handl	di
[ =	j ep++i!
			[f) {
	i+j ) {
	vajue = c
	efe	!peof Expr.n'atiive[;s	ken][je.tion"]"es 
		 !=tbreak;
		 !=t
				t
[ [	rull ? st Ma fi r	
	efe	!pu>s1"th -1 ]it Ma fi r	ima fi rowf,
	efe	!pu>s1"th s	ken].xce);( 0,
ii-o1u).join("" 
, "" );
	r	rim, "$1" e,
		 !=ma fior,
	efe	!pu<+j th ma fiorF		eTokens	}s	ken].xce);( i,	ji)"e,
	efe	!j ) {
	 th ma fiorF		eTokens	}(s	ken] 
 s	ken].xce);( j f)) ,
	efe	!j ) {
	 th s	ken].join("" 
	efe	)l
			}
			ma fi ro)					}ma fi ri) 
		}
	}

	null ? -1 ]it Ma fi r	ima fi rowfl
}

 fer ) { ma fi rF		eGroupMa fi rs( eoLoit Ma fi rs,ex{ Ma fi rs )em
	re vbySet"= x{ Ma fi rs)			firu>sA,
	efbyEmatcher= eoLoit Ma fi rs)			firu>sA,
	efsuke M	xmler = ) {
					ix{sFamlventmp, xml,dars lis,eexpto dventmpd) m
		 re vue ),	j, ma fior,
	efe	x{ Ma fi Fu
 []a
[ 		ma fi FCpunt7{ 0f
		[ i7{ "0"a
[ /	unma fi Fu
 netd*cal[]a
[ 		outermost =eexpto dventmpd! tprom,
[ /			}ntmpBlisup = outermostdventmp,
		 !ot We=mu	pdckwayonhaviaeirun tnetd*
oLoit o*actlventmp
	t//-1 ]s 
 x{sF	 !=byEmatchercalExpr.find["TAG"](0"*",eexpto dventmpdtrivventmpwparistN	} u||	lventmpd),
		 !ot Nessed ma fi row		oul		use[pon-irtegeroeirruvs
		 !eirruvsUnique 
 (eirruvsn+
 lventmpBlisup ={	nt.do? 1r: Ma h.Er;

exe	 {
		outermost es 
		 !outermostdventmpd=	lventmpd!
= dntEleme redcventmp 
				v] ||druvsn= suke M	xmler.emi
			}

	!	eciAdd*
oLoit o*pjec	disue )	deMa fi rs dir
		ly atears lis
	!	f) {
	i+(ue )  t-1 ]s[i)) ! tpromialue = c
	efe	peof byEmatchercalue )ufn.
[ [ 	f) {
	j7{ 0i+(.	xmler = ue )	deMa fi rs[j].!ajue = c
	efe	!/ {
		ma fi r	iue ),	lventmp, xmli)"es 
		 !=tenus lis.					}ue )y.!
			[ //break;
		 !=t}
					t
					 {
		outermost es 
		 ! !eirruvsd= eirruvsUnique;
		 !=tv] ||druvsn= ++suke M	xmler.emi
			!=t
				t

		 !ot Trlis unma fi Fuue )	deer	) {s{tufilters
	efe	peof bySet"es 
		 !=ot Tpry	 ihe haviagoner arough cks possiblesma fi ro
					 {
		(ue )  t!ma fi rrcalue ))"es 
		 !=tma fi FCpunt--i
			!=t

		 !=ot Lqueryrea hevthraedf) {everereoLoit amma fi	dmed poe
		 !=ll ) netd*fn.
[ [ /	unma fi F.					}ue )y.!
			[ t
				t
[ [}

	!	eciAguly s{tufilters ateunma fi Fuue )	dee
			ma fi FCpunt7+
 i!
			peof bySet"cal+ !
= ma fi FCpunt7fn.
[ [ f) {
	j7{ 0i+(.	xmler = x{ Ma fi rs[j].!ajue = c
	efe	!ma fi r	iunma fi F,vx{ Ma fi F,	lventmp, xmli) 
		 !}

	efe	peof netd*fn.
[ [ /ot ReirtegratlDeoLoit  ma fi	s ateelimria	eaent ntif factnLoa	di
		 !=ll ) ma fi FCpunt7>
0res 
		 !		s ilum(++--) {

			[	/	ieof !(unma fi Fdi)u||	x{ Ma fi Fdi))  {

			[	/		x{ Ma fi Fdi)  tpop :
				nus lisn);
[ [  te}
		 !=t}
					t

		 !=ot Discarf irr,  "" );holdectv	r eseeo	getsveueractuli ma fioo
					x{ Ma fi Fu
 lve
;nsm(tx{ Ma fi Fur!
			[}

				ot Add*ma fi	s atears lis
	!	!				.rguly(0ars lis,ex{ Ma fi Fur!

				ot Stifl, i
se  ma fi	s succecamodimultipma successful ma fi row	tipula	eanLoa	di
		 ! {
		outermost callo{sFucalx{ Ma fi F)			firu>sA &&
[ ]		) ma fi FCpunt7+ x{ Ma fi rs)			firu)u>s1"es 

[ ]		Sizz4..uniqueSort		nus lisn);
[ [ t
[ [}

	!	eciOverridiamanipula	) { of globalerbylnessed ma fi ro
exe	 {
		outermost es 
		 !eirruvsd= eirruvsUnique;
		 !outermostdventmpd=	lventmpBlisupi
			}

	!	null ? unma fi Fl
		};

	suke M	xmler.em =: i
[null ? bySet"?
exemarkrned.prot suke M	xmleri)e:
		suke M	xmlerl
}

 cmpilu {;Sizz4.. cmpilu {;) {
					ix{;
		or,sgroup /* Irter{li by DOnce */ )em
	re vi,
	efs{ Ma fi rs 
 []a
[ ue )	deMa fi rs 
 []a
[ v] ||d
=m cmpilurCh ||[ expto od][ x{;
		oru]r

[ll ) !v] ||d
fn.
[ ot GeneratlDa  fer ) { of recursive  fer ) {er and ltg b Duce		to cfirsse] |ieoLoit 
[ ll ) !group es 
		 group = s	kenalu(v {;
		ori) 
		}
	 i7{ group)			fir;
		s ilum(++--) {

			v] ||d
=mma fiorF		eTokens	}group[i] fl
			ll ) v] ||d[ expto od] es 
		 !x{ Ma fi rs)					}v] ||d
f 
		 } ire(  
				eoLoit Ma fi rs)					}v] ||d
f 
		 }
		}

[ ot Ca ||B hev cmpilud f			// s
exev] ||d
=m cmpilurCh ||	ix{;
		or,sma fi rF		eGroupMa fi rs( eoLoit Ma fi rs,ex{ Ma fi rs )ef!
	}
s[null ? v] ||d;
s};

 fer ) { multipmadventmps		x{;
		or,	lventmps, ars lis,ex{sF )em
	re vi7{ 0f
		lent{;lventmps)			fir;
	f) {
	i++ ) {
	value = c
	efSizz4.		 {;
		or,slventmps[i], ars lis,ex{sF )!
	}
s[null ? ars lisv
}

 fer ) { se;
		jQst;
		or,slventmp, ars lis,ex{sFamxml .em
	re vi,	s	ken] )n	ken )ng" ,vfind,
exema fi = s	kenalu(v {;
		ori),
exej epma fi.{
				v

exll ) !netd*fn.
[ ot Try atemriimrze0nke a	/ snn ri} etheisoveueronergroup
[ ll ) ma fi.{
				i==,
1" {


	!	eciTaklDa 		ortcut e
		 {tB hev centmpd ri} e rootss{;
		oriisoan ID
			s	ken] 
 ma fi[re;=	ma fi[re.xce);( 0 fl
			ll ) s	ken].			firu>s20th (s	ken 
 s	ken][re)wtion"=& t"ID""th
[ [ 			}ntmp.nrCa.isWi==,
9i&& !xmlith
[ [ 	Expr.n'atiive[;s	ken][1e.tion"]"es 

[ /			}ntmp = Expr.find["ID"]) s	ken.ma fi	s[re., "" );
	r lisslash,0"ble,	lventmp, xmli)[0]l
[	/	ieof !lventmpd)em
		 [[null ? ars lisv
			[}

				s{;
		ori{;nt;
		or.xce);( s	ken].x	}
			.{
				 )l
			}

	!	eciFe fi aex{sF s{tuf) { ight-to-lef  ma fi	di
		 f) {
	i7{ ma fiExpr["POS"]. {
			x{;
		oru.n? -1r: s	ken].			firu- 1i++ >,
0;u+--) {

			[s	ken 
 s	ken][i]!

				ot Abort il we hi		a vvmbria	or
[	/	ieof Expr.n'atiive[;(tisWi
ss	ken.tisW)i]"es 
		 !=break;
		 !}
				 {
		(find = Expr.find[ tion"])ifn.
[ 			ot Starml,	uxpto modilventmpdf) {lead	dissiblmodilnmbria	ors
					 {
		(x{sF =vfind	
	efe	!	s	ken.ma fi	s[re., "" );
	r lisslash,0"ble,
	efe	!	rsiblmod. {
			s	ken][re.tion")dtrivventmpwparistN	} u||	lventmp,
	efe	!	xml
	efe	!))ufn.

[ ]	 !ot Il x{sF 		/u	sel;ed po}s	ken] re.a	Q,Eferlansnull ? -arly
[ e	!	s	kens.xpce);( i, 1 er
						s{;
		ori{;nt F)			firuth s	ken].join("" r
						ll ) !ne;
		oru.n.
[ =	!	!				.rguly(0ars lis,exce); :
				x{sFam0 ) )l
				 [[null ? ars lisv
			[		t

		 !=tbreak;
		 !=t
				t
[ [}
		}
	}

	ot dvmpilu e
		
recutlDa  ilterrn  f			// s
exot Providia`.	xml` atetvoidunul	kenala	) { il we mod			if } el#{;
		oruabove
[ cmpilujQst;
		or, m	xmle (
	efs{ed,
exelventmp,
	efxml,
	efars lis,
		rsiblmod. {
			ne;
		oru.
	)l
	null ? ars lisv
}

ll ) dntEleme.queryS{;
		orA.do {

[t) {
					.n.
[ re vdisconn
		tdMa fi,
	efeoldS{;
		i{;nt;
		,
	!	nuscasWi
s/'|\\/g,
	!	nat [ bu
eQuoio] 
 /\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,

	!	eciqSa(:eetL() artLoas flistes rea,

	/(Chrome 21fa
[ /ry AvtentLoaleesr woul		nuquinc attemus tc	} u(woul		i{clu o dntEleme ready)
[ [rbuggyQSA 
 [":eetL("]a

[ /ry ma fi	sS{;
		or(:eetL() artLoas flistes rea,

	/(Chrome 21fa
[ /ry ma fi	sS{;
		or(:ad.pve) artLoas flistes rea,

	/(IE9/Oke a 11.5)
[ /ry AvtentLoaleesr woul		nuquinc attemus tc	} u(woul		i{clu o dntEleme ready)
[ [ot j sstskip ma fi	sS{;
		ordf) {:ad.pve
[ [rbuggyMa fi	s {;[ ":ad.pve",0":eetL(""]a
[ 	ma fi	s {;entEe ).ma fi	sS{;
		ord||
		 !entEe ).mozMa fi	sS{;
		ord||
		 !entEe ).webkitMa fi	sS{;
		ord||
		 !entEe ).oMa fi	sS{;
		ord||
		 !entEe ).msMa fi	sS{;
		or;

[ ot Build QSA reg, 
[ ot Reg, tn ;atlgyltdopsed 			emDiego Perini
[ tml rtt) {
					idiv*fn.
[ [ot S{;
		iii
se  atee	sel;sturn e { purposu
[ =ot T			/		/ateeesr IE'sutrea	m		v )f uotsuxpce)	ly
		 ot neta	dise boole=ns venthe at [ bu
ea
[ /ry sihc ui onpreschc u		oul		bheinough
[ /ry .java.nbug].jquery. cm/ticket/12359
[ /div.innerHTML7{ "<nt;
		><op// s 	{;
		td=''></op// s></nt;
		>" 

			ot IE8u- Some boole=nsat [ bu
es athen
tutrea	ets vrr
		ly
		 ll ) !div.queryS{;
		orA.d("[	{;
		td]"	.{
				 )n.
[ [ nbuggyQSA)					}"\\[" +	whit np

	u+ "*(?:lfirsme|dirn() d|ismap|multipma|readveue|	{;
		td|v	r e)" )l
			}

	!	eciWebkit/Oke a - :lfirsme 		oul		null ?  {;
		tdtop// s ue )	dee
			ot .java.nwww.w3		if TR/2011/REC-css3-x{;
		ors-20110929/#vhirsme
			ot IE8u arowsserract ethe( odn
tupu
	nesrs afse n	aisovee)
		 ll ) !div.queryS{;
		orA.d(":lfirsme"	.{
				 )n.
[ [ nbuggyQSA)					":lfirsme"	 
		 }
		}r!

		tml rtt) {
					idiv*fn.

			ot Oke a 10-12/IE9 - ^= $= *= e
		
	sel;v	r es
[ [ot S	oul		notss{;
		 anyti	di
		 div.innerHTML7{ "<p	nesr=''></p>" 
		 ll ) div.queryS{;
		orA.d("[nesr^='']"	.{
				 )n.
[ [ nbuggyQSA)					}"[*^$]=" +	whit np

	u+ "*(?:\"\"|'')" )l
			}

	!	eciFF 3.5 - :enn() d/:dirn() dte
		hiddes ue )	dee (hiddes ue )	dee ethestihe enn() d)
			ot IE8u arowsserract ethe( odn
tupu
	nesrs afse n	aisovee)
		 div.innerHTML7{ "<inpu
	ng" ='hiddes'/>" 
		 ll ) !div.queryS{;
		orA.d(":enn() d"	.{
				 )n.
[ [ nbuggyQSA)					":enn() d",0":dirn() d"	 
		 }
		}r!

		ot rbuggyQSA ckwayoncck a	Q	 :eetL(amstepo}ntif factatl		firucfirs
[ nbuggyQSA 
 /* rbuggyQSA)			firuth */spct(RegExp( rbuggyQSA)join("|"e r;

exes{;
		i{;) {
					ix{;
		or,slventmp, ars lis,ex{sFamxml .em
			ot Once use[queryS{;
		orA.dos rean
tu ilterrn a
[ /ry s rea,			/		/n
tuxml,
	ef	ot c
		s rean
 QSA bug] eguly
		 ll ) !o{sFucal!xmlith (!nbuggyQSA  !=!rbuggyQSA) {
			ne;
		oru.)ifn.
[ 		re vgroups,li,
	efe	!old =  ; l,
	efe	!npdu=dexpto o,
	efe	!newdventmpd=	lventmp,
	efe	!newS{;
		ord
 lventmpwnrCa.isWi==,
9i&& s{;
		or;

[ !	eciqSA workstn ;angeueron Ematche-rootsFuquerioo
				ot Whee g work/arpunds, ierbyl#id
		y	dise
dex ;a IDron } e root
				ot c
		sork	disups			ems ethe(Tpanks ateAndrct(Dup {t*eed  hevtechnique)
				ot IE 8 ioMs Th work/ { obj
		iue )	dee
				ll ) vventmpwnrCa.isWi==,
1dtrivventmpwerCaN
		.toL namCasttr !&& (obj
		"les 
		 !=groups 
 s	kenalu(v {;
		ori) 

					 {
		(old = lventmpwgeeAt [ bu
e("id"))  {

			[	/npdu=dold., "" );
	ruscasW,}"\\$&"y.!
			[ t ire(  
						lventmpwseeAt [ bu
e( "id", npdu.!
			[ t
				/npdu=d"[id='" +	npdu+ "'] " 

					 7{ groupo)			fir;
		 		s ilum(++--) {

			[	/groupodi)  tnpdu+ groupodi).join("" r
					}
	efe	!newdventmpd=	rsiblmod. {
			ne;
		oru.dtrivventmpwparistN	} u||	lventmp;
	efe	!newS{;
		ord
 groupo)join(",") 
		 !}

	efe	peof newS{;
		ord {

			[	try{

			[	/				.rguly(0ars lis,exce); :
				newdventmp.queryS{;
		orA.d(
				 [[newS{;
		or
				 [)am0 ) )l
				 [null ? ars lisv
			[	}ee  fi(qsaErrac {

			[	}vfin	rlync
	efe	!/ {
		!old .n.
[ =	!	!vventmpwed)
	eAt [ bu
e("id");
		 !=t}
					t
				t
[ [}

	!	r'll ? sldS{;
			ix{;
		or,slventmp, ars lis,ex{sFamxml .l
		};

	=ll ) ma fi s es 
		 tml rtt) {
					idiv*fn.
[ [ ot dfirsseo	net  {
it's	possiblestoEdo ma fi	sS{;
		or
[ [ ot  { avdisconn
		tdv{	} "(IE 9)
				disconn
		tdMa fi
=mma fios :
				div,}"div"ur!

				ot T			/		oul		fail( arg e
dexcep// s
exe	 ot Gecko ioMs uotsurrac,mr'll ?s fliste	Q		ead
exe	 try{

			[	ma fios :
				div,}"[nesr!='']:sizz4."y.!
			[ rbuggyMa fi	s)					}"!=",lpseudos ) 
		 !}ee  fiof -*fn.t
[ [}e 

			ot rbuggyMa fi	s ckwayoncck a	Q	 :ad.pve c
		:eetL(amstepo}ntif factatl		firucfirs
[ [rbuggyMa fi	s {;/* rbuggyMa fi	s)			firuth */spct(RegExp( rbuggyMa fi	s)join("|"e r;

exe	Sizz4..ma fi	sS{;
		ord= f key, value ),	uxpr*fn.
[ [ ot MaklD]uuer and at [ bu
e	x{;
		ors ere quoiod
				uxpr*=dexpr
, "" );
	rat [ bu
eQuoio],}"='$1']"ur!

				ot rbuggyMa fi	s ckwayoncck a	Q	 :ad.pveamstepo}ntif factansexi		ehc ucfirs
[ [/ {
		!isXMLalue )ufncal!rbuggyMa fi	s) {
			-xpr*fnth (!nbuggyQSA  !=!rbuggyQSA) {
			-xpr*f)d {

			[	try{

			[	/re vn't
=mma fios :
				ue ),	uxpr*f;

[ ]	 !ot IE 9's	ma fi	sS{;
		ordr'll ?s flisteonvdisconn
		tdv{	} s
	efe	!/ {
		n't
 !=eisconn
		tdMa fi
||
		 !=	 !ot AsEfeom,ddisconn
		tdv{	} s ethesaid
eo	b "inla dntEleme
		 !=	 !ot fragm		v  ieIE 9
		 !=	 !ue ).dntEleme redue ).dntElemewnrCa.isWi!&& 11"es 
		 !=tenull ? arg 
		 !=t}
					tee  fi(efn.t
[ [[}

				r'll ? Sizz4.		uxpramprom,dprom,d[lue )u]uf)			firu>sA;
		[}v
		}
	})(fl
}

ot Der ccaiod
Expr.pseudos["nth"] {;Expr.pseudos["eq"]!

ot Back-cvmpae
 fer ) { setFilters(fn.t
Expr.filters 
 x{
Filtern.prototisWi
sExpr.pseudos;
Expr. {
Filternn
 pct(setFilters(f!

ot Overridiasizz4. at [ bu
e	r'lriov	r
Sizz4..at [n
 jQuery.at [;
jQuery.find = Sizz4.;
jQuery.uxpr*=dSizz4..x{;
		ors;
jQuery.uxpr[":"] {;jQuery.uxpr.pseudos;
jQuery.unique 
 Sizz4..uniqueSort;
jQuery.ntmpd=	Sizz4..g'	Ttmp;
jQuery.isXMLDoc	
 Sizz4..isXML;
jQuery.cck a	Q	 {;Sizz4.. ck a	Q	;


})(( ao ow*f;
re vnuntih {;/Untih$/,
	rparistsprev {;/^(?:parists|prev(?:Untih|A.d))/,
	isSimpcWi
s/^.[^:#\[\.,]*$/,
	rntifsdventmpd=	jQuery.uxpr.ma fi.ntifsdventmp,exot ] 	hods gua;antee		to produclDa unique se  s reastar	rn 				ema unique se 
	gua;antee	Unique 
 {
[ vfildrcn:  ; l,
	!vventsts:  ; l,
	!ntmp:  ; l,
	!prev:  ; l
	};

jQuery.fn.uxntsd({
	f nd:;) {
					ix{;
		or"es 
xere vi,	l, 			fir,in,mr,mr'l,
	!es{;f	=:, ie;

=tpeof  "obofix{;
		or"!& t"sturn  ies 
xe	r'll ? jQuery	ix{;
		or"e.filtert) {
					.n.
				f) {
	i7{ 0, 	i{;nt;f)			fir;++ ) {value = c
					 {
		jQuery.cck a	Q		ix{;f[ ii],s, ier) = c
						null ?  ; li
					t
				t
			}e 
		}

=tn't
=m, ie)				Starsal"",i"f nd",v {;
		ori) 

=tf) {
	i7{ 0, 	i{;, ie)			fir;++ ) {value = c
			{
				i=mr'l)			fir;
			jQuery.find	ix{;
		or,s, ie[i], arti) 

=t	 {
		i7>
0res 
[ [ ot MaklD]uuer and } e rus lisnetheunique
				f) {
	n7{ le	fir;+n ) r'l)			fir; nue = c
					f) {
	r7{ 0i+r ) {
				v+rue = c
					/ {
		n't[r]	=&& n't[n] = c
					/tn't.xpce);(n--, 1);
					/tbreak;
		 !=t}
					t
				t
			}
		}

=tn'tl ? arg 
	},
ex ri: f			// st narget"es 
xere vi,
			nargetsd=	jQueryt narget,s, ier),
			{
	i{;,argets)			fir;

=tn'tl ? , ie)filtert) {
					.n.
			f) {
	i7{ 0i++ ) {
	value = c
[ [/ {
		jQuery.cck a	Q		i, ie,;,argets[i] fn= c
					null ?  ; li
				t
			}
		}) 
	},
exuot:;) {
					ix{;
		or"es 
xen'tl ? , ie)				Starsal aonow(, ie,;x{;
		or,sflist)am"nop",;x{;
		or) 
	},
exfilter:;) {
					ix{;
		or"es 
xen'tl ? , ie)				Starsal aonow(, ie,;x{;
		or,s ; l),i"f lter",v {;
		ori) 
	},
exis:;) {
					ix{;
		or"es 
xen'tl ? !!ne;
		oruth (
			n"obofix{;
		or"
& t"sturn  i?
				ot Ifa,			/		/a posi ) {li/n'atiive0x{;
		or,slfirss)cmb.rship  ea hevn'tl ?sF s{t
				ot ste$("p:fto f").is("p:last") wnnh, null ?  ; l f) {aedoc	 arg twte"p".
				rntifsdventmp. {
			x{;
		oru.n?
					jQuery	ix{;
		or,s, ie.lventmpd).irr, 	i, ie[re;)i>,
0r:
					jQuery)filtertix{;
		or,s, ieuf)			firu>sAr:
				, ie)filtertix{;
		or"e.			firu>sAr) 
	},
ex losesr:;) {
					ix{;
		ors,elventmp"es 
xere vcur,
			i7{ 0,
			{i{;, ie)			fir,
xe	r'l 
 []a
xe	posi=mrntifsdventmp. {
			x{;
		ors  {||0n"obofix{;
		ors"!& t"sturn  i?
				jQuery	ix{;
		ors,elventmp"||0n ie.lventmpd)r:
				0 

=tf) {
	;++ ) {value = c
			tura= , ie[i] 

=t	s ilum(+turatrivurwownerDntElemeatrivurB!
=  ventmpdtrivur.nrCa.isWi!&& 11"es 
[ [/ {
		posi?	pos.irr, 	vur)t> -1r: jQuery.find.ma fi	sS{;
		or	vur,v {;
		orsfn= c
					nul)					}vuri) 
			/tbreak;
		 !t
				tura= tur.paristN	} k
			}
		}

=tn'ti=mr'l)			firu>s1"? jQuery.unique( nueufn: arg 

xen'tl ? , ie)				Starsalr'l, " losesr",v {;
		orsr) 
	},
exot Determinei} esposi ) {	oftanseoLoit   arginexot } esma fi Fuse  oftue )	deeexirr, : f key, value )ufn.

xeot Nteth,
		de,mr'll ? irr,  insparist
=tpeof !ue )ufn.
			null ? 	i, ie[re;th s ie[rewparistN	} ufn? , ie)	revA.d(e.			firu: -1v
		}

=tot lrr,  ins {;
		or
=tpeof  "obofie1 ] 	&& "sturn  ies 
xe	r'll ? jQuery.irAhrae	i, ie[re,	jQueryt ue )ufn)v
		}

=tot Loca	eaent posi ) {	oftent } sir Fuue )	de
e	r'll ? jQuery.irAhrae	
			ot Ifai, nuceive	/a jQuery obj
		,lwith,io fieoLoit  ieuuce	
	 !ue ).jqueryn? ue )[re;:	ue ),	, ieuf 
	},
exadd:;) {
					ix{;
		or,elventmp"es 
xere vset"=  "obofix{;
		or"
& t"sturn  i?
				jQuery	ix{;
		or,slventmpd)r:
				jQuery.makeAhrae	ine;
		oruth nt;
		or.erCa.isWi? [	x{;
		oru];:	 {;
		ori),
		 tlld=	jQuery.merge	i, ie.g'	(),ex{ i) 

=tn'tl ? , ie)				StarsalisDisconn
		td(tx{ [re;)i||0isDisconn
		td(ttll[re;)i?
		 tlld:
			jQuery.unique( allufn)v
	},
exaddBack:;) {
					ix{;
		or"es 
xen'tl ? , ie)add(ix{;
		or"
&	nt.do?
			, ie)	revObj
		i: , ie)	revObj
		)filtertx{;
		or)
e	)l
	}
}) 

jQuery.fn.andS{;fd=	jQuery.fn.addBack 

ry Avpa	Q f.dyasimpcWicfirsseo	net  {
anseoLoit  isddisconn
		td
ot fr	ema dntEleme (		oul		bheimprovsFam a thefeasible).
 fer ) { isDisconn
		td(tn	} ufn.
	null ? !n	} u||	!n	} wparistN	} u||	n	} wparistN	} wnrCa.isWi==,
11v
}

 fer ) { siblmod	}vur,vdir fn.
	do {
[ vura= tur[vdir ]l
	} s ilum(+turatrivurwnrCa.isWi!&& 1i) 

=null ? vurv
}

jQuery.uach({
	parist: f key, value )ufn.
xere vparist = ue ).paristN	} k
		null ? panemeatripaneme.nrCa.isWi!&& 11"? panemea:tpromi
	},
	parists: f key, value )ufn.
xer'll ? jQuery.dir		ue ),	"paristN	} "n)v
	},
	paristsUntih: f key, value ),li, untih fn.
xer'll ? jQuery.dir		ue ),	"paristN	} ", untih fv
	},
	ntmp: f key, value )ufn.
xer'll ? siblmod	}ue ),	"ntmpSiblmod"n)v
	},
	prev: f key, value )ufn.
xer'll ? siblmod	}ue ),	"previousSiblmod"n)v
	},
	ntmpA.d: f key, value )ufn.
xer'll ? jQuery.dir		ue ),	"ntmpSiblmod"n)v
	},
	prevA.d: f key, value )ufn.
xer'll ? jQuery.dir		ue ),	"previousSiblmod"n)v
	},
	ntmpUntih: f key, value ),li, untih fn.
xer'll ? jQuery.dir		ue ),	"ntmpSiblmod", untih fv
	},
	prevUntih: f key, value ),li, untih fn.
xer'll ? jQuery.dir		ue ),	"previousSiblmod", untih fv
	},
	siblmods: f key, value )ufn.
xer'll ? jQuery.siblmod	}f -1 ]wparistN	} u||	{}"e.fio fChild, ue )ufv
	},
	vfildrcn: f key, value )ufn.
xer'll ? jQuery.siblmod	}-1 ]wfio fChildufv
	},
	vventsts: f key, value )ufn.
xer'll ? jQuery.erCaN
				ue ),	"ifr
		";)i?
		 -1 ]wvventstDntElemea !=-1 ].vventstWao ow.dntEleme :
			jQuery.merge	i[],e-1 ].vhildN	} sw)l
	}
}, f key, valn
		, fnufn.
xjQuery.fn[0n
		)]d= f key, valuntih,ix{;
		or"es 
xere vn't
=mjQuery.map	i, ie,;fn, untih fv

=tpeof !nuntih. {
			n
		)fn= c
			s{;
		ori{;untihv
		}

=tpeof ne;
		oruth  "obofix{;
		or"
& t"sturn  ies 
xe	r'ld=	jQuery.filtertix{;
		or,sarti) 
		}

=tn't
=m, ie)			firu>s1"cal!gua;antee	Unique[0n
		)]d? jQuery.unique( nueufn: arg 

xepeof   ie)			firu>s1"calrparistsprev. {
			n
		)fn= c
			n'ti=mr'l)reversttr;
		}

=tn'tl ? , ie)				Starsalr'l, n
		, core_xce); :
				th,
		deer))join(",")w)l
	};
}) 

jQuery.uxntsd({
	f lter:;) {
					iuxprame1 ]samuots= c
		peof nots= c
			uxpr*=d":not(" +	uxpr*+ ")";
		}

=tn'tl ? e1 ]s.{
				i==,
1"?
			jQuery.find.ma fi	sS{;
		or	e1 ]s[re,	uxpr)i? [	e1 ]s[reu];:	[]f:
			jQuery.find.ma fi	s(uxprame1 ]s)v
	},
exdir: f key, value ),ldira untih fn.
xere vma fi F 
 []a
xe	vura= ee )[vdir ] 

xes ilum(+turatrivurwnrCa.isWi!&& 9i&& (untih {={;undefinsF	 !=vurwnrCa.isWi!&& 1i||	!jQuery	ivuri).is( untih ffn= c
			peof tur.erCa.isWi==,
1" {

				ma fi F.					}vuri) 
			}
			tura= tur[dir];
		}
e/null ? ma fi dv
	},
exsiblmod: f key, valn,lue )ufn.
xere vn 
 [] 

=tf) {
	;+n;	n7{ n.ntmpSiblmodn= c
			peof nwnrCa.isWi==,
1dtrini!&& ue )ufn.
				r.					}ni) 
			}
		}

=tn'tl ? al
	}
}) 

ot ImpcWleme } esid sr	c	r f key, valitedf) {filtertc
		not
 fer ) {  aonow(*
oLoit oamqualifior,skeepafn.

xot Canh, pjec	nt.do) {undefinsF	eo	irr, el insFir fox 4
[ot S{  ate0seo	nkip sturn ecfirs
	qualifior7{ qualifior7||	0 

= {
		jQuery.isrned.prot qualifior7)ufn.
xer'll ? jQuery.grep(
oLoit oamf key, value ),liufn.
			re vn'tVst
=/!!qualifior :
				ue ),	i, ue )ufv
	=tn'tl ? argVst
=&& keep;
		}) 

!}fire(  {
		qualifior nrCa.isWifn.
xer'll ? jQuery.grep(
oLoit oamf key, value ),liufn.
			null ? 	ie1 ] 	&& qualifior7)u=&& keep;
		}) 

!}fire(  {
		 "obofiqualifior7{& t"sturn  ies 
xere vfiltere		= jQuery.grep(
oLoit oamf key, value )ufn.
			null ? -1 ].nrCa.isWi==,
1;
		}) 

!	 {
		isSimpcW. {
			qualifior7)ufn.
xeer'll ? jQuery.filtertqualifior,sfiltere	, !keepr;
		} ire(  
xeequalifior7{ jQuery.filtertiqualifior,sfiltere	i) 
		}
	}

=r'll ? jQuery.grep(
oLoit oamf key, value ),liufn.
		null ? 	ijQuery.irAhrae	iue ),lqualifior7)u>,
0res=&& keep;
	}) 
}
 fer ) { 	rea	eSafeFragm		v) dntElemeufn.
	re vlistd= erCaN
		s.xpcev) "|"i),
	safeFrag = dntEleme.	rea	eDntElemeFragm		v)) 

= {
		safeFrag.	rea	eEmatcheufn.
		s ilum(+list.{
				 )n.
			safeFrag.	rea	eEmatche	
				list.pop()
e		) 
		}
	}
er'll ? safeFragv
}

re v{rCaN
		s*=d"abbr|ar	rcle|aside|audio|bdi|canvas| scr| scrlist|details|figcap// s|figure|footsr|"i+
		"header|hgroup|mark|meter|nav|output|progr, i|ser ) {|summary|time|vidio",
	rinlmoejQuery = /ijQuery\d+="(?:nt.d|\d+)"/g,
	rlead	diWhit np

	u
s/^\s+/,
	rxhtmlTag = /<(?!aria|br|col|cmb.d|hr|img|inpu
|lmok|meta|param)(([\w:]+)[^>]*)\/>/gi,
	rtagN
			 t/<([\w:]+)/,
	rtbody = /<tbody/i,
	rhtml = /<|&#?\w+;/,
	rnoInnerhtml = /<(?:script|style|lmok)/i,
	rnoth ||B
 /<(?:script|obj
		|cmb.d|op// s|style)/i,
	rnoshimth ||B
 pct(RegExp("<(?:" +	nrCaN
		s*+ ")[\\s/>]",i"i"),
	rcfirsn() .isWi=;/^(?:cfirsbox|rad	o)$/,
	ot lfirsme="lfirsme"*actlfirsme
	rcfirse		= /cfirse	\s*(?:[^=]|=\s*.cfirse	.)/i,
	rscript.isWi=;/\/(java|ecma)script/i,
	rcle=nScriptu
s/^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,
	wrapMa		=:.
		op// s:	[ 1, "<nt;
		 multipma='multipma'>",i"</nt;
		>" ]a
xelegend:;[ 1, "<fioldset>",i"</fioldset>" ]a
xethead:;[ 1, "<tn() >",i"</tn() >" ]a
xetr:;[ 2, "<tn() ><tbody>",i"</tbody></tn() >" ]a
xetd:;[ 3, "<tn() ><tbody><tr>",i"</tr></tbody></tn() >" ]a
xecol:;[ 2, "<tn() ><tbody></tbody><colgroup>",i"</colgroup></tn() >" ]a
xearia:;[ 1, "<map>",i"</map>" ]a
xe_default:;[ 0,l"",i"" ]
	},
	safeFragm		va= trea	eSafeFragm		v) dntElemeuf,
	fragm		vDiv {;safeFragm		v.rguendChild( dntEleme.	rea	eEmatche	"div")w)l

wrapMa	.op/group = wrapMa	.op// s;
wrapMa	.tbody = wrapMa	.tfoot = wrapMa	.colgroup = wrapMa	.cap// s = wrapMa	.thead;
wrapMa	.th = wrapMa	.td 

ot IE6-8ee gh,  {rirlize lmok,ixcript,ixtyleamed any html5 (NoScosW)itags,
ot unl, i
wrapptc7inla div  arg pon-breakrn ecfaracternninlfro	v )f it.
ll ) !jQuery.sentLoa.htmlS{rirlize )n.
	wrapMa	._default {;[ 1, "X<div>",i"</div>" ] 
}

jQuery.fn.uxntsd({
	ttmp: f key, valv	r eifn.
xer'll ? jQuery.access	i, ie,;f key, valv	r eifn.
xeer'll ? v	r ei{={;undefinsF	?
				jQuery.ntmp	i, ier) :
				, ie)
	sel().rguend( 	i, ie[re;th s ie[rewownerDntElemea !=entElemeuf.	rea	eTtmpN	} alv	r eifn) 
		},dprom,dv	r e,ith,
		des)			firu)v
	},
exwrapA.d: f key, valhtml = c
		peof jQuery.isrned.prot html = fn.
xeer'll ? , ie)
ach(f key, vaifn.
				jQuery	, ie).wrapA.dt html :
			, ie,;i)i) 
			}r;
		}

=tpeof   ie[re;)i{
			ot Tpro
oLoit oseo	wrap  hevtarget"arpund
			re vwrap =	jQueryt html, s ie[rewownerDntElemea).eq(0f.	lone( ; l) 

=t	 {
		s ie[rewparistN	} ufn.
				wrap.irl rtB foref   ie[re;) 
			}

			wrap.map	) {
					.n.
				re vue )	=:, ie;

=t		s ilum(+-1 ]wfio fChilduredue ).fio fChild.erCa.isWi==,
1" {

					ee )  t-1 ].fio fChild;
		 !t

				null ? -1 ] 
			}r.rguend( , ieuf 
		}

=tn'tl ? , iev
	},
exwrapInner: f key, valhtml = c
		peof jQuery.isrned.prot html = fn.
xeer'll ? , ie)
ach(f key, vaifn.
				jQuery	, ie).wrapInnert html :
			, ie,;i)i) 
			}r;
		}

=tr'll ? , ie)
ach(f key, vafn.
			re vs{;fd=	jQuery( , ieufa
xe		vventstsi{;nt;f)vventsts() 

=t	 {
		vventsts.{
				 )n.
				vventsts.wrapA.dt htmli) 

=t	} ire(  
xeees{;f.rguend( htmli) 
			}
		}) 
	},
exwrap: f key, valhtml = c
		re visrned.pro7{ jQuery.isrned.prot html = 

=tn'tl ? , ie)
ach(f key, vaifn.
			jQuery( , ieuf.wrapA.dt isrned.pro7? html :
			, ie,;i)i: htmli) 
		}) 
	},
exunwrap: f key, vaes 
xen'tl ? , ie)	arist().
ach(f key, vafn.
			ll ) !jQuery.erCaN
				, ie,;"body" fn= c
				jQuery( , ieuf., "" );Wargf   ie)vhildN	} sw)l
			}
		}).end()v
	},
exaguend: f key, vaes 
xen'tl ? , ie)domManip(th,
		des,s ; lamf key, value )ufn.
			peof   ie)erCa.isWi==,
1"||0n ie.nrCa.isWi==,
11n= c
				, ie)aguendChild( ue )ufv
	=t}
		}) 
	},
exp, "end: f key, vaes 
xen'tl ? , ie)domManip(th,
		des,s ; lamf key, value )ufn.
			peof   ie)erCa.isWi==,
1"||0n ie.nrCa.isWi==,
11n= c
				, ie)irl rtB foref ue ),	, iewfio fChildufv
	=t}
		}) 
	},
exb fore: f key, vaes 
xe {
		!isDisconn
		td(t  ie[re;)ifn.
xeer'll ? , ie)domManip(th,
		des,sflistamf key, value )ufn.
				, ie)	aristN	} wirl rtB foref ue ),	, iei) 
			}r;
		}

=tpeof th,
		des)			firu)n.
			re vs{ld=	jQuery.cle=n		th,
		deer);
xeer'll ? , ie)				StarsaljQuery.merge	iset,s, ier),;"b fore",	, iew {;
		ori) 
		}
	},
exafter:;) {
					es 
xe {
		!isDisconn
		td(t  ie[re;)ifn.
xeer'll ? , ie)domManip(th,
		des,sflistamf key, value )ufn.
				, ie)	aristN	} wirl rtB foref ue ),	, ie.ntmpSiblmodn= 
			}r;
		}

=tpeof th,
		des)			firu)n.
			re vs{ld=	jQuery.cle=n		th,
		deer);
xeer'll ? , ie)				StarsaljQuery.merge	i, ie,;x{tr),;"after",	, iew {;
		ori) 
		}
	},
exot keepDscreier	) {irter{li usteonly-- odn
tuentEleme
er')
	e:;) {
					ix{;
		or,ekeepDscre= c
		re vue ),
			p7{ 0i

=tf) {
	;+(ue )	=:, ie[i)) ! tpromialue = c
			ll ) !x{;
		oru||0jQuery.filtertix{;
		or,s[lue )u]uf)			firues 
[ [/ {
		!keepDscreredue ).erCa.isWi==,
1" {

					jQuery.cle=nDscr(+-1 ]wgetEmatchesByTagN
		("*")i) 
					jQuery.cle=nDscr(+[lue )u]uf;
		 !t

				peof -1 ]wparistN	} ufn.
					-1 ]wparistN	} wed)
	eChild( ue )ufv
	=t	t
			}
		}

=tn'tl ? , iev
	},
ex
	sel:;) {
					es 
xere vue ),
			p7{ 0i

=tf) {
	;+(ue )	=:, ie[i)) ! tpromialue = c
			ot Re)
	eseoLoit  {	} s ed:aprevit  me)
ry{leaks
			peof -1 ]werCa.isWi==,
1" {

				jQuery.cle=nDscr(+-1 ]wgetEmatchesByTagN
		("*")i) 
			t

			ot Re)
	esany re.a	Qmodn{	} s
t		s ilum(+-1 ]wfio fChildu {

				-1 ]wed)
	eChild( ue )wfio fChildufv
	=t}
		}

=tn'tl ? , iev
	},
ex	lone:;) {
					i scrAndEv	des,sdeepDscrAndEv	desu {

		 scrAndEv	des = dscrAndEv	des ={	nt.do? fliste: dscrAndEv	desv
	=deepDscrAndEv	desu=sdeepDscrAndEv	desu={	nt.do? dscrAndEv	des :sdeepDscrAndEv	des 

=tn'tl ? , ie)map	i fer ) { (fn.
xeer'll ? jQuery.clone(i, ie,; scrAndEv	des,sdeepDscrAndEv	desu  
		}) 
	},
exhtml: f key, valv	r eifn.
xer'll ? jQuery.access	i, ie,;f key, valv	r eifn.
xeere vue )	=:, ie[re;||	{}a
xe		i7{ 0,
				{i{;, ie)			fir 

=t	 {
		v	r ei{={;undefinsF	fn.
				rull ? -1 ].nrCa.isWi==,
1n?
					-1 ].innerHTML
, "" );
	rinlmoejQuery,0"bler:
					undefinsF 
			t

			ot Set  {
ferlanstaklDa 		ortcut e
		j sstuse[jnnerHTML
			peof  "obofiv	r ei{={;"sturn  itri!rnoInnerhtml. {
			v	r eifn&&
				aljQuery.sentLoa.htmlS{rirlize  !=!rnoshimth ||. {
			v	r eifnifn&&
				aljQuery.sentLoa.lead	diWhit np

	u !=!rlead	diWhit np

	. {
			v	r eifnfn&&
				!wrapMa	[
		ntagN
		.
rec		v	r eifn !=["",i""]uf[1e.toL namCasttr ]ufn.

xeeerer ei{	v	r e
, "" );
	rxhtmlTag,i"<$1></$2>"i) 

=t		try{

					f) {
;++ ) {value = c
						ot Re)
	eseoLoit  {	} s ed:aprevit  me)
ry{leaks
						ee )  t, ie[i);||	{} 
						peof -1 ]werCa.isWi==,
1" {

							jQuery.cle=nDscr(+-1 ]wgetEmatchesByTagN
		(0"*" )i) 
							-1 ].innerHTMLi{	v	r e 
						}
					t

					ee )  t0 

=t		ot Ifauimodi	nnerHTMLi arowsse
dexcep// s,tuse[with,
		 lis ] 	hod
	=t	tee  fi(efn.t
			t

			peof -1 ]ufn.
				, ie)
	sel().rguend( v	r eifv
	=t}
		},dprom,dv	r e,ith,
		des)			firu)v
	},
ex, "" );Warg: f key, valv	r eifn.
xe {
		!isDisconn
		td(t  ie[re;)ifn.
xeeot MaklD]uuer and } e 
oLoit osethere)
	eds			ems e DOM b foreeentytetheirl rte	
	 !ot } ierlanshelp fix , "" )rn 	a panemea arg vhildtue )	deeex		peof jQuery.isrned.prot v	r eifnfn.
				rull ? , ie)
ach(f key, vaifn.
					re vs{;fd=	jQuery(, ie), old = s{;f.html() 
					s{;f., "" );Wargf v	r e
:
				, ie,;i, old )i) 
				}) 
			t

			peof  "obofiv	r ei!& t"sturn  ies 
xe	erer ei{	jQuery( v	r eif.detach() 
			t

			r'll ? , ie)
ach(f key, vafn.
				re vntmpd=	, ie.ntmpSiblmod,
					parist = , ie)	aristN	}  

=t		jQuery( , ieuf., )
	e() 

=t		peof nemp"es 
xet		jQuery(ntmp).b foref v	r eifv
	=t	} ire(  
xeee	jQuery(	arist).rguend( v	r eifv
	=t	t
			}e 
		}

=tn'tl ? , ie)			firu?
			, ie)				StarsaljQuery(jQuery.isrned.protv	r e)o? v	r e()i: v	r e),i", "" );Warg", v	r eifn:
			, iev
	},
exdetach:;) {
					ix{;
		or"es 
xen'tl ? , ie), )
	e(;x{;
		or,s ; lu)v
	},
exdomManip:;) {
					ith,e,;,ableamc
		 lis fn.

xeot Flattensany nessed thraeeex	th,e 
 [].lve;ha.rguly(0[],eth,e ) 

=tre vn's lis,efio f, fragm		v,;iNoClone,
			i7{ 0,
			rer ei{	th,e[re,
			xcripts 
 []a
xe	{i{;, ie)			fir 

=tot Whee gh, cloneN	} ufragm		ver and lck a	Qtlfirsme,ninlWebKit
=tpeof !jQuery.sentLoa.lfirsCloneitrilu>s1"th s"obofiv	r ei{={;"sturn  itrircfirse	. {
			v	r eifnfn.
xeer'll ? , ie)
ach(f key, vafn.
				jQuery	, ie).domManip(ith,e,;,ableamc
		 lis f 
			}r;
		}

=tpeof jQuery.isrned.protv	r e)ofn.
xeer'll ? , ie)
ach(f key, vaifn.
				re vs{;fd=	jQuery(, ie)v
	=t	th,e[rei{	v	r e
:
				, ie,;i, ,ableo? s{;f.html()i: undefinsF	fv
	=t	s{;f.domManip(ith,e,;,ableamc
		 lis f 
			}r;
		}

=tpeof   ie[re;)i{
			rus lisn=	jQuery.buildFragm		v) th,e,;, ie,;xcripts f 
			fragm		va= nus lis.fragm		v 
			fio fi=ufragm		v.fio fChild;

			peof fragm		v.vhildN	} s.{
				i==,
1" {

	=t	fragm		va= fio f 
			t

			peof fio fifn.
				,ableo= ,ableotrijQuery.erCaN
				fio f, "tr"i) 

=t		ot Use[withorigin	r fragm		v eed  hevlast it me	Q		ead	oftent fio fibecause[jtee g end up
=t		ot bern 	
	seitc7in vrr
		lyninlc rta	Qtsitua	/ snn(#8070).
=t		ot Fragm		ver			ems e fragm		v th ||Bmu	pdckwayonbe clonedte
		neverDuce		insp" );.
=t		f) {
	iNoClonea= nus lis.th ||ableo||	lu- 1i++ ) {value = c
					c
		 lis
:
			
						,ableotrijQuery.erCaN
				, ie[i], ",able";)i?
		 =t		findOrAguend( , ie[i], ",body" fn:
		 =t		, ie[i],
						pi==,
iNoClonea?
		 =t		fragm		v :
		 =t		jQuery.clone(ifragm		v,; ; lam ; lu)
		 =tfv
	=t	t
			}

	 !ot Fix #11809: Avoiduleakrn eme)
ry
			fragm		va= fio fi=upromi

			peof xcripts)			firues 
[ [/jQuery.uach( xcripts,;f key, vali, -1 ]ufn.
					peof -1 ]wsrc" {

						peof jQuery.ajax" {

							jQuery.ajax(

								url: -1 ]wsrc,
								s"ob: "GET",
								 scrT"ob: "xcript",
								async:sflista
								global:sflista
								" arows":  ; l
							}) 
						} ire(  
xeee	[/jQuery.urrac("no ajax") 
						}
					} ire(  
xeee	[jQuery.globalEv	r	}f -1 ]wntmp"||0-1 ]wntmpCventhe ||0-1 ]w	nnerHTMLi||0"ble
, "" );
	rcle=nScript,0"bler) 
					t

					peof -1 ]wparistN	} ufn.
						-1 ]wparistN	} wed)
	eChild( ue )ufv
	=t		t
				tfv
	=t}
		}

=tn'tl ? , iev
	}
}) 

 fer ) { findOrAguend( ue ),	,agufn.
	null ? -1 ]wgetEmatchesByTagN
		(0,aguf[re;||	-1 ]waguendChild( ue )wownerDntEleme.	rea	eEmatche		,agufn)v
}

 fer ) { cloneCopyEv	de( xrc, } st fn.

xll ) d stwnrCa.isWi!&& 1i||	!jQuery.hasDscr(+src" {es 
xen'tl ?;
	}

=re vng" ,vi,	l,
	!oldDscre=	jQuery._dscr(+src" a
xecurDscre=	jQuery._dscr(+d st, oldDscre=a
xeev	desu=soldDscr.ev	des 

=peof -v	desu {

		 ue te curDscr.handle 
		curDscr.ev	desu=s{} 

		f) {
	tisWiins-v	desu {

		tf) {
	i7{ 0, 	i{;-v	des[ tion"])			fir;++ ) {value = c
				jQuery.uv		v.rdd(id st, ng" ,v-v	des[ tion"][ ii]ufv
	=t}
		}
	}

=ry mak|B hev lonedtpublmc; scr obj
		ia vvpyr			ems e origin	r
	peof turDscr.dscre= c
		turDscr.dscre=	jQuery.uxntsd(	{}a turDscr.dscre=v
	}
}

 fer ) { cloneFixAt [ bu
es( xrc, } st fn.
	re v{rCaN
		;

=ry Wo dndn
tunee		to dndanyti	di eed pon-Ee )	deeexll ) d stwnrCa.isWi!&& 1ies 
xen'tl ?;
	}

=ot lle=rAt [ bu
esere)
	esms e at [ bu
esam aich
ferdnnh, wanp,exot but elsoere)
	esms e at achEv	dev-v	desam aich
fer*do* wanpexll ) d stwlle=rAt [ bu
ese {

		 ustwlle=rAt [ bu
es()v
	}

=ry mergeAt [ bu
esamins venrast, once merges{plisron } e
=ry origin	r at [ bu
esamn
tut e 
v	deeexll ) d stwmergeAt [ bu
ese {

		 ustwmergeAt [ bu
es(+src" v
	}

={rCaN
		u=sdespwerCaN
		.toL namCasttr 

=peof {rCaN
		u=&& (obj
		"les 
 !ot IE6-10eimproperce clones vfildrcn	oftobj
		iue )	deeauimodicljec	d.
 !ot IE10e arowssNoMod			ca	/ sAll nadErrac  {
parist isdprom,d#12132.
=tpeof despwparistN	} ufn.
			despwouterHTMLi{	srcwouterHTML;
		}

=tot T			/parg egueareauntvoidtacks	ac IE9. W reaclon	dise
dobj
		
=tot eoLoit   ieIE9,lwithouterHTMLin ;atlgyltbove/		/n
tusuf		ci		v.
		ot Ifa,	e+src"hasi	nnerHTMLiad:aent despria	) { ioMs uot,
		ot vvpyr,	e+srcw	nnerHTMLiinateent desp.innerHTML
d#10324
=tpeof jQuery.sentLoa.html5Cloneitri(srcw	nnerHTMLitri!jQuery.nrim(desp.innerHTMLffn= c
			desp.innerHTMLi{	srcwinnerHTML;
		}

=}fire(  {
		{rCaN
		u=&& (inpu
 itrircfirsn() .isW. {
			xrcwtion")des 
 !ot IE6-8	failoseo	persistd hev firsme 	ta	eaoftav lonedtcfirsbox
 !ot ordrad	o button. WorstamIE6-7	fail(eo	give0 hev lonedtee )	de
e	ot cv firsme eguearahc uiftent } faultCfirsme v	r eiis Th elsoes{t

		 ustw} faultCfirsme =sdespwcfirse		= xrcwcfirse	 

=tot IE6-7	get" vefuce		e
		
nd up neta	disent v	r eioftav loned
		ot vfirsbox/rad	o button atetnee	sel;sturn e	Q		ead	oft"on"
=tpeof despwv	r ei!& txrcwv	r eifn.
xeedespwv	r ei txrcwv	r e;
		}

=ot IE6-8	failoseo	n'tl ? , e0x{;
		tdtop// s ateent default x{;
		td
=ot 	ta	eaw reaclon	disop// ss
=}fire(  {
		{rCaN
		u=&& (op// s"e {

		 ustwx{;
		tdt txrcwdefaultS{;
		td;

=ot IE6-8	failoseo	 {tB hevdefaultV	r eiateent  vrr
		 v	r eiw re
=ot llon	disorun ttions )f inpu
	fiolds
=}fire(  {
		{rCaN
		u=&& (inpu
 i||	n	} N
		u=&& (ntmparia"e {

		 ustwdefaultV	r ei txrcwdefaultV	r e;

=ot IE blanks vventstsiw reaclon	disxcripts
=}fire(  {
		{rCaN
		u=&& (xcript"itri ustwntmpd!
= xrcwtemp"es 
xe ustwntmpd= xrcwtempv
	}

=ry Ev	devdscregetsdreferehc de	Q		ead	oftvvpitc7iftent expto o
=ry getsdvvpitc7too
e ustwed)
	eAt [ bu
e(	jQuery.uxpto od) 
}

jQuery.buildFragm		vd= f key, valth,e,;lventmp, xcripts fn.
	re vfragm		v,;th ||able,;th ||hit,
		fio fi=uth,e[ 0 ] 

xot S{  lventmpdf		emwand mayilnm "inlas undefinsF	) {aejQuery coller ) { o {ae{rCa
xot Upda	etsatefix #12266m a theaccessmodilventmp[re;coul		 arowse
dexcep// s  ieIE9/10e&
xot elsoedoubl s esefix 	ac #8950m a the"" i
dobj
		erlauce			rea	eDntElemeFragm		vdexcep// s
			}ntmp = lventmp"||0entEleme;
			}ntmp = !lventmpwnrCa.isWitrivventmp[re;||	lventmp;
			}ntmp = lventmpwownerDntElemea !=lventmp;

	ot Once th ||B"small" (1/2 KB) HTMLin ;modsr and ethejecocia	ets arg t esmainuentEleme
eot Clon	disop// ss loses , e0x{;
		tdt	ta	eamstednnh, ca ||B hem
=ot IE 6 ioMs Th like[jtew reayouupu
	<obj
		> o {<cmb.d>iue )	deeainla fragm		v
=ot Also,lWebKit ioMs uots lone 'cfirse	'sat [ bu
es  { cloneN	} amstednnh, ca ||
=ot LastlyamIE6,7,8	 ihe uots vrr
		lynreuse[v] ||d
fragm		ver and w thecrea	etsf		emunknownme1 ]sd#10501
tpeof th,s.{
				i==,
1"th s"obofifio fi=={;"sturn  itrifio f.{
				i< 512itrivventmpi=={;dntEleme re
		fio f.cfarAt(0es=&& "< itri!rnoth ||. {
			fio fifnre
		(jQuery.sentLoa.lfirsClonei !=!rcfirse	. {
			fio fiffnre
		(jQuery.sentLoa.html5Clonei !=!rnoshimth ||. {
			fio fiffnfn.

xeot Mark;th ||able	e
		look f) {aehit
=tth ||able	=  ; li
		fragm		va= jQuery.fragm		ve[	fio fi];
		th ||hiti=ufragm		vd!
= undefinsF 
	}

=peof !fragm		vdes 
xefragm		va= lventmpw	rea	eDntElemeFragm		v)) 
		jQuery.cle=nalth,e,;lventmp, fragm		v,;xcripts f 

xeot Upda	eeent  h ||, but once storeeflist
xeot unl, i
,			/		/a selve

parsmodioftent s
		uvventst
=tpeof th ||able	fn.
			jQuery.fragm		ve[	fio fi]a= lh ||hititrifragm		v 
		}
	}

=r'll ? {ifragm		v:vfragm		v,;th ||able: th ||able	};
} 

jQuery.fragm		ver=s{} 

jQuery.uach({
	aguendTo: "aguend",exp, "endTo: "p, "end",exirl rtB fore:;"b fore",exirl rtAfter:;"after",ex, "" );A.d: ", "" );Warg"
}, f key, valn
		, origin	r fn.
xjQuery.fn[0n
		)]d= f key, valx{;
		or"es 
xere ve1 ]sa
			i7{ 0,
			r'l 
 []a
xe	irl rti{	jQuery(  {;
		ori),
		 	i{;irl rt)			fir,
xe	parist = , ie){
				i==,
1"th s ie[rewparistN	}  

!	 {
		(parist ={	nt.do !=panemeatripaneme.nrCa.isWi==,
11ntripaneme.vhildN	} s.{
				i==,
1)itrilu==,
1" {

	=tirl rt[ origin	r ]f   ie[re;) 
			n'tl ? , iev
		} ire(  
xeef) {
	;++ ) {value = c
				e1 ]sd=
		i7>
0r? , ie)	lone( ; l)i: , ie ).g'	();
				jQuery	;irl rt[i] f[ origin	r ]f e1 ]sd);
				n'ti=mr'l)lve;haf e1 ]sd);
			t

			r'll ? , ie)				Starsalr'l, n
		, irl rt) {;
		ori) 
		}
	};
}) 

 fer ) { geeA				ue ) = c
	peof  "obofie1 ]wgetEmatchesByTagN
		i!& t"undefinsF"ies 
xen'tl ?+-1 ]wgetEmatchesByTagN
		(0"*" ) 

!}fire(  {
		 "obofi-1 ]wqueryS{;
		orA.do!& t"undefinsF"ies 
xen'tl ?+-1 ]wqueryS{;
		orA.d(0"*" ) 

!}fire(  
xen'tl ?+[]v
	}
}

ot Use		inscle=n,efixes , e0} faultCfirsme property
 fer ) { fixD faultCfirsme		ue ) = c
	peof rcfirsn() .isW. {
			-1 ]wnion")des 
 !-1 ]w} faultCfirsme =se1 ].vhirse	 
	}
}

jQuery.uxntsd({
		lone:;) {
					iue ),ldscrAndEv	des,sdeepDscrAndEv	desu {

		re vsrcEmatches,
xeedespEmatches,
xeei,
				lone 

!	 {
		jQuery.sentLoa.html5Clonei !=jQuery.isXMLDoc(ue ))i !=!rnoshimth ||. {
			"< i+ -1 ]werCaN
		i+ ">" fn= c
			clonea= e1 ].vloneN	} (s ; lu)v

=tot IE<=8 ioMs uotsproperce clone detachme,nunknownme1 ]it  {	} s
		} ire(  
xeefragm		vDiv.innerHTMLi{	ue )wouterHTML;
		efragm		vDiv.ed)
	eChild( clonea= fragm		vDiv.fio fChildufv
	=}

=tpeof (!jQuery.sentLoa.noCloneEv	dev||	!jQuery.sentLoa.noCloneCfirsmefn&&
				a-1 ]werCa.isWi==,
1"||	-1 ]wnrCa.isWi==,
11)itri!jQuery.isXMLDoc(ue ))ifn.
xeeot IE vvpitss-v	desubpundsvia at achEv	devw reauimodicloneN	} .
xeeot CallmodidetachEv	devon } e clonea ihe elsoere)
	eut e 
v	deeex !ot fr	ems e origin	r. I{ o dn tto get"arpund;, ie,;wetuse[snm ex !ot proprietary ] 	hods to lle=rut e 
v	dee. Tpanks ateMooTooleex !ot guys eed  hie hotn, i.

			cloneFixAt [ bu
es( ue ),lclonea) 

=t	ot UsmodiSizz4.  etheisocraze slowamstewetuse[getEmatchesByTagN
		i	Q		ead
=t	srcEmatchesa= geeA				ue ) =;
xeedespEmatchesa= geeA				clonea) 

=t	ot Weird it ra	) { because[IE  ihe , "" );  hevl
				iproperty
=t	ot  arg e
deoLoit   fayouuetheclon	dis hevbody e
		oneaoftent
=t	ot ue )	deeaon } e page"hasia0n
		)ac  d	oft"l
				"
		tf) {
	i7{ 0;vsrcEmatches[i]  ++iufn.
			=ry En]uuer and } e despria	) { n	} u		/n
tupromiaFixes #9587
				peof despEmatches[i] fnc
					cloneFixAt [ bu
es( xrcEmatches[i], despEmatches[i] fv
	=t	t
			}
		}

=tot Cvpyr,	e+-v	desufr	ems e origin	riateent  lone
=tpeof dscrAndEv	desu {

			cloneCopyEv	de( ue ),lclonea) 

=t	peof deepDscrAndEv	desu {

		t	srcEmatchesa= geeA				ue ) =;
xeeedespEmatchesa= geeA				clonea) 

=t	tf) {
	i7{ 0;vsrcEmatches[i]  ++iufn.
			=	cloneCopyEv	de( xrcEmatches[i], despEmatches[i] fv
	=t	t
			}
		}

=tsrcEmatchesa= despEmatchesa= promi

		ot Retl ? , e0 lonedts{t
		null ? vlone 
	},
ex	le=n:;) {
					iue )e,;lventmp, fragm		v,;xcripts f c
		re vi, j, ue ),	,ag,vwrap, depir,idiv,}hasBody,	,body,	l
	,}handleScript,0jsTags,
			safe = lventmp"=={;dntEleme re;safeFragm		v,
			r'l 
 []i

		ot En]uuer and lventmp"		/a entEleme
e=peof !lventmp"||0n"obofilventmpw	rea	eDntElemeFragm		vs=&& "undefinsF"ies 
xe			}ntmp = entEleme;
		}

=tot Use[withalready-crea	etssafe fragm		v  filventmp	permieeex f) {
	i7{ 0;v(ue )	=:ue )e[i)) ! tpromialue = c
			ll )  "obofie1 ] 	&& "numb.r" = c
				e1 ] +& "" 
			t

			peof !ue )ufn.
						}ninue 
			t

			ot Cvnv rtihtmlisturn e	QateDOM {	} s
t		peof  "obofie1 ] 	&& "sturn  ies 
xe	tpeof !nhtml. {
			ue )ufn {

					ee )  tlventmpw	rea	eTtmpN	} alue )ufv
	=t	t ire(  
xeee	ot En]uuerassafe lck a	Qe {irm aich
eo	n'ndn ttithhtml
xeee	safe = safe  !=lrea	eSafeFragm		v) lventmpd)v
	=t		div {;lventmpw	rea	eEmatche	"div");
xeee	safe.rguendChild( div*f 

=t	t!ot Fix "XHTML"-xtyleitagsainlahe browsers
					ee )  t-1 ]wed"" );
rxhtmlTag,i"<$1></$2>"f 

=t	t!ot Go
eo	htmlie
		plis,lwitn	peel	offdex ;a wrapptrs
					tag = 		ntagN
		.
rec		ue )ufn !=["",i""]uf[1e.toL namCasttr;
xeee	wrap =	wrapMa	[
tag e;||	wrapMa	._defaultv
	=t		depir =	wrap[rev
	=t		div.innerHTMLi{	wrap[1]i+ -1 ] +	wrap[2] 

=t	t!ot M
	eutteent right depir
xeee	w ilum(+depir--) {

xeee		div {;div.lastChild;
		 !	t

					ot Re)
	esIE'suautoirl rte	 <tbody>ufr	emstacks	ragm		ve
					peof !jQuery.sentLoa.tbody fn.

xeee		ot Sturn ewasia0<tn() >, *may*}have0xpurious <tbody>
xeee		hasBodyi=mrtbody. {
		ue )) 
							tbody = tag =&& (nable";tri!hasBodyi?
		 =t			div.fio fChildureddiv.fio fChild)vhildN	} sw:

		 =t			ot Sturn ewasia0bethe<thead> o {<tfoot>
		 =t			wrap[1]i=&& "<tn() >" tri!hasBodyi?
		 =t				div.vhildN	} sw:
		 =t				[] 

=t	t! f) {
	j = tbody.l
				i- 1i+ju>,
0r; --j" {

							 {
		jQuery.erCaN
				,body[+ju], ",body" fntri!,body[+ju].vhildN	} s.{
				i {

								,body[+ju].paristN	} wed)
	eChild( ,body[+ju]i) 
							}
						}
					t

					ot IE vvmpcWteuerkihes lead	di	whit np

	uw rea	nnerHTMLiieuuce	
	 !		peof !jQuery.sentLoa.lead	diWhit np

	utrirlead	diWhit np

	. {
			ue )ufn {

						div.inl rtB foref lventmpw	rea	eTtmpN	} alrlead	diWhit np

	.
rec	ue ))[re;),ddiv.fio fChildr) 
					t

					ee )  tdiv.vhildN	} s 

=t	t!ot Tak|Bouv )f fragm		v tck a	Qe {(wetnee		a fresh div*uach time)
	=t		div.paristN	} wed)
	eChild( div*f 
				}
			t

			peof -1 ] nrCa.isWifn.
xe		nul)					}ue )ufv
	=tt ire(  
xeeejQuery.merge	ir'l, ue )ufv
	=tt
		}

=tot Fix #11356: Cle=ruue )	deeafr	emsafeFragm		v
=tpeof div*fn.
			ee )  tdiv = safe = promi
		}

=tot Re {tB} faultCfirsme fed any rad	os ed:avfirsbox s
t	ot ebouv eo	b "rguendetsates e DOM  ieIE 6/7n(#8060)
		peof !jQuery.sentLoa.rguendChirsme  {

		tf) {
	i7{ 0;v(ue )	=:n't[i)) ! tpromialue = c
				 {
		jQuery.erCaN
				ue ),	(inpu
 ifn {

					fixD faultCfirsme		ue ) =v
	=t	t ire( peof  "obofie1 ]wgetEmatchesByTagN
		i!& t"undefinsF"ies 
xeeeejQuery.grep(+-1 ]wgetEmatchesByTagN
		("inpu
 ), fixD faultCfirsme fv
	=t	t
			}
		}

=tot Aguendo
oLoit oseo	aiprovidid;dntEleme fragm		v
=tpeof fragm		vdes 
xe	ot Sid
		rihandlmodioftuach xcripttee )	de
e		handleScript = f key, value )ufn.
			=ry dfirss {
ferlonsider[jte
recutn() 
xe	tpeof !-1 ]wnion"||	rscript.isW. {
			-1 ]wnion")des 
 !		=ry Detachtent script ed:astoreeit  ea hevxcripts thrae ( {
providid) ed  hevfragm		v
=t			ot Retl ? ,ruthy	eo	irrica	eaenat it"hasibereahandle	
	 !		r'll ? scripts ?
		 =t	xcripts)					}ue )wparistN	} u?}ue )wparistN	} wed)
	eChild( ue )uf;:	ue ) fn:
		 =t	fragm		v.aguendChild( ue )ufv
	=t	t
			} 

=t	f) {
	i7{ 0;v(ue )	=:n't[i)) ! tpromialue = c
				ry dfirss {
fe'rerdnn "rfterihandlmodie
dexecutn()  script
xe	tpeof !		jQuery.erCaN
				ue ),	(xcript"ifntrihandleScript		ue )ufn {es 
 !		=ry Aguendoatefragm		vded:ahandle cmb.ddid;xcripts
= =t	fragm		v.aguendChild( ue )ufv
	=t		peof  "obofie1 ]wgetEmatchesByTagN
		i!& t"undefinsF"ies 
xe!		=ry handleScript alternns e DOMamsteuse[jQuery.mergeoateen]uuersnapshot it ra	) {
xe!		=jsTags = jQuery.grep(ljQuery.merge	i[],e-1 ].getEmatchesByTagN
		("xcript");),dhandleScript f 

=t	t!	ot Sice);a hevxcripts 	Qater'l rfteri heir fedmertc
cestorded:aadvahc uour lrr,  beyod:aentm
=t	t!	n't.xpce);.rguly(0arl, [i +	1, 0])lve;haf jsTags )i) 
						i +& jsTags)			fir;
					t
				t
			}
		}

=tn'tl ? arg 
	},
excle=nDscr:;) {
					iue )e,;/*{irter{li */eacceptDscre= c
		re vdscr, id, ue ),	,g" ,
			p7{ 0,
			irter{liKeye=	jQuery.uxpto o,
				h ||B
 jQuery.ch ||,
			 ue teExpto od=	jQuery.sentLoa. ue teExpto o,
			sid
		ri=	jQuery.uv		v.sid
		ri

=tf) {
	;+(ue )	=:ue )e[i)) ! tpromialue = c

			peof acceptDscre !=jQuery.acceptDscr		ue )ufn {


xe	tpe =se1 ][ irter{liKeyeev
	=t	dscre=	iduredch ||[	idu] 

=t	tpeof dscrufn.
					peof dscr.ev	desues 
xe!		=f) {
	tisWiinsdscr.ev	desues 
xe!		=	peof xid
		r[ tion"]i {

								jQuery.uv		v., )
	e(;ue ),	,g"  f 

=t	t!	tot T			/		/a s	ortcut eo	avoidujQuery.uv		v., )
	e'su
	erhead
=t		=t	t ire( 

								jQuery., )
	eEv	de( ue ),lng" ,vdscr.handlei) 
							}
						}
					t

					ot Re)
	es	h ||Bonce ifai, wasin
tualreadyere)
	edsbyujQuery.uv		v., )
	e
					peof ch ||[	idu] fn.

xeee		 ue te ch ||[	idu] 

=t	t		ot IE ioMs uotsall neus	to due te uxpto odpropertitssfr	em{	} s,
=t	t		ot n) {ioMs it"ha	esa ed)
	eAt [ bu
ei fer ) {  { DntElemean	} s 
=t	t		ot w|Bmu	pdhandleiahe oftentse[v]ses
						peof dee teExpto od {

							due te u1 ][ irter{liKeyeev

						} ire( peof -1 ]wed)
	eAt [ bu
ei {

							-1 ]wed)
	eAt [ bu
e( irter{liKeye)v

						} ire( 

							-1 ][ irter{liKeyee = promi
						t

						jQuery.due tedIds)					}idr) 
					t
				t
			}
		}
	}
}) 
ot Limit"scosW pollu ) { fr	emany der ccaiod API
(f key, vafn.

re vma fi F, browser;

ot Use oftjQuery.browsereier	rowned upon.
ot M
re details: http://api.jquery)lvm/jQuery.browser
ot jQuery.uaMa fi
main a	Qee fed back-cvmpae
jQuery.uaMa fi
= f key, valurufn.
	ure=	ua.toL namCasttr 

=re vma fie=	/(chr	ee)[ \/]([\w.]+)/.
rec		urufn||
=to(webkit)[ \/]([\w.]+)/.
rec		urufn||
=to(opera)(?:.*vers/ s|)[ \/]([\w.]+)/.
rec		urufn||
=to(msie) ([\w.]+)/.
rec		urufn||
=tua.irr, el("cvmpaeible");< 0uredo(mozilla)(?:.*? rv:([\w.]+)|)/.
rec		urufn||
=t[] 

=r'll ? {
/tbrowser:vma fi[ 1 e;||	"",
		vers/ s:vma fi[ 2 e;||	"0"
	};
} 

ma fi F 
 jQuery.uaMa fialn
viga	or.userAg		vde;
browsere=s{} 

peof ma fi F.browserefn.
	browser[ ma fi F.browsere]	=  ; li
	browser.vers/ s	= ma fi F.vers/ s;
}

ot Chr	eeeierWebkit, but Webkit/		/alsoeSafari.
ll ) browser.chr	eeefn.
	browser.webkit	=  ; li
} ire( peof browser.webkit	fn.
	browser.safari	=  ; li
}

jQuery.browsere=sbrowser;

jQuery.seb
= f key, vafn.
	 fer ) { jQuerySub	ix{;
		or,elventmp"es 
xer'll ? pct(jQuerySub.fn.init	ix{;
		or,elventmp"e 
	}
	jQuery.uxntsd(	 ; lamjQuerySub,	, iei) 
	jQuerySub.senercljec =:, ie;
	jQuerySub.fn 
 jQuerySub.prototisWi=;, ie();
	jQuerySub.fn)lves ; 		ori{;jQuerySub 
	jQuerySub.seb = , ie)sub 
	jQuerySub.fn.init
= f key, v init	ix{;
		or,elventmp"en.
xe {
		 ventmpdtrivventmp"	es ahc oftjQueryntri!(vventmp"	es ahc oftjQuerySubfn= c
			c	}ntmp = jQuerySub	ilventmpd)v
	=}

=tn'tl ? jQuery.fn.init
:
				, ie,;x{;
		or,elventmp, rootjQuerySubw)l
	};
	jQuerySub.fn.init.prototisWi=;jQuerySub.fn;
=re vrootjQuerySubw= jQuerySub	dntEleme)l
	n'tl ? jQuerySub 
} 

})();
re vcurCSS, ifr
		, ifr
		Dnt,ex,alphre=	/alphr\([^)]*\)/i,
	ropacited=	/opacite=([^)]*)/,
	rposi ) {	=;/^(top|right|bottom|left)$/,
	ot swrgun()   {
dixpcayu		/n
n	)ac s artsiwarg tn()  excep/ (nable", ",able-cell"amed ",able-cap// s"
	ot se.  ethefed dixpcayuv	r es: https://duv	loper.mozilla.org/en-US/dnts/CSS/dixpcay
	rdixpcayswrg	=;/^(n
n	|,able(?!-c[ea]).+)/,
	rmargi{	=;/^margi{/,
	rnumxpcev 
 pct(RegExp( "^(" +	core_pnum*+ ")(.*)$",i"i"i),
	rnumn
npx 
 pct(RegExp( "^(" +	core_pnum*+ ")(?!px)[a-z%]+$",i"i"i),
	rrelNum 
 pct(RegExp( "^([-+])=(" +	core_pnum*+ ")",i"i"i),
	-1 ]dixpcayu=	{}a
excssSh ne=	{ posi ) {:;"absolu e", visibilite:;"hidden", dixpcay:;"block" },
	vssNedmalTransfedm =:.
		e tterSp )rn : 0,
		fvenWeight: 400
	},
excssExpto  
 [ "Top",i"Right",i"Bottom",i"Left" ]a
xcssPrefixes 
 [ "Webkit",i"O",i"Moz",i"ms" ]a

eev	desToggl|B
 jQuery.fn.toggl|;

ot n'tl ? a cssiproperty mapptc7eo	aipontst		rce v	dded prefixee property
 fer ) { v	ddedPropN
				xtyleamn
		)fn.

xot s	ortcut eed p
		s* and etheuotsv	dded prefixee
=peof {
		i	Q	xtyle"es 
xer'll ? p
		;
	}

=ot lfirsseed v	dded prefixee p
		s
=re vcapN
		u=sp
		.cfarAt(0e.toUpptrCasttr +sp
		.xce);(1),
		origN
		u=sp
		,
		i	= cssPrefixes)			fir 

=w ilum(+i--) {

xen
		u=scssPrefixes[ ii]u+vcapN
		;
xe {
		{
		i	Q	xtyle"es 
xeer'll ? p
		;
		}
	}

=r'll ? origN
		v
}

 fer ) { isHidden( ue ),ler fn.
xue )	=:ue"||	-1 ]l
	n'tl ? jQuery.css( ue ),l"dixpcay"ies	&& "n
n	"v||	!jQuery.tck a	Qs( ue )wownerDntEleme, ue )ufv
}

 fer ) { sh nHide(*
oLoit oamsh n fn.
	re vue ),ldixpcay,
		v	r es 
 []a
xelrr,  { 0,
		{
				i=*
oLoit o)			fir 

=f) {
	;++rr,  < 			fir;++rr, ue = c
		ue )	=:ue )		ve[	+rr,  ];
xe {
		!-1 ]wxtyle"es 
xee		}ninue 
		}
		v	r es[	+rr,  ]e=	jQuery._dscr(+ue ),l"olddixpcay"ie;
xe {
		sh n fn.
	=tot Re {tB} esinlmoe dixpcayuoften		/eoLoit  eo	le=rn ifai, ieex !ot bern 	hiddensbyuv]scadid;rul s ed pot
			peof !v	r es[	+rr,  ]eredue ).xtyle.dixpcayu=&& "n
n	"v {

				-1 ]wxtyle.dixpcayu= "" 
			t

			ot S{  
oLoit os aich
ha	esberea
	erriddenswarg dixpcay:;none
=ttot lr/a styleshe{  atewandeverDent default browserextyle"ieex !ot f) {sucg e
deoLoit 
			peof -1 ] xtyle.dixpcayu=&& "" triisHidden( ue )n {es 
 !		v	r es[	+rr,  ]e=	jQuery._dscr(+ue ),l"olddixpcay",scss_defaultDixpcaya-1 ]werCaN
		)ufv
	=tt
		} ire( 

			dixpcayu= curCSS( ue ),l"dixpcay"ie 

=t	peof !v	r es[	+rr,  ]ereddixpcayu!&& "n
n	"v {

				jQuery._dscr(+ue ),l"olddixpcay",sdixpcayufv
	=t}
		}
	}

=ry S{tB hevdixpcayuoftmostioftent 
oLoit oslr/a selve

loop
=ry eo	avoiduent  ves ah, nuflow
=f) {
	lrr,  { 0;++rr,  < 			fir;++rr, ue = c
		ue )	=:ue )		ve[	+rr,  ];
xe {
		!-1 ]wxtyle"es 
xee		}ninue 
		}
		ll ) !xh n ||	-1 ]wxtyle.dixpcayu=&& "n
n	"v||	-1 ]wxtyle.dixpcayu=&& ""v {

			-1 ]wxtyle.dixpcayu= xh n ? v	r es[	+rr,  ]e||0"bl: "n
n	";
		}
	}

=r'll ? ue )		ve 
}

jQuery.fn.uxntsd({
	css: f key, valn
		, v	r eifn.
xer'll ? jQuery.access	i, ie,;f key, value ),ln
		, v	r eifn.
xeer'll ? v	r ei!
= undefinsF	?
				jQuery.xtylealue ),ln
		, v	r eifn:
				jQuery.css( ue ),ln
		)f;
		},ln
		, v	r e,ith,
		des)			firu> 1i) 
	},
	sh n: f key, vaes 
xen'tl ? sh nHide(*, ie,; ; lu)v
	},
	hide: f key, vaes 
xen'tl ? sh nHide(*, ieu)v
	},
	toggl|:;) {
					ixta	eamfn2e= c
		re vboo{i{;,"obofixta	ea=&& "boo{ean" 

!	 {
		jQuery.isrned.prot xta	ea)otrijQuery.isrned.prot fn2e= fn.
xeer'll ? ev	desToggl|.rguly(0, ie,;th,
		deer);
xe}

=tr'll ? , ie)
ach(f key, vafn.
			peof boo{i? xta	ea:iisHidden( , ier) fn.
				jQuery	 , ie ).sh n(fv
	=tt ire(  
xeeejQuery	 , ie ).hide(fv
	=t}
		}=v
	}
}) 

jQuery.uxntsd({
	ry Addi	Q	xtyle"property hooks eed 
	errid	dis hevdefaultexot beha	ied 
f geetmodie
d neta	disa	xtyle"property
	cssHooks:  
xeopacite:  
xe	gee:;) {
					iue ),lcvmputsF	fn.
				 {
		 vmputsF	fn.
				=ry Wo sh ul		ckwayonget"a numb.r{plisrfr	emopacite
				=re vn't
=mcurCSS( ue ),l"opacite"r) 
					n'tl ? argu=&& ""v? "1"n: arg 

xe		t
			}
		}
	},
exot Exclude[with,oll nmodicssipropertitsseo	addipx
	vssNumb.r:  
xe"fillOpacite":  ; l,
xe"fvenWeight":  ; l,
xe"lmoeHeight":  ; l,
xe"opacite":  ; l,
xe"orphrns":  ; l,
xe"widows":  ; l,
xe"zIrr, ":  ; l,
xe"zoom":  ; l
	},
exot Addi	Q	propertitsswhoe( p
		s*youuwishsatefix b fore
	ot seta	dised geta	disent v	r e
xcssProps:  
xeot n) mrlize flond lssiproperty
xe"flond": jQuery.sentLoa.lssFlond ? "lssFlondbl: "xtyleFlondb
	},
exot Getie
d neta hevxtyle"property or/a DOM NrCa
xxtyle:;) {
					iue ),ln
		, v	r e,iex ;a es 
 !ot Dogh,  {t stylesaon }tmpded:avom]it  {	} s
		peof !ue )u||	-1 ]wnrCa.isWi==,
3u||	-1 ]wnrCa.isWi==,
8v||	!-1 ]wxtyle"es 
xeen'tl ?;
		}

=tot MaklD]uuer and fe'rerworkrn e arg t esright n
		
	=re vn't,lng" ,vhooks,
=t	origN
		u=sjQuery.chmelCasttln
		)f,
			style"=	-1 ]wxtyle 

xen
		u=sjQuery.cssProps[ origN
		 ]e||0(sjQuery.cssProps[ origN
		 ]e= v	ddedPropN
				xtyleamorigN
		 )u)v

=tot getsdhook f) {} e prefixee vers/ s
 !ot f)ll nadsbyu} e unprefixee vers/ s
 !hooks =sjQuery.cssHooks[0n
		)]d !=jQuery.cssHooks[0origN
		 ]v

=tot dfirss {
fe'rerneta	disa	v	r e
x	 {
		v	r ei!
= undefinsF	es 
xeetisWi=;,"obofiv	r e 

=t	ot cvnv rtirelative0numb.r{n ;modsr(+=sed -=)
eo	n'lative0numb.rs. #7345
			peof tisWi==,
"sturn  itri(n'ti=mrrelNum.
rec		v	r eif {es 
 !		v	r e = 		net[1]i+ 1" {*	net[2]i+ parseFlond( jQuery.css( ue ),ln
		 )u)v
			=ry Fixes bug #9237
				tisWi=;"numb.r" 
			t

			ot MaklD]uuer and NaNte
		nt.dov	r es arish,  {t. Set: #7116
			peof v	r ei{=	nt.do !=tisWi==,
"numb.r" triisNaNt v	r eifnfn.
				rull ? 
			t

			ot If"a numb.r{wasipjece		in,	addi'px'sates e (excep/ f) {c rta	QtCSS	propertits)
			peof tisWi==,
"numb.r" tri!jQuery.cssNumb.r[ origN
		 ]ees 
 !		v	r e +& "px" 
			t

			ot If"a hook wasiprovidid,tuse[wiat v	r e,iorun wise	j sstneta hevxid
	fime v	r e
=t	peof !hooks ||	!("net"i	Q	hooksfn !=(v	r e = hooks.net( ue ),lv	r e,iex ;a e)i!
= undefinsF	es 
xee=ry Wrapptc7eo	previt  IEufr	ems r nmodiurracsiw rea'inv	rid'ov	r es ariiprovidid
			=ry Fixes bug #5509
				try{

					xtyle[0n
		)]d= v	r e 
				tee  fi(efn.t
			t

		t ire(  
xeeot If"a hook wasiprovididnget" hevpon- vmputsF	v	r e fr	ems ere
=t	peof hooks tri"get"i	Q	hooksitri(n'ti=mhooks.get( ue ),lflistamex ;a e)i!
= undefinsF	es 
xee=n'tl ? arg 
			t

			ot Orun wise	j sstget" hevv	r e fr	ems evxtyle"obj
		
=ten'tl ? style[0n
		)];
		}
	},
excss:;) {
					iue ),ln
		, numeric,iex ;a es 
 !re vv	r, num,vhooks,
=t	origN
		u=sjQuery.chmelCasttln
		)f;

=tot MaklD]uuer and fe'rerworkrn e arg t esright n
		
	=n
		u=sjQuery.cssProps[ origN
		 ]e||0(sjQuery.cssProps[ origN
		 ]e= v	ddedPropN
				-1 ]wxtyleamorigN
		 )u)v

=tot getsdhook f) {} e prefixee vers/ s
 !ot f)ll nadsbyu} e unprefixee vers/ s
 !hooks =sjQuery.cssHooks[0n
		)]d !=jQuery.cssHooks[0origN
		 ]v

=tot If"a hook wasiprovididnget" hev vmputsF	v	r e fr	ems ere
=tpeof hooks tri"get"i	Q	hooksies 
xeev	ri=	hooks.get( ue ),l ; lamex ;a e;
		}

=tot Orun wise, if"a waytto get" hev vmputsF	v	r e exis oamuse[wiat
x	 {
		v	ri{={;undefinsF	fn.
			v	ri=	curCSS( ue ),ln
		)f;
		}

=totcvnv rti"n) mrl" to lvmputsF	v	r e
x	 {
		v	ri{={;"n) mrl" tri{
		i	Q	vssNedmalTransfedm fn.
			v	ri=	cssNedmalTransfedm[0n
		)];
		}

		ot Retl ?, cvnv rt	diseo numb.r{ {
fedcsF	) {aequ	rifimr wasiprovididne
		v	rilooksinumeric
x	 {
		numericu||	-x ;a !
= undefinsF	es 
xeenum 
 parseFlond( v	ri) 
			n'tl ? numericu||	jQuery.isNumeric		num )o? num ||	0i: v	r 
		}
		r'll ? v	r;
	},
exot A ] 	hod f) {quickce swrgurn e	Q/ouv CSS	propertitstto get" vrr
		 calcula// ss
=swrg:;) {
					iue ),lop// ssamc
		 lis fn.
	=re vn't,lp
		,
			old = {} 

		ot Re)emb.r{s e olF	v	r ee,;tnd irl rt" hevpew	oneeex f) {
	{
		i	Q	op// ss es 
xeeolF[0n
		)]d= -1 ]wxtyle[0n
		)];
			-1 ]wxtyle[0n
		)]d= op// ss[0n
		)];
		}

		n't
=mc
		 lis
:
			 ue )ufv

		ot Rev rt" hevolF	v	r eeex f) {
	{
		i	Q	op// ss es 
xee-1 ]wxtyle[0n
		)]d= olF[0n
		)];
xe}

=tr'll ? arg 
	}
}) 

ot NOTE: Tndany;) tuuermain a	Qer,;we'vea iddew.getCvmputsFStyle
ot because[jsd	emo{ n	} .js  ihe breake argouv it.
ll )  iddew.getCvmputsFStyle es 
xcurCSS = f key, value )amn
		)fn.
	=re vn't,lwidir,iminWidir,imaxWidir,
xee		mputsF	=  iddew.getCvmputsFStylealue )amnt.dof,
			style"=	-1 ]wxtyle 

xe {
		 vmputsF	fn.

			n't {;lvmputsF[0n
		)];
			peof rrgu=&& ""vtri!jQuery.cck a	Qs( ue )wownerDntEleme, ue )uf	es 
xee=n'td=	jQuery.stylealue ),ln
		i) 
			t

			ot A  [ bu
eiates e "awesnm  hlis byuDean Edwards"
			ot Chr	eee< 17;tnd Safari 5.0muses "lvmputsF	v	r e"e	Q		ead	oft"uce		v	r e"ef) {margi{-right
			ot Safari 5.1.7 (nd least) n'tl ?s	percemeage"f) {aelarge vs{ldofiv	r es, but widir se.ms eo	b "reliabce pixeleex !ot ,			/		/aga	Qst" hevCSSOM draftvxid
: http://dev.w3.org/csswg/cssom/#resnlved-v	r eeex 	peof rnumn
npx. {
			n'td)otrirmargi{. {
			n
		 )u)s 
xee=widir = style.widir 
				minWidir = style.minWidir 
				maxWidir = style.maxWidir 

xe		style.minWidir = style.maxWidir = style.widir	=:n't;
xee=n'td=	lvmputsF.widir 

xe		style.widir	=:widir 
				style.minWidir = minWidir 
				style.maxWidir = maxWidir 
			}
		}

=tr'll ? arg 
	}i
} ire( peof dntEleme.dntElemeEmatche.curristStyle es 
xcurCSS = f key, value )amn
		)fn.
	=re vleft, rsLeft,
			r'l 
 ue )wcurristStyle redue ).curristStyle[0n
		)],
			style"=	-1 ]wxtyle 

xeot Avoiduneta	disr{  atee	sel;sturn e ere
=tot so
ferdnnh, default eo	auto
		peof rrgu=&mnt.dore;style redxtyle[0n
		)]des 
xeen't = style[0n
		)];
		}

		ot Fr	ems evawesnm  hlis byuDean Edwards
		ot http://erik.eae.net/archives/2007/07/27/18.54.15/#vom]it -102291

=tot If"fe'rern
tueealrn e arg a edgular pixel numb.r
=tot but e numb.r{ and hasia0weird 	ddmod, wetnee		to lvnv rtiit eo	pixeleex ot but uotsposi ) {	lssiat [ bu
esamas* aoe( ariiprotLoa) {	riateent panemeaeoLoit  	Q		ead
=tot end whee gh, measuuer at panemea	Q		ead	because[jtemight  [ gge va
"stlismodid)lls"iprobltm
=tpeof rnumn
npx. {
			n'td)otri!rposi ) {. {
			n
		 )u)s 
ex !ot Re)emb.r{s e origin	riv	r eeex 	left = style.left 
			nsLeft  t-1 ]weuntimeStyle redue ).euntimeStyle.left 
ex !ot Put  ea hevpew	v	r es to get"av vmputsF	v	r e ouvex 	peof rsLeft  {

				-1 ]weuntimeStyle.left 
 ue )wcurristStyle.left 
			}
			style.left 
 n
		u=&& (fvenSize"v? "1em"n: arg 
xeen't = style.pixelLeft + "px" 
ex !ot Rev rt" hevchangeF	v	r eeex 	style.left 
 left 
			peof rsLeft  {

				-1 ]weuntimeStyle.left 
 rsLeft 
			}
		}

=tr'll ? argu=&& ""v? "auto"n: arg 
x}v
}

 fer ) { setPosi )veNumb.r( ue ),lv	r e,isub ;act fn.
	re vma fi s =srnumxpcev.
rec		v	r eifl
	n'tl ? ma fi s ?
			Math.max( 0, ma fi s[ 1 e;-
		sub ;act ||	0i)u)s+of ma fi s[ 2 e;||	"px"ifn:
			v	r e 
}

 fer ) { augm		vWidirOrHeight	iue ),ln
		, -x ;a, isBo dn Box fn.
	re vi	= -x ;a =&& ( isBo dn Box ? "bo dn bl: "vventst";)i?
		ot If"feualreadyeha	est esright measuueleme, avoiduaugm		va	) {
xe4n:
		ot Orun wise	initirlize f) {horizck al ed v	oa):
		propertits
	=n
		u=&& "widir"v? 1 : 0,

		v	ri=	0 

=f) {
	;++e< 4;++e+= 2e= c
		ot borg box m	} ls exclude[margi{amsteaddiits {
ferwanp it
=tpeof -x ;a =&& "margi{"v {

			ot w|Buse[jQuery.lssi	Q		ead	oftvurCSS  ere
=t	ot because[oftent reliabceMargi{Right CSS	hook!
			v	ri+= jQuery.css( ue ),l-x ;a + cssExpto [ ii],; ; lu)v
		}

		ot Fr	ems 		/poidevon w|Buse[vurCSS f) {maximum perfedmahc u(relevat   ieanima// ss)
		peof isBo dn Box fn.
			ot bo dn -box includesipjddmod, soere)
	euits {
ferwanp vventst
=ttpeof -x ;a =&& "vventst";)i 
 !		v	r -
 parseFlond( curCSS( ue ),l"pjddmod" + cssExpto [ ii]i)u)s||	0 
			t

			ot nd } 		/poide,l-x ;a is Th bo dn  n) {margi{amstere)
	eubo dn 
=ttpeof -x ;a !&& "margi{"v {

				v	r -
 parseFlond( curCSS( ue ),l"bo dn bl+ cssExpto [ ii]i+ "Widir"v)u)s||	0 
			t
		t ire(  
xeeot nd } 		/poide,l-x ;a is Th vventstamsteaddipjddmod
			v	ri+= parseFlond( curCSS( ue ),l"pjddmod" + cssExpto [ ii]i)u)s||	0 

xeeot nd } 		/poide,l-x ;a is Th vventst n) {pjddmod, soeaddibo dn 
=ttpeof -x ;a !&& "pjddmod"  {

				v	r += parseFlond( curCSS( ue ),l"bo dn bl+ cssExpto [ ii]i+ "Widir"v)u)s||	0 
			t
		t
	}

=r'll ? v	r;
}

 fer ) { geeWidirOrHeight	iue ),ln
		, -x ;a)fn.

xot S arte arg offs{ldpropertyam aich
		/equiv	rit  eo	 hevbo dn -box v	r e
xre vv	r 
 n
		u=&& (widir"v? ue )woffs{lWidir : ue )woffs{lHeight,
		v	r eIsBo dn Box =  ; l,
xeisBo dn Box = jQuery.sentLoa.boxSizmoditrijQuery.css( ue ),l"boxSizmod"ies	&& "bo dn -box";

	ot snm  pon-htmli
oLoit osr'll ? undefinsF	eed 
ffs{lWidir, soelfirsseed nt.d/undefinsF
	ot svg;-
https://bugzilla.mozilla.org/sh n_bug.cgi?id=649285
tot MathML;-
https://bugzilla.mozilla.org/sh n_bug.cgi?id=491668
	 {
		v	ri<,
0r||	v	ri{=mnt.dof c
		ot Fahe blis to lvmputsF	witn	fervmputsF	lssi	fvpecessary
		v	ri=	curCSS( ue ),ln
		)f;
		 {
		v	ri<
0r||	v	ri{=mnt.dof c
			v	ri=	-1 ]wxtyle[0n
		)];
		}

=tot CvmputsF	unit/		/uotspixele. S op  etheend r'll ?.
=tpeof rnumn
npx. {
		v	r= fn.
xeer'll ? v	r 
		}

		ot w|Bnee		thev firs f) {style"in[v]seia0browsere aich
n'tl ?s	unreliabce	v	r eeex ot f) {getCvmputsFStyle sirit lyh,
		s blis to ent reliabce	-1 ]wxtyle
		v	r eIsBo dn Box = isBo dn Box tri( jQuery.sentLoa.boxSizmodReliabce	||	v	ri{==	-1 ]wxtyle[0n
		)]ufv

		ot N) mrlize "",iauto, ed:aprepane f) {-x ;a
		v	ri=	parseFlond( v	ri)s||	0 
	}

=ry use[withacti	eubox-sizmodim	} lseo	add/sub ;act irrelevat  styles
=r'll ? ( v	ri+
		augm		vWidirOrHeight	
xee-1 ],
			p
		,
			-x ;a)||0(sisBo dn Box ? "bo dn bl: "vventst";),
			rer eIsBo dn Box
		)
	) + "px" 
}


ot Try	to dutermineDent default dixpcayuv	r eiofta
deoLoit 
 fer ) { css_defaultDixpcaya	{rCaN
		u= c
	peof -1 ]dixpcay[	{rCaN
		u]des 
xer'll ? ue )dixpcay[	{rCaN
		u];
	}

=re vue )	=:jQuery	 "< i+ erCaN
		i+ ">" f.aguendTof dntEleme.body f,
		dixpcayu= ue )wcss("dixpcay"f;
	-1 ]wed)
	etr 

=/t Ifa,	e+simpcW waytfailo,
=ry getdeoLoit 'osr'	ridefault dixpcayuby at achrn e	t eo	a temp ifr
		
tpeof dixpcayu=&& "n
n	"v||	dixpcayu=&& ""v {

		ot Use[withalready-crea	etsifr
		  {
possi() 
xeifr
		 = dntEleme.body.aguendChild(
=ttper
		 ||	jQuery.uxntsd(	dntEleme.	rea	eEmatche	"per
		 ), 

				er
		Bo dn : 0,
		e=widir: 0,
		e=height: 0
			t)
		fv

		ot Crea	e"av h ||able	vvpyroftent per
		 dntEleme  { fio fi:
		.
 !ot IE ed:aOperaa ihe ell neus	to reuse[ent per
		Doce argouv re-wria	disent faklDHTML
 !ot dntEleme eo	it;lWebKit & Firefox wo Th ell nereus	disent per
		 dntEleme.
=tpeof !per
		Doce||	!per
		.	rea	eEmatche fn.
xeeper
		Doce& ( ier
		.	ventstWiddewe||	ier
		.	ventstDntElemea).entEleme;
		eper
		Doc.wriae("<!enttisWihtml><html><body>");
xeeper
		Doc.close()v
		}

		ue )	=:per
		Doc.body.aguendChild(:per
		Doc.	rea	eEmatche	erCaN
		)ufv

		dixpcayu= curCSS( ue ),l"dixpcay"ie 
		dntEleme.body.ed)
	eChild( per
		 )v
	}

=ry Storeeent  vrr
		 default dixpcay
	-1 ]dixpcay[	{rCaN
		u]d= dixpcay 

=r'll ? dixpcay 
}

jQuery.uach([ "height",i"widir"v],;f key, vali, n
		)fn.
	jQuery.cssHooks[0n
		)]d=:.
		gee:;) {
					iue ),lcvmputsF,iex ;a es 
 !	 {
		 vmputsF	fn.
				ot c rta	Qt
oLoit ose g ha	esdioits, v infos {
ferinvisibce sh n entm
=t	tot howev r,[jtemu	pdha	esa currist	dixpcayuxtyleitand f ul		benefit fr	ems ieex !	peof -1 ] offs{lWidir =&& 0uredrdixpcayswrg. {
			curCSS( ue ),l"dixpcay"ien {es 
 !		=r'll ? jQuery.swrg	iue ),lcssSh n, f key, vaes 
xe!		=r'll ? geeWidirOrHeight	iue ),ln
		, -x ;a)f 
					}) 
				} ire( 

					r'll ? geeWidirOrHeight	iue ),ln
		, -x ;a)f 
				t
			}
		},

		see:;) {
					iue ),lv	r e,iex ;a es 
 !en'tl ? setPosi )veNumb.r( ue ),lv	r e,iex ;a ?
				augm		vWidirOrHeight	
xeeee-1 ],
					p
		,
					-x ;a,
					jQuery.sentLoa.boxSizmoditrijQuery.css( ue ),l"boxSizmod"ies	&& "bo dn -box"
				f;:	0
			) 
		}
	};
}) 

peof !jQuery.sentLoa.opacitedfn.
	jQuery.cssHooks.opacited=	.
		gee:;) {
					iue ),lcvmputsF fn.
			ot IE uses filternneed 
pacite
			r'll ? a
pacite. {
			(cvmputsF redue ).curristStylev? ue )wcurristStyle.filter : ue )wstyle.filter)i||0"ble ?
				( 0.01 *	parseFlond( RegExp.$1i)u)s+o"bl:
				cvmputsF ? "1"n: "" 
		},

		see:;) {
					iue ),lv	r eof c
			v	 {style"=	-1 ]wxtyle,
				curristStylev
 ue )wcurristStyle,
				opacited=	jQuery.isNumeric		v	r eof ? "alphr(opacite= i+ v	r eo* 100*+ ")"n: "",
				filter = curristStyle redcurristStyle.filter ||0style.filter ||0"" 
ex !ot IE hasitroubl e arg opacitedifai, ioMs uotsha	escayouvex 	ot Fedcsai, by neta	disent zoom luv	lex 	style.zoom = 1 
ex !ot ifaseta	disepacitedeo	1, ed:anosorun tfilternnexis ;-
at e	se	to re)
	eufilter at [ bu
e #6652
 !	 {
		v	r eo>,
1"th jQuery.nrim(ufilter
, "" );
	ralphr,0"bler)u=&& ""vtr
				style.ed)
	eAt [ bu
ei {


=t	tot Seta	disstyle.filter eo nuom,d""vt " " stihe lea	es"filter:"  ea hevcssTtmp
=t	tot  {
"filter:"  sipres		vdeh ell, lle=r.isWi sidixabled,
ferwanp eo	avoiduenieex !	ot style.ed)
	eAt [ bu
ei siIE Once, but soeappanemelyu		/} 		/c	} uparg...
				style.ed)
	eAt [ bu
e(
"filter"ie 

=t	tot  {
s ere
s ere
		/uoufilter style"rgulie		insa cssirul ,
ferarerdnn ex !	peof curristStyle red!curristStyle.filter es 
 !		=r'll ? 
				t
			}
ex !ot orun wise,vs{ldpew	filter v	r eeex 	style.filter = ralphr. {
			filter es?
				filter
, "" );
	ralphr,0opacitedfn:
				filter + " " +0opacite 
		}
	};
}

ot Tntse[hooksie guotsb "rddid;until DOM readyebecause[,	e+sentLoa  {
	
ot f) {it/		/uotsrun;until rfteriDOM ready
jQuery(f key, vafn.
	peof !jQuery.sentLoa.reliabceMargi{Right es 
 !jQuery.cssHooks.margi{Right =  
xe	gee:;) {
					iue ),lcvmputsF	fn.
				ry WobKit Bug 13343;-
getCvmputsFStyle n'tl ?s	wrodisv	r e f) {margi{-right
				ry Work"arpund;byu}e	sorarily neta	diseoLoit  dixpcayueo	irlmoe-block
!		=r'll ? jQuery.swrg	iue ),l{l"dixpcay":	(inlmoe-block" }, f key, vaes 
xe!		 {
		 vmputsF	fn.
				=	null ? vurCSS( ue ),l"margi{Right"r) 
					t
				tfv
	=t}
		}v
	}

=ry Webkit/bug:
https://bugs.webkit.org/sh n_bug.cgi?id=29084
=ry getCvmputsFStyle n'tl ?s	percemeiw reaxid
	fime f) {}op/left/bottom/right
	ot narun ttha? makea hevcssim	}ul  dere
		on{s e offs{ldm	}ul ,
ferj sst firs f) {it"here
=peof !jQuery.sentLoa.pixelPosi ) {	th jQuery.fn.posi ) {	es 
 !jQuery.uach( [ "top",i"left" ]a;f key, vali, prop	fn.
			jQuery.cssHooks[0prop	]d=:.
		e	gee:;) {
					iue ),lcvmputsF	fn.
					 {
		 vmputsF	fn.
				=	re vn't
=mcurCSS( ue ),lprop	f 
					tot  {
vurCSS n'tl ?s	percemeage,lflilblis to offs{l
				=	null ? rnumn
npx. {
			n'td)o?:jQuery	 ue )uf.posi ) {()[0prop	]d+ "px"n: arg 
xee		t
				t
			} 
		})v
	}

}) 

peof jQuery.uxpr	th jQuery.uxpr.filternnfn.
	jQuery.uxpr.filtern.hiddens= f key, value )ufn.
		r'll ? ( -1 ] offs{lWidir =&& 0uredue )woffs{lHeight =&& 0ufn !=(!jQuery.sentLoa.reliabceHiddenOffs{lsitri((-1 ]wxtyle"redue ).xtyle.dixpcayfn !=curCSS( ue ),l"dixpcay"iees	&& "n
n	")l
	};

	jQuery.uxpr.filtern.visibces= f key, value )ufn.
		r'll ? !jQuery.uxpr.filtern.hidden( ue )ufv
	};
}

ot Tntse[hooksiareruce		by anima/eoateexpto  propertits
jQuery.uach({
	margi{: "",
	pjddmod: "",
	bo dn : "Widir"
}, f key, valprefix,usuf		x)fn.
	jQuery.cssHooks[0prefixd+ suf		x)]d=:.
		expto :;) {
					iv	r eof c
			v	 {i,

=t	tot assu		s*a s	dile numb.r{ {
uotsa;sturn 
=t	tpartsi=;,"obofiv	r ei==,
"sturn  i? v	r e.xpcet(" "f;:	[iv	r ei],
				expto ed = {} 

			f) {
	i7{ 0;v+e< 4;++ue = c
				expto ed[0prefixd+ cssExpto [ ii]i+ suf		x)]d=
xee		parts[ ii]i !=pants[ ii- 2 e;||	pants[ 0)];
			t

			r'll ? expto ed 
		}
	};

=peof !rmargi{. {
			prefixd) es 
 !jQuery.cssHooks[0prefixd+ suf		x)].net = setPosi )veNumb.r 
	}
}) 
re vn20	=;/%20/g,
	rbrliset = /\[\]$/,
	rCRLF = /\r?\n/g,
	rinpu
	=;/^(?:color|da	e|da	etime|da	etime-local|email|hidden|month|numb.r|pjecwo d|range|search|tel|}tmp|time|url|week)$/i,
	rx{;
		Ttmparia	=;/^(?:x{;
		|ntmparia)/i;

jQuery.fn.uxntsd({
	serirlize: f key, vaes 
xen'tl ? jQuery.panam( , ie)serirlizeAhrae()i) 
	},
	serirlizeAhrae: f key, vaes 
xen'tl ? , ie)mrg	f key, vae 
 !en'tl ? , ie)
oLoit os?:jQuery.makeAhrae( , ie)
oLoit os)i: , ie 
		})
		.filter	f key, vae 
 !en'tl ? , ie)n
		)tri!, ie)dixabledn&&
				a , ie)vhirse	"||	rs{;
		Ttmparia. {
			, ie)nrCaN
		u= ||
=t !eninpu
. {
			, ie)nion")de 
		})
		.mrg	f key, vali, ue )ufc
			v	 {v	ri=	jQuery	 , ie ).v	r(e 

=t	r'll ? v	ri{=mnt.do?
				nt.do:
				jQuery.isAhrae( v	ri)s?
					jQuery.mrg	vv	r, ) {
					iv	r, ii).
				=	null ? {ln
		: ue )wn
		, v	r e: v	r
, "" );
	rCRLF,l"\r\{"v {} 
					})n:
		 =t{ln
		: ue )wn
		, v	r e: v	r
, "" );
	rCRLF,l"\r\{"v {} 
		}).g'	();
	}
}) 

otSerirlizeta
dthrae o{
fedmt
oLoit os) {aes{ldof
otkey/v	r es 	Qateaequerynsturn 
jQuery.panams= f key, vala,; ;adia) {	rifn.
	re vprefix,
		s 
 []a
xeaddi= f key, valkey,lv	r eof c
			/t Ifav	r eo		/a f key, v, irvoke[jteend r'll ?[jts v	r e
=t	v	r e = jQuery.isrned.prot v	r eof ? v	r e()i: f v	r ei{=	nt.do?0"bl: v	r eifl
			s[ s)			firu]d= -nc	} URICvmp
n	de( keye)d+ "= i+ -nc	} URICvmp
n	de( v	r eifl
		};

=ry S{tB ;adia) {	rito er e f) {jQueryn<= 1.3.2 beha	ied.
=peof  ;adia) {	ri{={;undefinsF	fn.
		 ;adia) {	ri{ jQuery.ajaxSeta	dis	th jQuery.ajaxSeta	dis. ;adia) {	rv
	}

=ry Ifta
dthrae wasipjece		in,	assu		aenat it"		/a
dthrae o{
fedmt
oLoit o.
=peof jQuery.isAhrae( aufn !=( a.jqueryitri!jQuery.isPlainObj
		( aufn) es 
 !ry S{rirlizetwith,odmt
oLoit o
 !jQuery.uach( a, f key, vaes 
xe!add( , ie)n
		,	, ie.v	r eifl
		}) 

!}fire(  
xe/t Ifa,;adia) {	r, -nc	} es e "old" wayt(s e wayt1.3.2 ed 
ld.r
=tot didiit),iorun wise	-nc	} epanamosr'curs)vely.
		f) {
	prefixdinsa es 
xe!buildPanamoalprefix,ua[0prefixd],a,;adia) {	r, addi) 
		}
	}

=ry Retl ? , e0resula	diss{rirliza	) {
xn'tl ? s.joiot "&" f., "" );
	r20,l"+"r) 
} 

 fer ) { buildPanamoalprefix,uobj,a,;adia) {	r, addi)n.
	re vp
		;

=peof jQuery.isAhrae( objn) es 
 !ry S{rirlizetthrae it )w
 !jQuery.uach( obj,af key, vali, v*fn.
			peof  ;adia) {	ri||	rbrliset. {
			prefixd) es 
 !	tot Trea	tuach thrae it ) asia0scalar.
				add( prefix,uv*f 

=t	} ire( 

				ry Iftahrae it ) 		/n
n-scalar (thrae or"obj
		), -nc	} eiteex !	ot numericu+rr,  to resnlve des{rirliza	) { ambiguitedissues.ex !	ot No	eaenat rlis (ts o{
1.0.0)ee gh, curristly des{rirlizeex !	ot n{
	idnehraesiproperce, ed:aat e	se	diseo do soemayuv]uce
=t	tot ass{rverDurrac. Possi() efixes arereo modify rlis'eex !	ot des{rirliza	) { algorithm ed  oiprovidi/a
dop// s ed flagex !	ot atefedcsathrae s{rirliza	) { eo	b "shell n.ex !	buildPanamoalprefixd+ "["s+of ,"obofivi==,
"obj
		 i? in: ""e)d+ "]", v,a,;adia) {	r, addi) 
		t}
		}=v

!}fire(  {
		! ;adia) {	rith jQuery.n"ob( objn) ==,
"obj
		 ies 
 !ry S{rirlizetobj
		 it )w
 !f) {
	{
		i	Q	obj es 
xe!buildPanamoalprefixd+ "["s+on
		i+ "]", obj[0n
		)],a,;adia) {	r, addi) 
		}

!}fire(  
xe/t S{rirlizetscalar it )w
 !add( prefix,uobj e;
	}
}
re 
!ot DotElemealoca	) {
xajaxLocPants,
xajaxLoca	) {,

=rhasie=	/#.*$/,
	rheadernn=;/^(.*?):[ \t]*([^\r\{]*)\r?$/mg, ot IE lea	e	/a
d\rvcha;acter at EOL
!ot #7653, #8125, #8152:aloca		protocol dutec	) {
xnloca	Protocol =;/^(?:ebouv|app|app\-storage|.+\-uxntss/ s|file|res|widg'	):$/,
	rnoCventst =;/^(?:GET|HEAD)$/,
	rprotocol =;/^\/\//,
	rqueryi= /\?/,
	rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
	rtsi=;/([?&])_=[^&]*/,
	rurl =;/^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/,

!ot Keep"av vpyroftent olF	load ] 	hod
	_load 
 jQuery.fn.load,

!o* Prefiltern
	o* 1) Tntyiarerucefulueo	irtroduce[vustomvdscr.isWs (se. ajax/jsonp.js fed an exampcW)
	o* 2) Tntse[ethecelled:
	o*    - BEFORE assmodif) {aetranstLoa
	o*    - AFTERepanam s{rirliza	) { (e)dscru		/a sturn e	f s.processDscru		/er e)
	o* 3) keyeinns e dscr.isW
	o* 4)a hevca fiahe symbol "*"se g beuuce	
	o* 5)dexecut) {  ihe s arte arg transtLoa dscr.isW ed:aTHEN 		}ninue dow{ eo	"*"s	fvpeede	
	o*/
	prefiltern =	{}a
exo* TranstLoas biddmodn
	o* 1) keyeinns e dscr.isW
	o* 2)a hevca fiahe symbol "*"se g beuuce	
	o* 3) s{;
		) {  ihe s arte arg transtLoa dscr.isW ed:aTHEN go eo	"*"s	fvpeede	
	o*/
	transtLoas =	{}a
exot Avoiduvom]it -prologvcha; s{quehc u(#10098);emu	pdague]seili	vded:aevade	 vmpress/ s
 ahe.isWs 
 ["*/"]i+ ["*"] 

ot #8138, IE mayus r n an excep/) {   reaaccessrn 
ot asfielF	fr	em